/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class BufferedByteWriter {
    ByteArrayOutputStream buffer;

    public BufferedByteWriter() {
        this(8192);
    }

    public BufferedByteWriter(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buffer = new ByteArrayOutputStream(size);
    }

    public byte[] getBytes() {
        return this.buffer.toByteArray();
    }

    public int bytesWritten() {
        return this.buffer.size();
    }

    public void put(int b) throws IOException {
        this.buffer.write(b);
    }

    public void put(byte[] b) throws IOException {
        this.buffer.write(b);
    }

    public void put(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
    }

    public void putInt(int v) throws IOException {
        this.buffer.write(v >>> 0 & 0xFF);
        this.buffer.write(v >>> 8 & 0xFF);
        this.buffer.write(v >>> 16 & 0xFF);
        this.buffer.write(v >>> 24 & 0xFF);
    }

    public void putFloat(float f) throws IOException {
        int v = Float.floatToIntBits(f);
        this.putInt(v);
    }

    public void putLong(long v) throws IOException {
        this.buffer.write((byte)(v >>> 0));
        this.buffer.write((byte)(v >>> 8));
        this.buffer.write((byte)(v >>> 16));
        this.buffer.write((byte)(v >>> 24));
        this.buffer.write((byte)(v >>> 32));
        this.buffer.write((byte)(v >>> 40));
        this.buffer.write((byte)(v >>> 48));
        this.buffer.write((byte)(v >>> 56));
    }

    public void putNullTerminatedString(String s) throws IOException {
        this.buffer.write(s.getBytes());
        this.buffer.write(0);
    }
}

