/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.SeekableBufferedStream;
import net.sf.samtools.util.SeekableStream;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.WrappedIterator;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.stream.IGVUrlHelper;
import org.broad.igv.util.stream.SeekablePicardStream;
import org.broad.tribble.util.SeekableFTPStream;
import org.broad.tribble.util.SeekableHTTPStream;

public class BAMHttpReader
implements AlignmentReader {
    static Logger log = Logger.getLogger(BAMHttpReader.class);
    public static final long oneDay = 86400000L;
    static Hashtable<String, File> indexFileCache = new Hashtable();
    URL url;
    SAMFileHeader header;
    File indexFile;
    SAMFileReader reader;

    public BAMHttpReader(ResourceLocator locator, boolean requireIndex) throws IOException {
        this.url = new URL(locator.getPath());
        if (requireIndex) {
            this.indexFile = this.getIndexFile(this.url, locator.getIndexPath());
            if (this.indexFile == null) {
                throw new RuntimeException("Could not load index file for file: " + this.url.getPath());
            }
            SeekableStream ss = this.getSeekableStream(this.url);
            this.reader = new SAMFileReader(ss, this.indexFile, false);
        } else {
            InputStream is = HttpUtils.getInstance().openConnectionStream(this.url);
            this.reader = new SAMFileReader(new BufferedInputStream(is));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public SAMFileHeader getHeader() {
        if (this.header == null) {
            this.header = this.reader.getFileHeader();
        }
        return this.header;
    }

    @Override
    public boolean hasIndex() {
        return this.indexFile != null && this.indexFile.exists();
    }

    @Override
    public Set<String> getSequenceNames() {
        SAMFileHeader header = this.getHeader();
        if (header == null) {
            return null;
        }
        HashSet<String> seqNames = new HashSet<String>();
        List<SAMSequenceRecord> records = header.getSequenceDictionary().getSequences();
        if (records.size() > 0) {
            for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                String chr = rec.getSequenceName();
                seqNames.add(chr);
            }
        }
        return seqNames;
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        try {
            if (this.reader == null) {
                InputStream is = HttpUtils.getInstance().openConnectionStream(this.url);
                this.reader = new SAMFileReader(new BufferedInputStream(is));
            }
            return new WrappedIterator(this.reader.iterator());
        }
        catch (IOException e) {
            log.error("Error creating iterator", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) {
        try {
            if (this.reader == null) {
                SeekableBufferedStream ss = new SeekableBufferedStream(this.getSeekableStream(this.url));
                this.reader = new SAMFileReader(ss, this.indexFile, false);
            }
            SAMRecordIterator iter = this.reader.query(sequence, start + 1, end, contained);
            return new WrappedIterator(iter);
        }
        catch (IOException e) {
            log.error("Error opening SAM reader", e);
            throw new RuntimeException("Error opening SAM reader", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SeekableStream getSeekableStream(URL url) throws IOException {
        String protocol = url.getProtocol().toLowerCase();
        SeekablePicardStream is = null;
        if (protocol.equals("http") || protocol.equals("https")) {
            HttpUtils.getInstance();
            boolean useByteRange = HttpUtils.useByteRange(url);
            if (!useByteRange) throw new RuntimeException("Byte-range requests are disabled.  HTTP and FTP access to BAM files require byte-range support.");
            SeekableHTTPStream tribbleStream = new SeekableHTTPStream(new IGVUrlHelper(url));
            String source = url.toExternalForm();
            return new SeekablePicardStream(tribbleStream, source);
        }
        if (!protocol.equals("ftp")) throw new RuntimeException("Unknown protocol: " + protocol);
        SeekableFTPStream tribbleStream = new SeekableFTPStream(url);
        String source = url.toExternalForm();
        return new SeekablePicardStream(tribbleStream, source);
    }

    public static void cleanTempDir(Long timeLimit) {
        if (timeLimit == null) {
            timeLimit = 86400000L;
        }
        File dir = DirectoryManager.getCacheDirectory();
        File[] files = dir.listFiles();
        long time = System.currentTimeMillis();
        for (File f : files) {
            long age = time - f.lastModified();
            if (age <= timeLimit) continue;
            f.delete();
        }
    }

    File getIndexFile(URL url, String indexPath) throws IOException {
        String urlString = url.toString();
        this.indexFile = this.getTmpIndexFile(urlString);
        long age = System.currentTimeMillis() - this.indexFile.lastModified();
        if (age > 86400000L) {
            this.indexFile.delete();
        }
        if (!this.indexFile.exists() || this.indexFile.length() < 1L) {
            this.loadIndexFile(urlString, indexPath, this.indexFile);
            this.indexFile.deleteOnExit();
        }
        return this.indexFile;
    }

    private File getTmpIndexFile(String bamURL) throws IOException {
        File indexFile = indexFileCache.get(bamURL);
        if (indexFile == null) {
            indexFile = File.createTempFile("index_", ".bai", DirectoryManager.getCacheDirectory());
            indexFile.deleteOnExit();
            indexFileCache.put(bamURL, indexFile);
        }
        return indexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndexFile(String path, String indexPath, File indexFile) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int bytesRead;
            String idx = indexPath != null && indexPath.length() > 0 ? indexPath : path + ".bai";
            URL indexURL = new URL(idx);
            os = new FileOutputStream(indexFile);
            try {
                is = HttpUtils.getInstance().openConnectionStream(indexURL);
            }
            catch (FileNotFoundException e) {
                String baseName = path.substring(0, path.length() - 4);
                indexURL = new URL(baseName + ".bai");
                try {
                    is = HttpUtils.getInstance().openConnectionStream(indexURL);
                }
                catch (FileNotFoundException e1) {
                    MessageUtils.showMessage("Index file not found for file: " + path);
                    throw new DataLoadException("Index file not found for file: " + path, path);
                }
            }
            byte[] buf = new byte[512000];
            while ((bytesRead = is.read(buf)) != -1) {
                os.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

