/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;
import org.broad.tribble.util.SeekableStream;

public class IGVSequence
implements Sequence {
    private static Logger log = Logger.getLogger(IGVSequence.class);
    private String dirPath;
    private Map<String, String> chrFileNameCache = new HashMap<String, String>();

    public IGVSequence(String dirPath) {
        if (!dirPath.endsWith("/")) {
            dirPath = dirPath + "/";
        }
        this.dirPath = dirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readSequence(String chr, int start, int end) {
        String fn = chr + ".txt";
        fn = this.getChrFileName(fn);
        String seqFile = this.dirPath + fn;
        SeekableStream is = null;
        try {
            is = IGVSeekableStreamFactory.getStreamFor(seqFile);
            byte[] bytes = new byte[end - start];
            is.seek(start);
            is.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception ex) {
            log.error("Error reading genome sequence from: " + seqFile, ex);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    log.error("Error closing sequence file.", ex);
                }
            }
        }
    }

    private String getChrFileName(String fn) {
        String chrFN = this.chrFileNameCache.get(fn);
        if (chrFN == null) {
            chrFN = FileUtils.legalFileName(fn);
            this.chrFileNameCache.put(fn, chrFN);
        }
        return chrFN;
    }
}

