/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.compression;

import com.google.protobuf.GeneratedMessage;
import edu.cornell.med.icb.goby.compression.MessageChunksReader;
import edu.cornell.med.icb.goby.exception.GobyRuntimeException;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.commons.io.IOUtils;

public class FastBufferedMessageChunksReader
extends MessageChunksReader {
    private final long end;
    private final FastBufferedInputStream input;
    private long startOffset;
    private long endOffset;

    public FastBufferedMessageChunksReader(long start, long end, FastBufferedInputStream input) throws IOException {
        this.startOffset = start;
        this.endOffset = end;
        if (start < 0L) {
            throw new IllegalArgumentException("Start position (" + start + ") must not be less than zero");
        }
        if (end != Long.MAX_VALUE && end < 0L) {
            throw new IllegalArgumentException("End position (" + end + ") must not be less than zero");
        }
        if (start > end) {
            throw new IllegalArgumentException("Start position (" + start + ") must not be greater than the end position (" + end + ")");
        }
        if (end != Long.MAX_VALUE && start != end) {
            end += 11L;
        }
        this.end = end;
        this.input = input;
        this.reposition(start, end);
    }

    private void reposition(long start, long end) throws IOException {
        int b;
        assert (end >= start) : "end must be larger than start ";
        this.input.position(start);
        int contiguousDelimiterBytes = 0;
        long skipped = 0L;
        long position = 0L;
        while ((b = this.input.read()) != -1) {
            byte c = (byte)b;
            contiguousDelimiterBytes = c == -1 ? ++contiguousDelimiterBytes : 0;
            ++skipped;
            if (contiguousDelimiterBytes == 7) {
                if (this.hasFF(this.input)) {
                    ++skipped;
                }
                if (skipped >= 8L) {
                    this.in = new DataInputStream(this.input);
                    long seekPosition = start + skipped - 7L - 1L;
                    this.input.position(seekPosition);
                    break;
                }
            }
            position = start + skipped;
        }
    }

    private boolean hasFF(FastBufferedInputStream input) throws IOException {
        int b;
        byte code;
        return input.available() >= 1 && (code = (byte)(b = input.read())) == -1;
    }

    public void seek(long position) throws IOException {
        this.reposition(position, Long.MAX_VALUE);
    }

    @Override
    public boolean hasNext(GeneratedMessage collection, int collectionSize) {
        if (collection == null || this.entryIndex >= collectionSize) {
            if (this.input != null) {
                try {
                    if (this.input.position() >= this.end) {
                        return false;
                    }
                }
                catch (IOException e) {
                    throw new GobyRuntimeException(e);
                }
            }
            return this.in != null && super.hasNext(collection, collectionSize);
        }
        this.compressedBytes = null;
        return this.entryIndex < collectionSize;
    }

    @Override
    public void close() {
        super.close();
        IOUtils.closeQuietly(this.input);
    }

    @Override
    public long position() throws IOException {
        return this.input.position();
    }
}

