/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.svg.SVGGraphics;
import org.broad.igv.ui.util.MessageUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGTest {
    public static void main(String[] args) throws IOException {
        SVGTest.test2();
    }

    private static void test1() throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter("test.svg"));
        pw.println("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n\n<svg width=\"100%\" height=\"100%\" version=\"1.1\"\nxmlns=\"http://www.w3.org/2000/svg\">");
        SVGGraphics g2d = new SVGGraphics(pw, new Rectangle(0, 0, 500, 500));
        SVGTest.draw(g2d);
        pw.print("</svg>");
        pw.close();
    }

    private static void draw(Graphics2D g2d) {
        g2d.clipRect(5, 5, 350, 350);
        g2d.setFont(FontManager.getFont(1, 24));
        g2d.drawString("Hello World", 0, 20);
        g2d.setColor(Color.red);
        g2d.fillRect(10, 10, 50, 100);
        g2d.drawRect(100, 10, 50, 100);
        g2d.setColor(Color.blue);
        g2d.drawRect(100, 60, 100, 50);
        g2d.setColor(Color.lightGray);
        int[] x = new int[]{220, 300, 170, 123};
        int[] y = new int[]{100, 210, 250, 234};
        g2d.fillPolygon(x, y, x.length);
        g2d.setColor(Color.green);
        g2d.drawLine(200, 200, 400, 400);
        AffineTransform tr = new AffineTransform();
        tr.rotate(1.5707963267948966);
        tr.translate(0.0, -20.0);
        g2d.setTransform(tr);
        g2d.setColor(Color.black);
        g2d.drawString("Hello World", 0, 0);
    }

    private static void test2() {
        File selecteddFile = new File("test2.svg");
        try {
            DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
            String svgNS = "http://www.w3.org/2000/svg";
            Document document = domImpl.createDocument(svgNS, "svg", null);
            SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
            SVGTest.draw(svgGenerator);
            BufferedWriter out = new BufferedWriter(new FileWriter(selecteddFile));
            svgGenerator.stream(out, false);
        }
        catch (Exception e) {
            MessageUtils.showMessage("Error encountered creating SVG file: " + e.toString());
        }
    }
}

