/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.sam.reader.MergedAlignmentReader;
import org.broad.igv.tools.parsers.DataConsumer;
import org.broad.igv.ui.filefilters.AlignmentFileFilter;
import org.broad.igv.util.FileUtils;

public class CoverageCounter {
    private String alignmentFile;
    private DataConsumer consumer;
    private int windowSize = 1;
    private int minMappingQuality = 0;
    static final int STRANDS_BY_READ = 1;
    static final int STRANDS_BY_FIRST_IN_PAIR = 2;
    static final int STRANDS_BY_SECOND_IN_PAIR = 4;
    static final int BASES = 8;
    public static final Integer INCLUDE_DUPS = 32;
    private boolean outputSeparate;
    private boolean firstInPair;
    private boolean secondInPair;
    private boolean outputBases;
    private static final int[] output_strands = new int[]{0, 1};
    public static final int NUM_STRANDS = output_strands.length;
    private int extFactor;
    private boolean includeDuplicates = false;
    private Genome genome;
    private File wigFile = null;
    private int totalCount = 0;
    private Locus interval;
    private float[] buffer;
    private boolean computeTDF = true;
    private static final Set<Byte> nucleotidesKeep = new HashSet<Byte>();
    private static final byte[] nucleotides;

    public CoverageCounter(String alignmentFile, DataConsumer consumer, int windowSize, int extFactor, File wigFile, Genome genome, String queryString, int minMapQual, int countFlags) {
        this.alignmentFile = alignmentFile;
        this.consumer = consumer;
        this.windowSize = windowSize;
        this.extFactor = extFactor;
        this.wigFile = wigFile;
        this.genome = genome;
        this.parseOptions(queryString, minMapQual, countFlags);
        int multiplier = this.outputBases ? 5 : 1;
        int datacols = (this.outputSeparate ? 2 : 1) * multiplier;
        this.buffer = new float[datacols];
    }

    private void parseOptions(String queryString, int minMapQual, int countFlags) {
        if (queryString != null) {
            this.interval = new Locus(queryString);
        }
        this.minMappingQuality = minMapQual;
        this.outputSeparate = (countFlags & 1) > 0;
        this.firstInPair = (countFlags & 2) > 0;
        this.secondInPair = (countFlags & 4) > 0;
        this.outputSeparate |= this.firstInPair || this.secondInPair;
        if (this.firstInPair && this.secondInPair) {
            throw new IllegalArgumentException("Can't set both first and second in pair");
        }
        this.outputBases = (countFlags & 8) > 0;
        this.includeDuplicates = (countFlags & INCLUDE_DUPS) > 0;
    }

    private boolean passFilter(Alignment alignment) {
        boolean pairingInfo = !this.firstInPair && !this.secondInPair || alignment.getFirstOfPairStrand() != Strand.NONE;
        return alignment.isMapped() && pairingInfo && (this.includeDuplicates || !alignment.isDuplicate()) && alignment.getMappingQuality() >= this.minMappingQuality && !alignment.isVendorFailedRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse() throws IOException {
        int tolerance = (int)((double)this.windowSize * (Math.floor(this.extFactor / this.windowSize) + 2.0));
        this.consumer.setSortTolerance(tolerance);
        AlignmentReader reader = null;
        CloseableIterator<Alignment> iter = null;
        String lastChr = "";
        ReadCounter counter = null;
        WigWriter wigWriter = null;
        if (this.wigFile != null) {
            wigWriter = new WigWriter(this.wigFile, this.windowSize);
        }
        try {
            if (this.interval == null) {
                reader = this.getReader(this.alignmentFile, false);
                iter = reader.iterator();
            } else {
                reader = this.getReader(this.alignmentFile, true);
                iter = reader.query(this.interval.getChr(), this.interval.getStart() - 1, this.interval.getEnd(), false);
            }
            while (iter != null && iter.hasNext()) {
                AlignmentBlock[] blocks;
                Strand strand;
                Alignment alignment = (Alignment)iter.next();
                if (!this.passFilter(alignment) || (strand = this.firstInPair ? alignment.getFirstOfPairStrand() : (this.secondInPair ? alignment.getSecondOfPairStrand() : alignment.getReadStrand())).equals((Object)Strand.NONE)) continue;
                boolean readNegStrand = alignment.isNegativeStrand();
                ++this.totalCount;
                String alignmentChr = alignment.getChr();
                if (alignmentChr.equals(lastChr)) {
                    if (counter != null) {
                        counter.closeBucketsBefore(alignment.getAlignmentStart() - tolerance, wigWriter);
                    }
                } else {
                    if (counter != null) {
                        counter.closeBucketsBefore(Integer.MAX_VALUE, wigWriter);
                    }
                    counter = new ReadCounter(alignmentChr);
                    lastChr = alignmentChr;
                }
                if ((blocks = alignment.getAlignmentBlocks()) != null) {
                    int lastBlockEnd = -1;
                    for (AlignmentBlock block : blocks) {
                        if (block.isSoftClipped()) continue;
                        byte[] bases = block.getBases();
                        int blockStart = block.getStart();
                        int adjustedStart = block.getStart();
                        int adjustedEnd = block.getEnd();
                        if (readNegStrand) {
                            adjustedStart = Math.max(0, adjustedStart - this.extFactor);
                        } else {
                            adjustedEnd += this.extFactor;
                        }
                        if (this.interval != null) {
                            adjustedStart = Math.max(this.interval.getStart() - 1, adjustedStart);
                            adjustedEnd = Math.min(this.interval.getEnd(), adjustedEnd);
                        }
                        for (int pos = adjustedStart; pos < adjustedEnd; ++pos) {
                            int idx;
                            byte base = 0;
                            int baseIdx = pos - blockStart;
                            if (bases != null && baseIdx >= 0 && baseIdx < bases.length) {
                                base = bases[baseIdx];
                            }
                            byte quality = (idx = pos - blockStart) >= 0 && idx < block.qualities.length ? block.qualities[pos - blockStart] : (byte)0;
                            counter.incrementCount(pos, base, quality, strand);
                        }
                        lastBlockEnd = block.getEnd();
                    }
                    continue;
                }
                int adjustedStart = alignment.getAlignmentStart();
                int adjustedEnd = alignment.getAlignmentEnd();
                if (readNegStrand) {
                    adjustedStart = Math.max(0, adjustedStart - this.extFactor);
                } else {
                    adjustedEnd += this.extFactor;
                }
                if (this.interval != null) {
                    adjustedStart = Math.max(this.interval.getStart() - 1, adjustedStart);
                    adjustedEnd = Math.min(this.interval.getEnd(), adjustedEnd);
                }
                for (int pos = adjustedStart; pos < adjustedEnd; ++pos) {
                    counter.incrementCount(pos, (byte)78, (byte)0, strand);
                }
            }
            this.consumer.setAttribute("totalCount", String.valueOf(this.totalCount));
            this.consumer.parsingComplete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (counter != null) {
                counter.closeBucketsBefore(Integer.MAX_VALUE, wigWriter);
            }
            if (iter != null) {
                iter.close();
            }
            if (reader != null) {
                reader.close();
            }
            if (wigWriter != null) {
                wigWriter.close();
            }
        }
    }

    private AlignmentReader getReader(String alignmentFile, boolean requireIndex) throws IOException {
        File f;
        if (!FileUtils.isRemote(alignmentFile) && (f = new File(alignmentFile)).isDirectory()) {
            ArrayList<AlignmentReader> readers = new ArrayList<AlignmentReader>();
            for (File file : f.listFiles(new AlignmentFileFilter())) {
                readers.add(AlignmentReaderFactory.getReader(file.getAbsolutePath(), requireIndex));
            }
            return new MergedAlignmentReader(readers);
        }
        return AlignmentReaderFactory.getReader(alignmentFile, requireIndex);
    }

    public String[] getTrackNames(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        String[] trackNames = new String[this.buffer.length];
        String[] strandArr = this.outputSeparate ? new String[]{"Positive Strand", "Negative Strand"} : new String[]{"Combined Strands"};
        int col = 0;
        for (String sA : strandArr) {
            if (this.outputBases) {
                byte[] arr$ = nucleotides;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Byte n = arr$[i$];
                    trackNames[col] = prefix + " " + sA + " " + new String(new byte[]{n});
                    ++col;
                }
                continue;
            }
            trackNames[col] = prefix + " " + sA;
            ++col;
        }
        return trackNames;
    }

    static {
        for (byte b : nucleotides = new byte[]{65, 67, 71, 84, 78}) {
            nucleotidesKeep.add(b);
        }
    }

    class WigWriter {
        String lastChr = null;
        int lastPosition = 0;
        int step;
        int span;
        PrintWriter pw;

        WigWriter(File file, int step) throws IOException {
            this.step = step;
            this.span = step;
            this.pw = new PrintWriter(new FileWriter(file));
        }

        public void addData(String chr, int start, int end, float[] data) {
            for (int i = 0; i < data.length; ++i) {
                if (!Float.isNaN(data[i])) continue;
                return;
            }
            if (CoverageCounter.this.genome.getChromosome(chr) == null) {
                return;
            }
            if (end <= start) {
                return;
            }
            int dataSpan = end - start;
            if (chr == null || !chr.equals(this.lastChr) || dataSpan != this.span) {
                this.span = dataSpan;
                this.outputHeader(chr, start + 1);
            }
            this.pw.print(start + 1);
            for (int i = 0; i < data.length; ++i) {
                this.pw.print("\t" + data[i]);
            }
            this.pw.println();
            this.lastPosition = start;
            this.lastChr = chr;
        }

        private void close() {
            this.pw.close();
        }

        private void outputHeader(String chr, int start) {
            String labels = "Pos";
            for (String s : CoverageCounter.this.getTrackNames("")) {
                labels = labels + "," + s;
            }
            this.pw.println("#Columns: " + labels);
            this.pw.println("variableStep chrom=" + chr + " span=" + this.span);
        }
    }

    class Counter {
        int[] strandCount = new int[NUM_STRANDS];
        int totalCount = 0;
        int qualityCount = 0;
        String chr;
        int start;
        int end;
        private Map<Byte, Integer>[] baseTypeCounts;

        Counter(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            if (CoverageCounter.this.outputBases) {
                this.baseTypeCounts = new HashMap[NUM_STRANDS];
                for (int ii = 0; ii < NUM_STRANDS; ++ii) {
                    this.baseTypeCounts[ii] = new HashMap<Byte, Integer>();
                }
            }
        }

        int getCount(int strand) {
            return this.strandCount[strand];
        }

        void increment(int position, byte base, byte quality, int strand) {
            if (CoverageCounter.this.outputBases) {
                this.incrementNucleotide(base, strand);
            }
            int n = strand;
            this.strandCount[n] = this.strandCount[n] + 1;
            ++this.totalCount;
            this.qualityCount += quality;
        }

        private void incrementNucleotide(byte base, int strand) {
            Map<Byte, Integer> btc = this.baseTypeCounts[strand];
            if (!nucleotidesKeep.contains(base)) {
                base = 0;
            }
            int orig = 0;
            if (btc.containsKey(base)) {
                orig = btc.get(base);
            }
            btc.put(base, orig + 1);
        }

        public int getTotalCounts() {
            return this.totalCount;
        }

        public int getBaseCount(byte base, int strand) {
            return this.baseTypeCounts[strand].containsKey(base) ? this.baseTypeCounts[strand].get(base) : 0;
        }

        public int getBaseCount(byte base) {
            int count = 0;
            for (int strand = 0; strand < NUM_STRANDS; ++strand) {
                count += this.getBaseCount(base, strand);
            }
            return count;
        }
    }

    class ReadCounter {
        String chr;
        TreeMap<Integer, Counter> counts = new TreeMap();

        ReadCounter(String chr) {
            this.chr = chr;
        }

        void incrementCount(int position, byte base, byte quality, Strand strand) {
            Counter counter = this.getCounterForPosition(position);
            int strandNum = strand.equals((Object)Strand.POSITIVE) ? 0 : 1;
            counter.increment(position, base, quality, strandNum);
        }

        private Counter getCounterForPosition(int position) {
            int idx = position / CoverageCounter.this.windowSize;
            return this.getCounter(idx);
        }

        private Counter getCounter(int idx) {
            if (!this.counts.containsKey(idx)) {
                int counterStartPosition = idx * CoverageCounter.this.windowSize;
                int counterEndPosition = counterStartPosition + CoverageCounter.this.windowSize;
                this.counts.put(idx, new Counter(this.chr, counterStartPosition, counterEndPosition));
            }
            Counter counter = this.counts.get(idx);
            return counter;
        }

        void closeBucketsBefore(int position, WigWriter wigWriter) {
            ArrayList<Integer> bucketsToClose = new ArrayList<Integer>();
            Integer bucket = position / CoverageCounter.this.windowSize;
            for (Map.Entry<Integer, Counter> entry : this.counts.entrySet()) {
                Chromosome chromosome;
                if (entry.getKey() >= bucket) continue;
                int bucketStartPosition = entry.getKey() * CoverageCounter.this.windowSize;
                int bucketEndPosition = bucketStartPosition + CoverageCounter.this.windowSize;
                if (CoverageCounter.this.genome != null && (chromosome = CoverageCounter.this.genome.getChromosome(this.chr)) != null) {
                    bucketEndPosition = Math.min(bucketEndPosition, chromosome.getLength());
                }
                int bucketSize = bucketEndPosition - bucketStartPosition;
                Counter counter = entry.getValue();
                int col = 0;
                if (!CoverageCounter.this.outputBases) {
                    if (CoverageCounter.this.outputSeparate) {
                        for (byte by : output_strands) {
                            ((CoverageCounter)CoverageCounter.this).buffer[col] = (float)counter.getCount(by) / (float)bucketSize;
                            ++col;
                        }
                    } else {
                        ((CoverageCounter)CoverageCounter.this).buffer[col] = (float)counter.getTotalCounts() / (float)bucketSize;
                        ++col;
                    }
                } else if (CoverageCounter.this.outputSeparate) {
                    for (byte by : output_strands) {
                        for (byte base : nucleotides) {
                            ((CoverageCounter)CoverageCounter.this).buffer[col] = (float)counter.getBaseCount(base, by) / (float)bucketSize;
                            ++col;
                        }
                    }
                } else {
                    for (byte by : nucleotides) {
                        ((CoverageCounter)CoverageCounter.this).buffer[col] = (float)counter.getBaseCount(by) / (float)bucketSize;
                        ++col;
                    }
                }
                CoverageCounter.this.consumer.addData(this.chr, bucketStartPosition, bucketEndPosition, CoverageCounter.this.buffer, null);
                if (wigWriter != null) {
                    wigWriter.addData(this.chr, bucketStartPosition, bucketEndPosition, CoverageCounter.this.buffer);
                }
                bucketsToClose.add(entry.getKey());
            }
            for (Integer key : bucketsToClose) {
                this.counts.remove(key);
            }
        }
    }
}

