/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.io.IOException;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.GFFParser;
import org.broad.igv.feature.tribble.FeatureFileHeader;
import org.broad.igv.renderer.SpliceJunctionRenderer;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.readers.LineReader;

public abstract class UCSCCodec
implements FeatureCodec {
    protected String[] tokens = new String[50];
    GFFParser.GFF3Helper tagHelper = new GFFParser.GFF3Helper();
    protected boolean gffTags = false;
    protected boolean spliceJunctions;
    FeatureFileHeader header;
    @Deprecated
    protected final int startOffsetValue = 0;

    @Override
    public Object readHeader(LineReader reader) {
        try {
            String line;
            while ((line = reader.readLine()) != null && (line.startsWith("#") || line.startsWith("track")) || line.startsWith("browser")) {
                this.readHeaderLine(line);
            }
            return this.header;
        }
        catch (IOException e) {
            throw new CodecLineParsingException("Error parsing header", e);
        }
    }

    protected boolean readHeaderLine(String line) {
        if (this.header == null) {
            this.header = new FeatureFileHeader();
        }
        if (line.startsWith("#type")) {
            String[] tokens = line.split("=");
            if (tokens.length > 1) {
                try {
                    this.header.setTrackType(TrackType.valueOf(tokens[1]));
                }
                catch (Exception e) {}
            }
        } else if (line.startsWith("#track") || line.startsWith("track")) {
            TrackProperties tp = new TrackProperties();
            ParsingUtils.parseTrackLine(line, tp);
            this.header.setTrackProperties(tp);
            this.gffTags = tp.isGffTags();
            Class rendererClass = tp.getRendererClass();
            if (rendererClass != null && rendererClass.isAssignableFrom(SpliceJunctionRenderer.class)) {
                this.spliceJunctions = true;
            }
        } else if (line.toLowerCase().contains("#gfftags")) {
            this.gffTags = true;
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public Class getFeatureType() {
        return BasicFeature.class;
    }
}

