/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.AminoAcid;
import org.broad.igv.feature.AminoAcidManager;
import org.broad.igv.feature.Codon;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.WindowFunction;

public class BasicFeature
extends AbstractFeature {
    private static Logger log = Logger.getLogger(BasicFeature.class);
    protected List<Exon> exons;
    protected int level = 1;
    private String type;
    protected float score = Float.NaN;
    protected float confidence;
    String identifier;
    private int thickEnd;
    private int thickStart;
    String[] parentIds;
    String link;

    public BasicFeature() {
    }

    public BasicFeature(String chr, int start, int end) {
        this(chr, start, end, Strand.NONE);
        this.thickStart = start;
        this.thickEnd = end;
    }

    public BasicFeature(String chr, int start, int end, Strand strand) {
        super(chr, start, end, strand);
        this.thickStart = start;
        this.thickEnd = end;
    }

    public BasicFeature(BasicFeature feature) {
        super(feature.getChr(), feature.getStart(), feature.getEnd(), feature.getStrand());
        super.setName(feature.getName());
        this.confidence = feature.confidence;
        this.color = feature.color;
        this.description = feature.description;
        this.exons = feature.exons;
        this.level = feature.level;
        this.score = feature.score;
        this.identifier = feature.identifier;
        this.type = feature.type;
        this.link = feature.link;
        this.thickStart = feature.thickStart;
        this.thickEnd = feature.thickEnd;
    }

    public BasicFeature copy() {
        return new BasicFeature(this);
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setParentIds(String[] parentIds) {
        this.parentIds = parentIds;
    }

    @Override
    public String getValueString(double position, WindowFunction ignored) {
        StringBuffer valueString = new StringBuffer();
        String name = this.getName();
        if (name != null) {
            valueString.append(name);
        }
        if (!(this.identifier == null || name != null && name.equals(this.identifier))) {
            valueString.append("<br>" + this.identifier);
        }
        if (!Float.isNaN(this.score)) {
            valueString.append("<br>Score = " + this.score);
        }
        if (this.description != null) {
            valueString.append("<br>" + this.description);
        }
        valueString.append("<br>" + this.getLocusString());
        int posZero = (int)position;
        if (this.exons != null) {
            for (Exon exon : this.exons) {
                String exonString;
                if (posZero < exon.getStart() || posZero >= exon.getEnd() || (exonString = exon.getValueString(position, ignored)) == null || exonString.length() <= 0) continue;
                valueString.append("<br>--------------<br>");
                valueString.append(exonString);
            }
        }
        return valueString.toString();
    }

    public void setScore(float score) {
        this.score = score;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public List<Exon> getExons() {
        return this.exons;
    }

    public void sortExons() {
        if (this.exons != null) {
            Collections.sort(this.exons, new Comparator<IGVFeature>(){

                @Override
                public int compare(IGVFeature arg0, IGVFeature arg1) {
                    return arg0.getStart() - arg1.getStart();
                }
            });
        }
    }

    public void addExon(Exon region) {
        if (this.exons == null) {
            this.exons = new ArrayList<Exon>();
        }
        this.setStart(Math.min(this.getStart(), region.getStart()));
        this.setEnd(Math.max(this.getEnd(), region.getEnd()));
        this.exons.add(region);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public int getExonCount() {
        return this.exons == null ? 0 : this.exons.size();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public void setURL(String link) {
        this.link = link;
    }

    @Override
    public String getURL() {
        return this.link;
    }

    public int getThickEnd() {
        return this.thickEnd;
    }

    public void setThickEnd(int thickEnd) {
        this.thickEnd = thickEnd;
    }

    public int getThickStart() {
        return this.thickStart;
    }

    public void setThickStart(int thickStart) {
        this.thickStart = thickStart;
    }

    public Codon getCodon(Genome genome, int proteinPosition) {
        int startTranscriptPosition = (proteinPosition - 1) * 3;
        int[] featurePositions = new int[]{startTranscriptPosition, startTranscriptPosition + 1, startTranscriptPosition + 2};
        int[] genomePositions = this.featureToGenomePosition(featurePositions);
        Codon codonInfo = new Codon(this.getChr(), proteinPosition, this.getStrand());
        for (int gp : genomePositions) {
            codonInfo.setNextGenomePosition(gp);
        }
        codonInfo.calcSequence(genome);
        AminoAcid aa = AminoAcidManager.getAminoAcid(codonInfo.getSequence());
        if (aa != null) {
            codonInfo.setAminoAcid(aa);
            return codonInfo;
        }
        return null;
    }

    int[] featureToGenomePosition(int[] featurePositions) {
        List<Exon> exons = this.getExons();
        int[] genomePositions = new int[featurePositions.length];
        if (exons != null) {
            if (this.getStrand() == Strand.NONE) {
                throw new IllegalStateException("Exon not on a strand");
            }
            boolean positive = this.getStrand() == Strand.POSITIVE;
            int posIndex = 0;
            int all_exon_counter = 0;
            int current_exon_end = 0;
            for (int exnum = 0; exnum < exons.size(); ++exnum) {
                int interval;
                int incr;
                Exon exon = positive ? exons.get(exnum) : exons.get(exons.size() - 1 - exnum);
                int exon_length = exon.getCodingLength();
                int genomePosition = positive ? exon.getCdStart() : exon.getCdEnd() - 1;
                current_exon_end += exon_length;
                int n = incr = positive ? 1 : -1;
                while (featurePositions[posIndex] < current_exon_end) {
                    interval = featurePositions[posIndex] - all_exon_counter;
                    all_exon_counter = featurePositions[posIndex];
                    genomePositions[posIndex] = genomePosition += interval * incr;
                    if (++posIndex < featurePositions.length) continue;
                    return genomePositions;
                }
                interval = current_exon_end - featurePositions[posIndex];
                all_exon_counter = current_exon_end;
                genomePosition += interval * incr;
            }
        }
        return genomePositions;
    }
}

