/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.broad.igv.data.seg.SegmentedAsciiDataSet;
import org.broad.igv.dev.db.DBManager;
import org.broad.igv.dev.db.DBReader;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.util.ResourceLocator;

public class SegmentedSQLReader
extends DBReader {
    private static Logger log = Logger.getLogger(SegmentedSQLReader.class);

    public SegmentedAsciiDataSet load(ResourceLocator locator, Genome genome) {
        SegmentedAsciiDataSet dataset = new SegmentedAsciiDataSet(genome);
        ResultSet rs = null;
        Statement st = null;
        Connection conn = null;
        try {
            conn = DBManager.getConnection();
            String query = locator.getDescription();
            st = conn.createStatement();
            rs = st.executeQuery(query);
            while (rs.next()) {
                String sample = rs.getString("Sample");
                String chr = rs.getString("chr");
                int start = rs.getInt("start");
                int end = rs.getInt("end");
                float value = rs.getFloat("value");
                String description = rs.getString("description");
                dataset.addSegment(sample, chr, start, end, value, description);
            }
            dataset.sortLists();
            System.out.println("Disconnected from database");
        }
        catch (SQLException e) {
            try {
                log.error("Database error", e);
                throw new RuntimeException("Database error", e);
            }
            catch (Throwable throwable) {
                SegmentedSQLReader.closeResources(rs, st, conn);
                throw throwable;
            }
        }
        SegmentedSQLReader.closeResources(rs, st, conn);
        return dataset;
    }
}

