/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math.linear.EigenDecompositionImpl;
import org.apache.commons.math.linear.OpenMapRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SparseRealMatrix;
import org.apache.commons.math.stat.StatUtils;
import org.apache.commons.math.stat.correlation.PearsonsCorrelation;
import org.broad.igv.hic.data.Block;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.ContactRecord;
import org.broad.igv.hic.data.DatasetReader;
import org.broad.igv.hic.data.DensityFunction;
import org.broad.igv.hic.tools.Preprocessor;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;

public class MatrixZoomData {
    private Chromosome chr1;
    private Chromosome chr2;
    private int zoom;
    private int binSize;
    private int blockBinCount;
    private int blockColumnCount;
    private LinkedHashMap<Integer, Block> blocks;
    private Map<Integer, Preprocessor.IndexEntry> blockIndex;
    private DatasetReader reader;
    private RealMatrix pearsons;
    private double pearsonsMin = -1.0;
    private double pearsonsMax = 1.0;
    private RealMatrix oe;
    private double[] eigenvector;
    private int sum = -1;

    public MatrixZoomData(Chromosome chr1, Chromosome chr2, DatasetReader reader, LittleEndianInputStream dis) throws IOException {
        this.chr1 = chr1;
        this.chr2 = chr2;
        this.zoom = dis.readInt();
        this.sum = reader.getVersion() >= 1 ? dis.readInt() : -1;
        this.binSize = dis.readInt();
        this.blockBinCount = dis.readInt();
        this.blockColumnCount = dis.readInt();
        int nBlocks = dis.readInt();
        this.blockIndex = new HashMap<Integer, Preprocessor.IndexEntry>(nBlocks);
        for (int b = 0; b < nBlocks; ++b) {
            int blockNumber = dis.readInt();
            long filePosition = dis.readLong();
            int blockSizeInBytes = dis.readInt();
            this.blockIndex.put(blockNumber, new Preprocessor.IndexEntry(filePosition, blockSizeInBytes));
        }
        this.blocks = new LinkedHashMap(nBlocks);
        this.reader = reader;
    }

    public int getBinSize() {
        return this.binSize;
    }

    public int getSum() {
        return this.sum;
    }

    public int getChr1() {
        return this.chr1.getIndex();
    }

    public int getChr2() {
        return this.chr2.getIndex();
    }

    public int getZoom() {
        return this.zoom;
    }

    public int getBlockColumnCount() {
        return this.blockColumnCount;
    }

    public List<Block> getBlocksOverlapping(int x1, int y1, int x2, int y2) {
        int col1 = x1 / this.blockBinCount;
        int row1 = y1 / this.blockBinCount;
        int col2 = x2 / this.blockBinCount;
        int row2 = y2 / this.blockBinCount;
        int maxSize = (col2 - col1 + 1) * (row2 - row1 + 1);
        ArrayList<Block> blockList = new ArrayList<Block>(maxSize);
        for (int r = row1; r <= row2; ++r) {
            for (int c = col1; c <= col2; ++c) {
                int blockNumber = r * this.getBlockColumnCount() + c;
                Block b = this.getBlock(blockNumber);
                if (b == null) continue;
                blockList.add(b);
            }
        }
        return blockList;
    }

    public Block getBlock(int blockNumber) {
        Block b = this.blocks.get(blockNumber);
        if (b == null && this.reader != null && this.blockIndex != null) {
            b = this.readBlock(blockNumber);
            this.blocks.put(blockNumber, b);
        }
        return b;
    }

    private Block readBlock(int blockNumber) {
        Preprocessor.IndexEntry idx = this.blockIndex.get(blockNumber);
        Block b = null;
        if (idx != null) {
            try {
                b = this.reader.readBlock(blockNumber, idx);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return b;
    }

    public double[] getEigenvector() {
        return this.eigenvector;
    }

    public double[] computeEigenvector(DensityFunction df, int which) {
        if (this.pearsons == null) {
            this.pearsons = this.computePearsons(df);
        }
        int size = this.pearsons.getColumnDimension();
        this.eigenvector = new double[size];
        int numgood = 0;
        for (int i = 0; i < size; ++i) {
            this.eigenvector[i] = Double.NaN;
            if (this.isZeros(this.oe.getRow(i))) continue;
            this.eigenvector[i] = 1.0;
            ++numgood;
        }
        int[] cols = new int[numgood];
        numgood = 0;
        for (int i = 0; i < size; ++i) {
            if (Double.isNaN(this.eigenvector[i])) continue;
            cols[numgood++] = i;
        }
        RealMatrix subMatrix = this.pearsons.getSubMatrix(cols, cols);
        if (which >= subMatrix.getColumnDimension() || which < 0) {
            throw new NumberFormatException("Maximum eigenvector is " + subMatrix.getColumnDimension());
        }
        RealVector rv = new EigenDecompositionImpl(subMatrix, 0.0).getEigenvector(which);
        double[] ev = rv.toArray();
        numgood = 0;
        for (int i = 0; i < size; ++i) {
            this.eigenvector[i] = Double.isNaN(this.eigenvector[i]) ? 0.0 : ev[numgood++];
        }
        return this.eigenvector;
    }

    public RealMatrix getPearsons() {
        return this.pearsons;
    }

    public RealMatrix computePearsons(DensityFunction df) {
        if (this.oe == null) {
            this.oe = this.computeOE(df);
        }
        this.pearsons = new PearsonsCorrelation().computeCorrelationMatrix(this.oe);
        PearsonsMinMax minMax = new PearsonsMinMax();
        this.pearsons.walkInOptimizedOrder(minMax);
        this.pearsonsMax = minMax.getMaxValue();
        this.pearsonsMin = minMax.getMinValue();
        return this.pearsons;
    }

    public double getPearsonsMin() {
        return this.pearsonsMin;
    }

    public double getPearsonsMax() {
        return this.pearsonsMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealMatrix readRealMatrix(String filename) throws IOException {
        FilterInputStream is = null;
        Array2DRowRealMatrix rm = null;
        try {
            is = new LittleEndianInputStream(new BufferedInputStream(new FileInputStream(filename + this.zoom)));
            int rows = ((LittleEndianInputStream)is).readInt();
            int cols = ((LittleEndianInputStream)is).readInt();
            double[][] matrix = new double[rows][cols];
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    matrix[i][j] = ((LittleEndianInputStream)is).readDouble();
                }
            }
            rm = new Array2DRowRealMatrix(rows, cols);
            rm.setSubMatrix(matrix, 0, 0);
        }
        catch (IOException error) {
            System.err.println("IO error when saving Pearson's: " + error);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputRealMatrix(RealMatrix rm) throws IOException {
        FilterOutputStream os = null;
        try {
            os = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream("pearsons" + this.zoom + ".bin")));
            int rows = rm.getRowDimension();
            int cols = rm.getColumnDimension();
            ((LittleEndianOutputStream)os).writeInt(rows);
            ((LittleEndianOutputStream)os).writeInt(cols);
            double[][] matrix = rm.getData();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    ((LittleEndianOutputStream)os).writeDouble(matrix[i][j]);
                }
            }
        }
        catch (IOException error) {
            System.err.println("IO error when saving Pearson's: " + error);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private boolean isZeros(double[] array) {
        for (double anArray : array) {
            if (anArray == 0.0) continue;
            return false;
        }
        return true;
    }

    private double getVectorMean(RealVector vector) {
        double sum = 0.0;
        int count = 0;
        int size = vector.getDimension();
        for (int i = 0; i < size; ++i) {
            if (Double.isNaN(vector.getEntry(i))) continue;
            sum += vector.getEntry(i);
            ++count;
        }
        return sum / (double)count;
    }

    private void computeSum() {
        ArrayList<Integer> blockNumbers = new ArrayList<Integer>(this.blockIndex.keySet());
        Collections.sort(blockNumbers);
        this.sum = 0;
        Iterator i$ = blockNumbers.iterator();
        while (i$.hasNext()) {
            int blockNumber = (Integer)i$.next();
            Block b = this.readBlock(blockNumber);
            if (b == null) continue;
            for (ContactRecord rec : b.getContactRecords()) {
                this.sum += rec.getCounts();
            }
        }
    }

    public SparseRealMatrix computeOE(DensityFunction df) {
        int i;
        if (this.chr1 != this.chr2) {
            throw new RuntimeException("Cannot yet compute Pearson's for different chromosomes");
        }
        if (this.sum < 0) {
            this.computeSum();
        }
        int nBins = this.chr1.getSize() / this.binSize + 1;
        OpenMapRealMatrix rm = new OpenMapRealMatrix(nBins, nBins);
        ArrayList<Integer> blockNumbers = new ArrayList<Integer>(this.blockIndex.keySet());
        Iterator i$ = blockNumbers.iterator();
        while (i$.hasNext()) {
            int blockNumber = (Integer)i$.next();
            Block b = this.readBlock(blockNumber);
            if (b == null) continue;
            for (ContactRecord rec : b.getContactRecords()) {
                int x = rec.getX();
                int y = rec.getY();
                int dist = Math.abs(x - y);
                double expected = df.getDensity(this.chr1.getIndex(), dist);
                double normCounts = (double)rec.getCounts() / expected;
                rm.addToEntry(x, y, normCounts);
                if (x == y) continue;
                rm.addToEntry(y, x, normCounts);
            }
        }
        int size = rm.getRowDimension();
        BitSet bitSet = new BitSet(size);
        double[] nans = new double[size];
        for (i = 0; i < size; ++i) {
            nans[i] = Double.NaN;
        }
        for (i = 0; i < size; ++i) {
            if (!this.isZeros(rm.getRow(i))) continue;
            bitSet.set(i);
        }
        for (i = 0; i < size; ++i) {
            if (!bitSet.get(i)) continue;
            rm.setRow(i, nans);
            rm.setColumn(i, nans);
        }
        for (i = 0; i < size; ++i) {
            RealVector v = rm.getRowVector(i);
            double m = this.getVectorMean(v);
            RealVector newV = v.mapSubtract(m);
            rm.setRowVector(i, newV);
        }
        PearsonsResetNan resetNan = new PearsonsResetNan();
        rm.walkInOptimizedOrder(resetNan);
        return rm;
    }

    public ScaleParameters computeScaleParameters() {
        double binSizeMB = (double)this.binSize / 1000000.0;
        double binSizeMB2 = binSizeMB * binSizeMB;
        Block b = this.readBlock(0);
        if (b != null) {
            ContactRecord[] records = b.getContactRecords();
            double[] scores = new double[records.length];
            double sum = 0.0;
            for (int i = 0; i < scores.length; ++i) {
                scores[i] = records[i].getCounts();
                sum += (double)records[i].getCounts();
            }
            double percentile90 = StatUtils.percentile(scores, 90.0) / binSizeMB2;
            double mean = sum / (double)scores.length / binSizeMB2;
            return new ScaleParameters(mean, percentile90);
        }
        return null;
    }

    public void printDescription() {
        System.out.println("Chromosomes: " + this.chr1.getName() + " - " + this.chr2.getName());
        System.out.println("zoom: " + this.zoom);
        System.out.println("binSize (bp): " + this.binSize);
        System.out.println("blockBinCount (bins): " + this.blockBinCount);
        System.out.println("blockColumnCount (columns): " + this.blockColumnCount);
        System.out.println("Block size (bp): " + this.blockBinCount * this.binSize);
        System.out.println("");
    }

    public void dump() {
        ArrayList<Integer> blockNumbers = new ArrayList<Integer>(this.blockIndex.keySet());
        Collections.sort(blockNumbers);
        System.out.println("# " + this.chr1.getName() + " - " + this.chr2.getName());
        Iterator i$ = blockNumbers.iterator();
        while (i$.hasNext()) {
            int blockNumber = (Integer)i$.next();
            Block b = this.readBlock(blockNumber);
            if (b == null) continue;
            for (ContactRecord rec : b.getContactRecords()) {
                System.out.println(rec.getX() * this.binSize + "\t" + rec.getY() * this.binSize + "\t" + rec.getCounts());
            }
        }
    }

    private class PearsonsMinMax
    extends DefaultRealMatrixPreservingVisitor {
        private double minValue = Double.MAX_VALUE;
        private double maxValue = Double.MIN_VALUE;

        private PearsonsMinMax() {
        }

        @Override
        public void visit(int row, int column, double value) {
            if (row != column) {
                if (value < this.minValue) {
                    this.minValue = value;
                }
                if (value > this.maxValue) {
                    this.maxValue = value;
                }
            }
        }

        public double getMinValue() {
            return this.minValue;
        }

        public double getMaxValue() {
            return this.maxValue;
        }
    }

    private class PearsonsResetNan
    extends DefaultRealMatrixChangingVisitor {
        private PearsonsResetNan() {
        }

        @Override
        public double visit(int row, int column, double value) {
            if (Double.isNaN(value)) {
                return 0.0;
            }
            return value;
        }
    }

    public class ScaleParameters {
        double percentile90;
        double mean;

        ScaleParameters(double mean, double percentile90) {
            this.mean = mean;
            this.percentile90 = percentile90;
        }
    }
}

