/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.BaseAlignmentCounts;
import org.broad.igv.util.collections.IntArrayList;

public class SparseAlignmentCounts
extends BaseAlignmentCounts {
    private static Logger log = Logger.getLogger(SparseAlignmentCounts.class);
    private int maxCount = 0;
    HashMap<Integer, Integer> indexMap = new HashMap(1000);
    IntArrayList posA = new IntArrayList(1000);
    IntArrayList posT = new IntArrayList(1000);
    IntArrayList posC = new IntArrayList(1000);
    IntArrayList posG = new IntArrayList(1000);
    IntArrayList posN = new IntArrayList(1000);
    IntArrayList negA;
    IntArrayList negT;
    IntArrayList negC;
    IntArrayList negG;
    IntArrayList negN;
    IntArrayList qA;
    IntArrayList qT;
    IntArrayList qC;
    IntArrayList qG;
    IntArrayList qN;
    IntArrayList posTotal = new IntArrayList(1000);
    IntArrayList negTotal;
    IntArrayList del;
    IntArrayList ins;
    private IntArrayList totalQ;

    public SparseAlignmentCounts(int start, int end, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        super(start, end, bisulfiteContext);
        this.negA = new IntArrayList(1000);
        this.negT = new IntArrayList(1000);
        this.negC = new IntArrayList(1000);
        this.negG = new IntArrayList(1000);
        this.negN = new IntArrayList(1000);
        this.negTotal = new IntArrayList(1000);
        this.qA = new IntArrayList(1000);
        this.qT = new IntArrayList(1000);
        this.qC = new IntArrayList(1000);
        this.qG = new IntArrayList(1000);
        this.qN = new IntArrayList(1000);
        this.del = new IntArrayList(1000);
        this.ins = new IntArrayList(1000);
        this.totalQ = new IntArrayList(1000);
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public AlignmentCounts.PositionIterator getPositionIterator() {
        return new SparsePositionIterator();
    }

    @Override
    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public int getTotalCount(int pos) {
        if (!this.indexMap.containsKey(pos)) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        int idx = this.getIndex(pos);
        return this.getCountFromList(this.posTotal, idx) + this.getCountFromList(this.negTotal, idx);
    }

    @Override
    public int getNegTotal(int pos) {
        if (!this.indexMap.containsKey(pos)) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        int idx = this.getIndex(pos);
        return this.getCountFromList(this.negTotal, idx);
    }

    @Override
    public int getPosTotal(int pos) {
        if (!this.indexMap.containsKey(pos)) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        int idx = this.getIndex(pos);
        return this.getCountFromList(this.posTotal, idx);
    }

    @Override
    public int getTotalQuality(int pos) {
        if (!this.indexMap.containsKey(pos)) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        int idx = this.getIndex(pos);
        return this.getCountFromList(this.totalQ, idx);
    }

    @Override
    public int getCount(int pos, byte b) {
        if (!this.indexMap.containsKey(pos)) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        int idx = this.getIndex(pos);
        switch (b) {
            case 65: 
            case 97: {
                return this.getCountFromList(this.posA, idx) + this.getCountFromList(this.negA, idx);
            }
            case 84: 
            case 116: {
                return this.getCountFromList(this.posT, idx) + this.getCountFromList(this.negT, idx);
            }
            case 67: 
            case 99: {
                return this.getCountFromList(this.posC, idx) + this.getCountFromList(this.negC, idx);
            }
            case 71: 
            case 103: {
                return this.getCountFromList(this.posG, idx) + this.getCountFromList(this.negG, idx);
            }
            case 78: 
            case 110: {
                return this.getCountFromList(this.posN, idx) + this.getCountFromList(this.negN, idx);
            }
        }
        log.debug("Unknown nucleotide: " + b);
        return 0;
    }

    private int getCountFromList(IntArrayList list, int idx) {
        return idx < list.size() ? list.get(idx) : 0;
    }

    @Override
    public int getNegCount(int pos, byte b) {
        if (!this.indexMap.containsKey(pos)) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        int idx = this.getIndex(pos);
        switch (b) {
            case 65: 
            case 97: {
                return this.getCountFromList(this.negA, idx);
            }
            case 84: 
            case 116: {
                return this.getCountFromList(this.negT, idx);
            }
            case 67: 
            case 99: {
                return this.getCountFromList(this.negC, idx);
            }
            case 71: 
            case 103: {
                return this.getCountFromList(this.negG, idx);
            }
            case 78: 
            case 110: {
                return this.getCountFromList(this.negN, idx);
            }
        }
        log.error("Unknown nucleotide: " + b);
        return 0;
    }

    @Override
    public int getPosCount(int pos, byte b) {
        if (!this.indexMap.containsKey(pos)) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        int idx = this.getIndex(pos);
        switch (b) {
            case 65: 
            case 97: {
                return this.getCountFromList(this.posA, idx);
            }
            case 84: 
            case 116: {
                return this.getCountFromList(this.posT, idx);
            }
            case 67: 
            case 99: {
                return this.getCountFromList(this.posC, idx);
            }
            case 71: 
            case 103: {
                return this.getCountFromList(this.posG, idx);
            }
            case 78: 
            case 110: {
                return this.getCountFromList(this.posN, idx);
            }
        }
        log.error("Unknown nucleotide: " + b);
        return 0;
    }

    @Override
    public int getDelCount(int pos) {
        if (!this.indexMap.containsKey(pos)) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        int idx = this.getIndex(pos);
        return this.getCountFromList(this.del, idx);
    }

    @Override
    public int getInsCount(int pos) {
        if (!this.indexMap.containsKey(pos)) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        int idx = this.getIndex(pos);
        return this.getCountFromList(this.ins, idx);
    }

    @Override
    public int getQuality(int pos, byte b) {
        if (!this.indexMap.containsKey(pos)) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        int idx = this.getIndex(pos);
        switch (b) {
            case 65: 
            case 97: {
                return this.getCountFromList(this.qA, idx);
            }
            case 84: 
            case 116: {
                return this.getCountFromList(this.qT, idx);
            }
            case 67: 
            case 99: {
                return this.getCountFromList(this.qC, idx);
            }
            case 71: 
            case 103: {
                return this.getCountFromList(this.qG, idx);
            }
            case 78: 
            case 110: {
                return this.getCountFromList(this.qN, idx);
            }
        }
        log.error("Unknown nucleotide: " + this.posN);
        return 0;
    }

    @Override
    public int getAvgQuality(int pos, byte b) {
        int count = this.getCount(pos, b);
        return count == 0 ? 0 : this.getQuality(pos, b) / count;
    }

    @Override
    protected void incrementDeletion(int pos) {
        int idx = this.getIndex(pos);
        this.increment(this.del, idx, 1);
    }

    @Override
    protected void incrementInsertion(AlignmentBlock insBlock) {
        int pos = insBlock.getStart();
        int idx1 = this.getIndex(pos);
        this.increment(this.ins, idx1, 1);
        if (pos > 0) {
            int idx2 = this.getIndex(pos - 1);
            this.increment(this.ins, idx2, 1);
        }
    }

    @Override
    protected void incBlockCounts(AlignmentBlock block, boolean isNegativeStrand) {
        int start = block.getStart();
        byte[] bases = block.getBases();
        if (bases != null) {
            for (int i = 0; i < bases.length; ++i) {
                int pos = start + i;
                byte q = block.qualities[i];
                byte n = bases[i];
                this.incPositionCount(pos, n, q, isNegativeStrand);
            }
        }
    }

    @Override
    protected void incPositionCount(int pos, byte b, byte q, boolean isNegativeStrand) {
        int idx = this.getIndex(pos);
        switch (b) {
            case 65: 
            case 97: {
                if (isNegativeStrand) {
                    this.increment(this.negA, idx, 1);
                } else {
                    this.increment(this.posA, idx, 1);
                }
                this.increment(this.qA, idx, q);
                break;
            }
            case 84: 
            case 116: {
                if (isNegativeStrand) {
                    this.increment(this.negT, idx, 1);
                } else {
                    this.increment(this.posT, idx, 1);
                }
                this.increment(this.qT, idx, q);
                break;
            }
            case 67: 
            case 99: {
                if (isNegativeStrand) {
                    this.increment(this.negC, idx, 1);
                } else {
                    this.increment(this.posC, idx, 1);
                }
                this.increment(this.qC, idx, q);
                break;
            }
            case 71: 
            case 103: {
                if (isNegativeStrand) {
                    this.increment(this.negG, idx, 1);
                } else {
                    this.increment(this.posG, idx, 1);
                }
                this.increment(this.qG, idx, q);
                break;
            }
            default: {
                if (isNegativeStrand) {
                    this.increment(this.negN, idx, 1);
                } else {
                    this.increment(this.posN, idx, 1);
                }
                this.increment(this.qN, idx, q);
            }
        }
        if (isNegativeStrand) {
            this.increment(this.negTotal, idx, 1);
        } else {
            this.increment(this.posTotal, idx, 1);
        }
        this.increment(this.totalQ, idx, q);
        int pt = idx < this.posTotal.size() ? this.posTotal.get(idx) : 0;
        int nt = idx < this.negTotal.size() ? this.negTotal.get(idx) : 0;
        this.maxCount = Math.max(pt + nt, this.maxCount);
    }

    private int getIndex(int pos) {
        Integer index = this.indexMap.get(pos);
        if (index == null) {
            index = new Integer(this.indexMap.size());
            this.indexMap.put(pos, index);
        }
        return index;
    }

    private void increment(IntArrayList list, int idx, int delta) {
        if (idx < list.size()) {
            list.set(idx, list.get(idx) + delta);
        } else {
            list.set(idx, delta);
        }
    }

    class SparsePositionIterator
    implements AlignmentCounts.PositionIterator {
        List<Integer> indeces;
        int idx;

        SparsePositionIterator() {
            this.indeces = new ArrayList<Integer>(SparseAlignmentCounts.this.indexMap.keySet());
            Collections.sort(this.indeces);
            this.idx = 0;
        }

        @Override
        public int nextPosition() {
            if (this.idx < this.indeces.size()) {
                Integer val = this.indeces.get(this.idx);
                ++this.idx;
                return val;
            }
            return -1;
        }
    }
}

