/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.JComponent;
import org.broad.igv.hic.HiC;
import org.broad.igv.hic.MainWindow;

public class ThumbnailPanel
extends JComponent
implements Serializable {
    private MainWindow mainWindow;
    private HiC hic;
    Image image;
    public static final AlphaComposite ALPHA_COMP = AlphaComposite.getInstance(3, 0.75f);
    private double yScale;
    private double xScale;
    Point lastPoint = null;
    private Rectangle innerRectangle;

    public ThumbnailPanel(MainWindow mainWindow, HiC model) {
        this.mainWindow = mainWindow;
        this.hic = model;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int xBP = (int)((double)mouseEvent.getX() * ThumbnailPanel.this.xScale);
                int yBP = (int)((double)mouseEvent.getY() * ThumbnailPanel.this.yScale);
                ThumbnailPanel.this.hic.center(xBP, yBP);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (ThumbnailPanel.this.innerRectangle != null && ThumbnailPanel.this.innerRectangle.contains(mouseEvent.getPoint())) {
                    ThumbnailPanel.this.lastPoint = mouseEvent.getPoint();
                    ThumbnailPanel.this.setCursor(MainWindow.fistCursor);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ThumbnailPanel.this.lastPoint = null;
                ThumbnailPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (ThumbnailPanel.this.lastPoint != null) {
                    int dxBP = (int)((double)(mouseEvent.getX() - ThumbnailPanel.this.lastPoint.x) * ThumbnailPanel.this.xScale);
                    int dyBP = (int)((double)(mouseEvent.getY() - ThumbnailPanel.this.lastPoint.y) * ThumbnailPanel.this.xScale);
                    ThumbnailPanel.this.hic.moveBy(dxBP, dyBP);
                    ThumbnailPanel.this.lastPoint = mouseEvent.getPoint();
                }
            }
        });
    }

    public void setImage(Image image) {
        this.image = image;
        int maxLen = Math.max(this.hic.xContext.getChrLength(), this.hic.yContext.getChrLength());
        this.yScale = this.xScale = (double)maxLen / (double)this.getWidth();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String nm) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, null);
            this.renderVisibleWindow((Graphics2D)g);
        }
    }

    private void renderVisibleWindow(Graphics2D g) {
        if (this.hic != null && this.hic.xContext != null) {
            int delta;
            int wPixels = this.mainWindow.getHeatmapPanel().getWidth();
            int hPixels = this.mainWindow.getHeatmapPanel().getHeight();
            int originX = this.hic.xContext.getOrigin();
            int x = (int)((double)originX / this.xScale);
            int originY = this.hic.yContext.getOrigin();
            int y = (int)((double)originY / this.yScale);
            int wBP = (int)(this.hic.xContext.getScale() * (double)wPixels);
            int w = (int)((double)wBP / this.xScale);
            int yBP = (int)(this.hic.yContext.getScale() * (double)hPixels);
            int h = (int)((double)yBP / this.yScale);
            if (w < 4) {
                delta = 4 - w;
                x -= delta / 2;
                w = 4;
            }
            if (h < 4) {
                delta = 4 - h;
                y -= delta / 2;
                h = 4;
            }
            Rectangle outerRectangle = new Rectangle(0, 0, this.getBounds().width, this.getBounds().height);
            this.innerRectangle = new Rectangle(x, y, w, h);
            SquareDonut shape = new SquareDonut(outerRectangle, this.innerRectangle);
            g.setColor(Color.gray);
            g.setComposite(ALPHA_COMP);
            g.fill(shape);
            g.draw(this.innerRectangle);
        }
    }

    private static class SquareDonut
    implements Shape {
        private final Area area;

        public SquareDonut(Rectangle outerRectangle, Rectangle innerRectangle) {
            this.area = new Area(outerRectangle);
            this.area.subtract(new Area(innerRectangle));
        }

        @Override
        public Rectangle getBounds() {
            return this.area.getBounds();
        }

        @Override
        public Rectangle2D getBounds2D() {
            return this.area.getBounds2D();
        }

        @Override
        public boolean contains(double v, double v1) {
            return this.area.contains(v, v1);
        }

        @Override
        public boolean contains(Point2D point2D) {
            return this.area.contains(point2D);
        }

        @Override
        public boolean intersects(double v, double v1, double v2, double v3) {
            return this.area.intersects(v, v1, v2, v3);
        }

        @Override
        public boolean intersects(Rectangle2D rectangle2D) {
            return this.area.intersects(rectangle2D);
        }

        @Override
        public boolean contains(double v, double v1, double v2, double v3) {
            return this.area.contains(v, v1, v2, v3);
        }

        @Override
        public boolean contains(Rectangle2D rectangle2D) {
            return this.area.contains(rectangle2D);
        }

        @Override
        public PathIterator getPathIterator(AffineTransform affineTransform) {
            return this.area.getPathIterator(affineTransform);
        }

        @Override
        public PathIterator getPathIterator(AffineTransform affineTransform, double v) {
            return this.area.getPathIterator(affineTransform, v);
        }
    }
}

