/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import java.lang.reflect.Method;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class RangeSlider
extends JSlider {
    private static final String uiClassID = "SliderUI";
    private boolean _rangeDraggable = true;
    public static final String CLIENT_PROPERTY_MOUSE_POSITION = "RangeSlider.mousePosition";
    public static final String PROPERTY_LOW_VALUE = "lowValue";
    public static final String PROPERTY_HIGH_VALUE = "highValue";

    public RangeSlider() {
    }

    public RangeSlider(int n) {
        super(n);
    }

    public RangeSlider(int n, int n2) {
        super(n, n2);
    }

    public RangeSlider(int n, int n2, int n3, int n4) {
        super(new DefaultBoundedRangeModel(n3, n4 - n3, n, n2));
    }

    public void updateUI() {
        if (UIDefaultsLookup.get("RangeSliderUI") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        try {
            Class<?> clazz = Class.forName(UIManager.getString("RangeSliderUI"));
            Class<JComponent> clazz2 = JComponent.class;
            Method method = clazz.getMethod("createUI", clazz2);
            if (method != null) {
                Object object = method.invoke(null, this);
                this.setUI((ComponentUI)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getLowValue() {
        return this.getModel().getValue();
    }

    public int getHighValue() {
        return this.getModel().getValue() + this.getModel().getExtent();
    }

    public boolean contains(int n) {
        return n >= this.getLowValue() && n <= this.getHighValue();
    }

    public void setValue(int n) {
        Object object = this.getClientProperty(CLIENT_PROPERTY_MOUSE_POSITION);
        if (object != null) {
            if (Boolean.TRUE.equals(object)) {
                this.setLowValue(n);
            } else {
                this.setHighValue(n);
            }
        } else {
            this.setLowValue(n);
        }
    }

    public void setLowValue(int n) {
        int n2 = this.getLowValue();
        int n3 = n + this.getModel().getExtent() > this.getMaximum() ? this.getMaximum() : this.getHighValue();
        int n4 = n3 - n;
        this.getModel().setRangeProperties(n, n4, this.getMinimum(), this.getMaximum(), true);
        this.firePropertyChange(PROPERTY_LOW_VALUE, n2, this.getLowValue());
    }

    public void setHighValue(int n) {
        int n2 = this.getHighValue();
        this.getModel().setExtent(n - this.getLowValue());
        this.firePropertyChange(PROPERTY_HIGH_VALUE, n2, this.getHighValue());
    }

    public boolean isRangeDraggable() {
        return this._rangeDraggable;
    }

    public void setRangeDraggable(boolean bl) {
        this._rangeDraggable = bl;
    }
}

