/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.util.RuntimeUtils;
import org.broad.tribble.Feature;

public class CombinedFeatureSource
implements FeatureSource {
    private static Logger log = Logger.getLogger(CombinedFeatureSource.class);
    private FeatureSource sourceA;
    private FeatureSource sourceB;
    private Operation operation;
    private int featureWindowSize = 1000000;
    static String BEDtoolsPath = "/usr/local/bin/bedtools";

    public CombinedFeatureSource(FeatureSource sourceA, FeatureSource sourceB, Operation operation) {
        this.sourceA = sourceA;
        this.sourceB = sourceB;
        this.operation = operation;
    }

    private int writeFeaturesToStream(Iterator<Feature> features, OutputStream outputStream) {
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
        IGVBEDCodec codec = new IGVBEDCodec();
        int numLines = 0;
        while (features.hasNext()) {
            String data = codec.encode(features.next());
            writer.println(data);
            ++numLines;
        }
        writer.flush();
        writer.close();
        return numLines;
    }

    public Iterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
        String line;
        Iterator<Feature> iterA = this.sourceA.getFeatures(chr, start, end);
        Iterator<Feature> iterB = this.sourceB.getFeatures(chr, start, end);
        File outFile = File.createTempFile("featuresB", ".bed", null);
        outFile.deleteOnExit();
        int numB = this.writeFeaturesToStream(iterB, new FileOutputStream(outFile));
        String cmd = BEDtoolsPath + " " + this.operation.getCmd() + " -b " + outFile.getAbsolutePath() + " -a stdin";
        Process pr = RuntimeUtils.startExternalProcess(cmd, null, null);
        int numA = this.writeFeaturesToStream(iterA, pr.getOutputStream());
        try {
            pr.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        BufferedReader err = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
        ArrayList<BasicFeature> featuresList = new ArrayList<BasicFeature>(numA + numB);
        IGVBEDCodec codec = new IGVBEDCodec();
        while ((line = in.readLine()) != null) {
            BasicFeature feat;
            if (this.operation == Operation.WINDOW) {
                String[] closest = this.splitDualFeatures(line, 3)[1];
                feat = codec.decode(closest);
            } else {
                feat = codec.decode(line);
            }
            featuresList.add(feat);
        }
        in.close();
        while ((line = err.readLine()) != null) {
            log.error(line);
        }
        err.close();
        return featuresList.iterator();
    }

    private String[][] splitDualFeatures(String input, int colsPerFeat) {
        String[] tokens = Globals.singleTabMultiSpacePattern.split(input);
        assert (tokens.length == colsPerFeat * 2);
        String[] feat1 = new String[colsPerFeat];
        String[] feat2 = new String[colsPerFeat];
        for (int cc = 0; cc < colsPerFeat; ++cc) {
            feat1[cc] = tokens[cc];
            feat2[cc] = tokens[cc + colsPerFeat];
        }
        String[][] out = new String[][]{feat1, feat2};
        return out;
    }

    private String[] convertBedToolsOutToBed(String[] input) {
        if (input.length < 3) {
            throw new IllegalArgumentException("Input array has only " + input.length + " columns, need at least 3");
        }
        if (input.length == 3) {
            return input;
        }
        String[] output = new String[input.length + 1];
        System.arraycopy(input, 0, output, 0, 3);
        output[3] = "";
        System.arraycopy(input, 3, output, 4, input.length - 3);
        return output;
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureWindowSize;
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.featureWindowSize = size;
    }

    public static enum Operation {
        INTERSECT("intersect -bed"),
        SUBTRACT("subtract"),
        WINDOW("window -bed"),
        COVERAGE("coverage");

        private String cmd;

        private Operation(String cmd) {
            this.cmd = cmd;
        }

        public String getCmd() {
            return this.cmd;
        }
    }
}

