/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import org.broad.igv.Globals;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;
import org.broad.tribble.Feature;

public class Peak
implements LocusScore,
Feature {
    String chr;
    int start;
    int end;
    private String name;
    private float combinedScore;
    private float[] timeScores;
    boolean dynamic = false;
    float dynamicScore;
    private float foldChange;
    String valueString;

    public Peak(String chr, int start, int end, String name, float combinedScore, float[] timeScores) {
        this.chr = chr;
        this.combinedScore = combinedScore;
        this.end = end;
        this.name = name;
        this.start = start;
        this.timeScores = timeScores;
        float minScore = timeScores[0];
        float maxScore = timeScores[0];
        int minIdx = 0;
        int maxIdx = 0;
        for (int i = 0; i < timeScores.length; ++i) {
            if (timeScores[i] < minScore) {
                minIdx = i;
                minScore = timeScores[i];
            }
            if (!(timeScores[i] > maxScore)) continue;
            maxIdx = i;
            maxScore = timeScores[i];
        }
        this.foldChange = (maxScore + 1.0f) / (minScore + 1.0f);
        float f = this.dynamicScore = maxScore < 30.0f ? 0.0f : (float)(Math.log(this.foldChange) / Globals.log2);
        if (minIdx > maxIdx) {
            this.dynamicScore = -this.dynamicScore;
        }
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public String getName() {
        return this.name;
    }

    public float getCombinedScore() {
        return this.combinedScore;
    }

    public float[] getTimeScores() {
        return this.timeScores;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public float getDynamicScore() {
        return this.dynamicScore;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public float getScore() {
        return this.combinedScore;
    }

    public LocusScore copy() {
        return this;
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        if (this.valueString == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("Combined Score: " + this.getScore());
            buf.append("<br>Fold change: " + this.foldChange);
            buf.append("<br>--------------------");
            for (int i = 0; i < this.timeScores.length; ++i) {
                buf.append("<br>Time point " + (i + 1) + ": " + this.timeScores[i]);
            }
            this.valueString = buf.toString();
        }
        return this.valueString;
    }

    public float getFoldChange() {
        return this.foldChange;
    }
}

