/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.data.BasicScore;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;

public class CombinedDataSource
implements DataSource {
    DataSource source1;
    DataSource source2;
    String operator = "-";

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        List<LocusScore> scores1 = this.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
        List<LocusScore> scores2 = this.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
        ArrayList<BasicScore> pendingScores = new ArrayList<BasicScore>();
        ArrayList<LocusScore> scoresToClose = new ArrayList<LocusScore>();
        ArrayList<LocusScore> mergedScores = new ArrayList<LocusScore>(scores1.size() + scores2.size());
        MergedIterator iter = new MergedIterator(scores1.iterator(), scores2.iterator());
        while (iter.hasNext()) {
            ScoreWrapper score = (ScoreWrapper)iter.next();
            int start = score.getStart();
            for (LocusScore locusScore : pendingScores) {
                if (locusScore.getEnd() <= start) {
                    mergedScores.add(locusScore);
                    scoresToClose.add(locusScore);
                    continue;
                }
                BasicScore newScore = new BasicScore(locusScore.getStart(), start, locusScore.getScore());
                mergedScores.add(newScore);
                int end = Math.min(locusScore.getEnd(), score.getEnd());
                float newVal = this.combineScores(locusScore, score);
                newScore = new BasicScore(start, end, newVal);
                pendingScores.add(newScore);
                if (locusScore.getEnd() <= score.getEnd()) continue;
                newScore = new BasicScore(score.getEnd(), locusScore.getEnd(), locusScore.getScore());
                pendingScores.add(newScore);
            }
            pendingScores.removeAll(scoresToClose);
        }
        return null;
    }

    private float combineScores(LocusScore score1, ScoreWrapper score2) {
        return score1.getScore() + score2.getScaledScore();
    }

    @Override
    public double getDataMax() {
        return 0.0;
    }

    @Override
    public double getDataMin() {
        return 0.0;
    }

    @Override
    public TrackType getTrackType() {
        return null;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    public void refreshData(long timestamp) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return null;
    }

    static class ScoreWrapper {
        int operator;
        LocusScore score;

        ScoreWrapper(LocusScore score, int operator) {
            this.operator = operator;
            this.score = score;
        }

        int getStart() {
            return this.score.getStart();
        }

        int getEnd() {
            return this.score.getEnd();
        }

        float getScaledScore() {
            return (float)this.operator * this.score.getScore();
        }
    }

    static class MergedIterator
    implements Iterator<ScoreWrapper> {
        Iterator i1;
        Iterator i2;
        ScoreWrapper next1;
        ScoreWrapper next2;

        MergedIterator(Iterator<LocusScore> i1, Iterator<LocusScore> i2) {
            this.i1 = i1;
            this.i2 = i2;
            if (i1.hasNext()) {
                this.next1 = new ScoreWrapper(i1.next(), 1);
            }
            if (i2.hasNext()) {
                this.next2 = new ScoreWrapper(i1.next(), -1);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next1 != null || this.next2 != null;
        }

        @Override
        public ScoreWrapper next() {
            if (this.next1 == null) {
                return this.next2;
            }
            if (this.next2 == null) {
                return this.next1;
            }
            if (this.next2.getStart() < this.next1.getStart()) {
                return this.next2;
            }
            return this.next1;
        }

        @Override
        public void remove() {
        }
    }
}

