/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.ChromosomeData;
import org.broad.igv.data.ChromosomeSummary;
import org.broad.igv.data.Dataset;
import org.broad.igv.data.GenomeSummaryData;
import org.broad.igv.data.IGVDatasetParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.ObjectCache;
import org.broad.igv.util.ResourceLocator;

public class IGVDataset
implements Dataset {
    private String name;
    private TrackType type = TrackType.OTHER;
    private boolean logNormalized;
    private String[] dataHeadings;
    private Map<String, ChromosomeSummary> chromosomeSummaries = new LinkedHashMap<String, ChromosomeSummary>();
    private GenomeSummaryData genomeSummary;
    private IGVDatasetParser parser;
    private ObjectCache<String, ChromosomeData> chromsomeDataCache = new ObjectCache(30);
    private float dataMin;
    private float dataMax;
    TrackProperties trackProperties = new TrackProperties();
    private Map<String, Integer> longestFeatureMap;

    public IGVDataset(ResourceLocator locator, Genome genome, IGV igv) {
        this.parser = new IGVDatasetParser(locator, genome, igv);
        List<ChromosomeSummary> summaries = this.parser.scan(this);
        if (summaries == null || summaries.size() == 0) {
            throw new RuntimeException("Could not find any chromosomes in the dataset on the genome(" + genome.getId() + ")");
        }
        for (ChromosomeSummary summary : summaries) {
            this.chromosomeSummaries.put(summary.getName(), summary);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setGenomeSummary(GenomeSummaryData genomeSummary) {
        this.genomeSummary = genomeSummary;
    }

    public void setTrackType(TrackType type) {
        this.type = type;
    }

    @Override
    public TrackType getType() {
        return this.type;
    }

    @Override
    public String[] getChromosomes() {
        return this.chromosomeSummaries.keySet().toArray(new String[0]);
    }

    public void setDataHeadings(String[] dataHeadings) {
        this.dataHeadings = dataHeadings;
    }

    @Override
    public String[] getTrackNames() {
        return this.dataHeadings;
    }

    @Override
    public int[] getStartLocations(String chr) {
        ChromosomeData cd = this.getChromosomeData(chr);
        return cd == null ? null : cd.getStartLocations();
    }

    @Override
    public int[] getEndLocations(String chr) {
        ChromosomeData cd = this.getChromosomeData(chr);
        return cd == null ? null : cd.getEndLocations();
    }

    @Override
    public String[] getFeatureNames(String chr) {
        ChromosomeData cd = this.getChromosomeData(chr);
        return cd == null ? null : cd.getProbes();
    }

    @Override
    public float[] getData(String heading, String chr) {
        ChromosomeData cd = this.getChromosomeData(chr);
        return cd == null ? null : cd.getData(heading);
    }

    private synchronized ChromosomeData getChromosomeData(String chr) {
        ChromosomeData cd = this.chromsomeDataCache.get(chr);
        if (cd == null) {
            ChromosomeSummary sum = this.chromosomeSummaries.get(chr);
            if (sum == null) {
                return null;
            }
            cd = this.parser.loadChromosomeData(sum, this.dataHeadings);
            this.chromsomeDataCache.put(chr, cd);
        }
        return cd;
    }

    public GenomeSummaryData getGenomeSummary() {
        return this.genomeSummary;
    }

    public void setLogNormalized(boolean logNormalized) {
        this.logNormalized = logNormalized;
    }

    @Override
    public boolean isLogNormalized() {
        return this.logNormalized;
    }

    @Override
    public float getDataMin() {
        return this.dataMin;
    }

    @Override
    public float getDataMax() {
        return this.dataMax;
    }

    public void setDataMin(float dataMin) {
        this.dataMin = dataMin;
    }

    public void setDataMax(float dataMax) {
        this.dataMax = dataMax;
    }

    @Override
    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    @Override
    public Integer getLongestFeature(String chr) {
        return this.longestFeatureMap == null ? 1000 : (this.longestFeatureMap.containsKey(chr) ? this.longestFeatureMap.get(chr) : 1);
    }

    public void setLongestFeatureMap(Map<String, Integer> longestFeatureMap) {
        this.longestFeatureMap = longestFeatureMap;
    }
}

