/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.data.CoverageDataSource;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.goby.GobyCountArchiveDataSource;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.BisulfiteCounts;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.DataRangeDialog;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class CoverageTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(CoverageTrack.class);
    char[] nucleotides = new char[]{'a', 'c', 'g', 't', 'n'};
    public static Color lightBlue = new Color(0, 0, 150);
    private static Color coverageGrey = new Color(175, 175, 175);
    public static final Color negStrandColor = new Color(140, 140, 160);
    public static final Color posStrandColor = new Color(160, 140, 140);
    private static final boolean DEFAULT_AUTOSCALE = true;
    private static final boolean DEFAULT_SHOW_REFERENCE = false;
    boolean showReference;
    boolean autoScale = true;
    private float snpThreshold;
    AlignmentDataManager dataManager;
    CoverageDataSource dataSource;
    DataRenderer dataSourceRenderer;
    IntervalRenderer intervalRenderer;
    PreferenceManager prefs;
    JMenuItem dataRangeItem;
    JMenuItem autoscaleItem;
    Genome genome;
    static float[] colorComps = new float[3];

    public CoverageTrack(ResourceLocator locator, String name, Genome genome) {
        super(locator, locator.getPath() + "_coverage", name);
        super.setDataRange(new DataRange(0.0f, 0.0f, 60.0f));
        this.genome = genome;
        this.intervalRenderer = new IntervalRenderer();
        this.setMaximumHeight(40);
        this.setColor(coverageGrey);
        this.prefs = PreferenceManager.getInstance();
        this.snpThreshold = this.prefs.getAsFloat("SAM.ALLELE_THRESHOLD");
        this.autoScale = true;
        this.showReference = false;
    }

    public void setDataManager(AlignmentDataManager dataManager) {
        this.dataManager = dataManager;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = (CoverageDataSource)dataSource;
        this.dataSourceRenderer = new BarChartRenderer();
        this.setDataRange(new DataRange(0.0f, 0.0f, 1.5f * (float)dataSource.getDataMax()));
    }

    @Override
    public void setDataRange(DataRange axisDefinition) {
        this.autoScale = false;
        super.setDataRange(axisDefinition);
    }

    public void rescale() {
        Collection<AlignmentInterval> loadedIntervals;
        if (this.autoScale & this.dataManager != null && (loadedIntervals = this.dataManager.getLoadedIntervals()) != null) {
            for (AlignmentInterval interval : loadedIntervals) {
                this.rescaleInterval(interval);
            }
        }
    }

    public void rescale(ReferenceFrame frame) {
        if (this.autoScale & this.dataManager != null) {
            this.rescaleInterval(this.dataManager.getLoadedInterval(frame));
        }
    }

    private void rescaleInterval(AlignmentInterval interval) {
        if (interval != null) {
            int max = Math.max(10, interval.getMaxCount());
            DataRange.Type type = this.getDataRange().getType();
            super.setDataRange(new DataRange(0.0f, 0.0f, max));
            this.getDataRange().setType(type);
        }
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int zoom;
        int end;
        int start;
        String chr;
        List<LocusScore> scores;
        float maxRange = PreferenceManager.getInstance().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        float minVisibleScale = maxRange * 1000.0f / 700.0f;
        if (context.getScale() < (double)minVisibleScale) {
            AlignmentInterval interval = null;
            if (this.dataManager != null) {
                interval = this.dataManager.getLoadedInterval(context.getReferenceFrame());
            }
            if (interval != null && interval.contains(context.getChr(), (int)context.getOrigin(), (int)context.getEndLocation())) {
                List<AlignmentCounts> counts = interval.getCounts();
                this.intervalRenderer.paint(context, rect, counts);
            }
        } else if (this.dataSource != null && (scores = this.dataSource.getSummaryScoresForRange(chr = context.getChr(), start = (int)context.getOrigin(), end = (int)context.getEndLocation(), zoom = context.getZoom())) != null) {
            this.dataSourceRenderer.render(scores, context, rect, (Track)this);
        }
        this.drawBorder(context, rect);
    }

    private void drawBorder(RenderContext context, Rectangle rect) {
        context.getGraphic2DForColor(Color.gray).drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
        this.drawScale(context, rect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawScale(RenderContext context, Rectangle rect) {
        DataRange range = this.getDataRange();
        if (range != null) {
            Graphics2D g = context.getGraphic2DForColor(Color.black);
            Font font = g.getFont();
            Font smallFont = FontManager.getFont(8);
            try {
                g.setFont(smallFont);
                String scale = "[" + (int)range.getMinimum() + " - " + (int)range.getMaximum() + "]";
                g.drawString(scale, rect.x + 5, rect.y + 10);
            }
            finally {
                g.setFont(font);
            }
        }
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public void setRendererClass(Class rc) {
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        float maxRange = PreferenceManager.getInstance().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        float minVisibleScale = maxRange * 1000.0f / 700.0f;
        if (frame.getScale() < (double)minVisibleScale) {
            int pos;
            AlignmentCounts counts;
            AlignmentInterval interval = this.dataManager.getLoadedInterval(frame);
            if (interval != null && interval.contains(chr, (int)position, (int)position) && (counts = interval.getAlignmentCounts(pos = (int)position)) != null) {
                return counts.getValueStringAt(pos);
            }
        } else {
            return this.getPrecomputedValueString(chr, position, frame);
        }
        return null;
    }

    private String getPrecomputedValueString(String chr, double position, ReferenceFrame frame) {
        if (this.dataSource == null) {
            return "";
        }
        int zoom = Math.max(0, frame.getZoom());
        List<LocusScore> scores = this.dataSource.getSummaryScoresForRange(chr, (int)position - 10, (int)position + 10, zoom);
        double bpPerPixel = frame.getScale();
        double minWidth = 2.0 * bpPerPixel;
        if (scores == null) {
            return "";
        }
        LocusScore score = (LocusScore)FeatureUtils.getFeatureAt(position, 0, scores);
        return score == null ? "" : "Mean count: " + score.getScore();
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    int drawBar(RenderContext context, int pos, Rectangle rect, double totalCount, double max, int pY, int pX, int dX, AlignmentCounts interval, boolean isLog) {
        for (char nucleotide : this.nucleotides) {
            int count = interval.getCount(pos, (byte)nucleotide);
            Color c = Globals.nucleotideColors.get(Character.valueOf(nucleotide));
            Graphics2D tGraphics = context.getGraphic2DForColor(c);
            double tmp = isLog ? (double)count / totalCount * Math.log10(totalCount) / max : (double)count / max;
            int height = (int)(tmp * rect.getHeight());
            height = Math.min(pY - rect.y, height);
            int baseY = pY - height;
            if (height > 0) {
                tGraphics.fillRect(pX, baseY, dX, height);
            }
            pY = baseY;
        }
        return pX + dX;
    }

    int drawBarBisulfite(RenderContext context, int pos, Rectangle rect, double totalCount, double maxRange, int pY, int pX0, int dX, BisulfiteCounts.Count count, boolean isLog) {
        int pX = pX0;
        if (dX < 3) {
            int expansion = dX;
            pX -= expansion;
            dX += 2 * expansion;
        }
        double nMethylated = count.methylatedCount;
        double unMethylated = count.unmethylatedCount;
        Color c = Color.red;
        Graphics2D tGraphics = context.getGraphic2DForColor(c);
        double tmp = isLog ? nMethylated / totalCount * Math.log10(totalCount) / maxRange : nMethylated / maxRange;
        int height = (int)(tmp * rect.getHeight());
        height = Math.min(pY - rect.y, height);
        int baseY = pY - height;
        if (height > 0) {
            tGraphics.fillRect(pX, baseY, dX, height);
        }
        pY = baseY;
        c = Color.blue;
        tGraphics = context.getGraphic2DForColor(c);
        tmp = isLog ? unMethylated / totalCount * Math.log10(totalCount) / maxRange : unMethylated / maxRange;
        height = (int)(tmp * rect.getHeight());
        height = Math.min(pY - rect.y, height);
        baseY = pY - height;
        if (height > 0) {
            tGraphics.fillRect(pX, baseY, dX, height);
        }
        return pX + dX;
    }

    void drawStrandBar(RenderContext context, int pos, Rectangle rect, double maxCount, int pY, int pX, int dX, boolean isPositive, AlignmentCounts interval) {
        for (char nucleotide : this.nucleotides) {
            int baseY;
            Color c = Globals.nucleotideColors.get(Character.valueOf(nucleotide));
            Graphics2D tGraphics = context.getGraphic2DForColor(c);
            int count = isPositive ? interval.getPosCount(pos, (byte)nucleotide) : interval.getNegCount(pos, (byte)nucleotide);
            int height = (int)Math.round((double)count * rect.getHeight() / maxCount);
            height = isPositive ? Math.min(pY - rect.y, height) : Math.min(rect.y + rect.height - pY, height);
            int n = baseY = isPositive ? pY - height : pY;
            if (height > 0) {
                tGraphics.fillRect(pX, baseY, dX, height);
            }
            pY = isPositive ? baseY : baseY + height;
        }
    }

    private Color getShadedColor(int qual, Color backgroundColor, Color color) {
        float alpha = 0.0f;
        int minQ = this.prefs.getAsInt("SAM.BASE_QUALITY_MIN");
        ColorUtilities.getRGBColorComponents(color);
        if (qual < minQ) {
            alpha = 0.1f;
        } else {
            int maxQ = this.prefs.getAsInt("SAM.BASE_QUALITY_MAX");
            alpha = Math.max(0.1f, Math.min(1.0f, 0.1f + 0.9f * (float)(qual - minQ) / (float)(maxQ - minQ)));
        }
        alpha = (float)((int)(alpha * 10.0f + 0.5f)) / 10.0f;
        if (alpha >= 1.0f) {
            return color;
        }
        return ColorUtilities.getCompositeColor(backgroundColor, color, alpha);
    }

    @Override
    public Map<String, String> getPersistentState() {
        Map<String, String> attributes = super.getPersistentState();
        this.prefs = PreferenceManager.getInstance();
        if (this.snpThreshold != this.prefs.getAsFloat("SAM.ALLELE_THRESHOLD")) {
            attributes.put("snpThreshold", String.valueOf(this.snpThreshold));
        }
        attributes.put("autoScale", String.valueOf(this.autoScale));
        if (this.showReference) {
            attributes.put("showReference", String.valueOf(this.showReference));
        }
        return attributes;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        super.restorePersistentState(attributes);
        String value = attributes.get("snpThreshold");
        if (value != null) {
            this.snpThreshold = Float.parseFloat(value);
        }
        if ((value = attributes.get("autoScale")) != null) {
            this.autoScale = Boolean.parseBoolean(value);
        }
        if ((value = attributes.get("showReference")) != null) {
            this.showReference = Boolean.parseBoolean(value);
        }
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu popupMenu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            popupMenu.add(popupTitle);
        }
        popupMenu.addSeparator();
        ArrayList<Track> tmp = new ArrayList<Track>();
        tmp.add(this);
        popupMenu.add(TrackMenuUtils.getTrackRenameItem(tmp));
        this.addAutoscaleItem(popupMenu);
        this.addLogScaleItem(popupMenu);
        this.dataRangeItem = this.addDataRangeItem(popupMenu, tmp);
        this.dataRangeItem.setEnabled(!this.autoScale);
        this.addSnpTresholdItem(popupMenu);
        popupMenu.addSeparator();
        this.addLoadCoverageDataItem(popupMenu);
        popupMenu.addSeparator();
        popupMenu.add(TrackMenuUtils.getRemoveMenuItem(tmp));
        return popupMenu;
    }

    public JMenuItem addDataRangeItem(JPopupMenu menu, final Collection<Track> selectedTracks) {
        JMenuItem maxValItem = new JMenuItem("Set Data Range");
        maxValItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (selectedTracks.size() > 0) {
                    DataRange prevAxisDefinition = ((Track)selectedTracks.iterator().next()).getDataRange();
                    DataRangeDialog dlg = new DataRangeDialog(IGV.getMainFrame(), prevAxisDefinition);
                    dlg.setHideMid(true);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        float min = Math.min(dlg.getMin(), dlg.getMax());
                        float max = Math.max(dlg.getMin(), dlg.getMax());
                        float mid = dlg.getBase();
                        if (mid < min) {
                            mid = min;
                        } else if (mid > max) {
                            mid = max;
                        }
                        DataRange dataRange = new DataRange(min, mid, max);
                        dataRange.setType(CoverageTrack.this.getDataRange().getType());
                        for (Track track : selectedTracks) {
                            track.setDataRange(dataRange);
                        }
                        IGV.getMainFrame().repaint();
                    }
                }
            }
        });
        menu.add(maxValItem);
        return maxValItem;
    }

    public JMenuItem addSnpTresholdItem(JPopupMenu menu) {
        JMenuItem maxValItem = new JMenuItem("Set allele frequency threshold...");
        maxValItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = JOptionPane.showInputDialog("Allele frequency threshold: ", (Object)Float.valueOf(CoverageTrack.this.snpThreshold));
                if (value == null) {
                    return;
                }
                try {
                    float tmp = Float.parseFloat(value);
                    CoverageTrack.this.snpThreshold = tmp;
                    IGV.getInstance().repaintDataPanels();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        menu.add(maxValItem);
        return maxValItem;
    }

    public void addLoadCoverageDataItem(JPopupMenu menu) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Load coverage data...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceManager prefs = PreferenceManager.getInstance();
                File initDirectory = prefs.getLastTrackDirectory();
                File file = FileDialogUtils.chooseFile("Select coverage file", initDirectory, 0);
                if (file != null) {
                    prefs.setLastTrackDirectory(file.getParentFile());
                    String path = file.getAbsolutePath();
                    if (path.endsWith(".tdf") || path.endsWith(".tdf")) {
                        TDFReader reader = TDFReader.getReader(file.getAbsolutePath());
                        TDFDataSource ds = new TDFDataSource(reader, 0, CoverageTrack.this.getName() + " coverage", CoverageTrack.this.genome);
                        CoverageTrack.this.setDataSource(ds);
                        IGV.getInstance().repaintDataPanels();
                    } else if (path.endsWith(".counts")) {
                        GobyCountArchiveDataSource ds = new GobyCountArchiveDataSource(file);
                        CoverageTrack.this.setDataSource(ds);
                        IGV.getInstance().repaintDataPanels();
                    } else {
                        MessageUtils.showMessage("Coverage data must be in .tdf format");
                    }
                }
            }
        });
        menu.add(item);
    }

    public void addAutoscaleItem(JPopupMenu menu) {
        this.autoscaleItem = new JCheckBoxMenuItem("Autoscale");
        this.autoscaleItem.setSelected(this.autoScale);
        this.autoscaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageTrack.this.autoScale = CoverageTrack.this.autoscaleItem.isSelected();
                CoverageTrack.this.dataRangeItem.setEnabled(!CoverageTrack.this.autoScale);
                if (CoverageTrack.this.autoScale) {
                    CoverageTrack.this.rescale();
                }
                IGV.getInstance().repaintDataPanels();
            }
        });
        menu.add(this.autoscaleItem);
    }

    public void addLogScaleItem(JPopupMenu menu) {
        final DataRange dataRange = this.getDataRange();
        final JCheckBoxMenuItem logScaleItem = new JCheckBoxMenuItem("Log scale");
        boolean logScale = dataRange.getType() == DataRange.Type.LOG;
        logScaleItem.setSelected(logScale);
        logScaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataRange.Type scaleType = logScaleItem.isSelected() ? DataRange.Type.LOG : DataRange.Type.LINEAR;
                dataRange.setType(scaleType);
                IGV.getInstance().repaintDataPanels();
            }
        });
        menu.add(logScaleItem);
    }

    class IntervalRenderer {
        IntervalRenderer() {
        }

        private void paint(RenderContext context, Rectangle rect, List<AlignmentCounts> countList) {
            Graphics2D graphics = context.getGraphic2DForColor(coverageGrey);
            Graphics2D posGraphics = context.getGraphic2DForColor(posStrandColor);
            Graphics2D negGraphics = context.getGraphic2DForColor(negStrandColor);
            DataRange range = CoverageTrack.this.getDataRange();
            double maxRange = range.isLog() ? Math.log10(range.getMaximum()) : (double)range.getMaximum();
            int lastpX = Integer.MIN_VALUE;
            double rectX = rect.getX();
            double rectMaxX = rect.getMaxX();
            double rectY = rect.getY();
            double rectMaxY = rect.getMaxY();
            double rectHeight = rect.getHeight();
            double origin = context.getOrigin();
            double colorScaleMax = CoverageTrack.this.getColorScale().getMaximum();
            double scale = context.getScale();
            boolean bisulfiteMode = CoverageTrack.this.dataManager.getExperimentType() == AlignmentTrack.ExperimentType.BISULFITE;
            block0: for (AlignmentCounts alignmentCounts : countList) {
                int pos;
                AlignmentCounts.PositionIterator posIter = alignmentCounts.getPositionIterator();
                while ((pos = posIter.nextPosition()) >= 0) {
                    int pX = (int)(rectX + ((double)pos - origin) / scale);
                    int dX = Math.max(1, (int)(rectX + ((double)(pos + 1) - origin) / scale) - pX);
                    if (dX > 3) {
                        --dX;
                    }
                    if ((double)pX > rectMaxX) continue block0;
                    if (pX + dX < 0 || pX < lastpX) continue;
                    int pY = (int)rectMaxY - 1;
                    int totalCount = alignmentCounts.getTotalCount(pos);
                    double tmp = range.isLog() ? Math.log10(totalCount) / maxRange : (double)totalCount / maxRange;
                    int height = (int)(tmp * rectHeight);
                    height = Math.min(height, rect.height - 1);
                    int topY = pY - height;
                    if (height <= 0 || pX < lastpX) continue;
                    graphics.fillRect(pX, topY, dX, height);
                    lastpX = pX + dX;
                }
            }
            block2: for (AlignmentCounts alignmentCounts : countList) {
                int pos;
                BisulfiteCounts bisulfiteCounts = alignmentCounts.getBisulfiteCounts();
                int intervalEnd = alignmentCounts.getEnd();
                int intervalStart = alignmentCounts.getStart();
                byte[] refBases = null;
                int twoMB = 2000000;
                if (intervalEnd - intervalStart < 2000000) {
                    refBases = CoverageTrack.this.genome.getSequence(context.getChr(), intervalStart, intervalEnd);
                }
                AlignmentCounts.PositionIterator posIter = alignmentCounts.getPositionIterator();
                while ((pos = posIter.nextPosition()) >= 0) {
                    int idx;
                    int pX;
                    int dX;
                    BisulfiteCounts.Count bc = null;
                    if (bisulfiteMode && bisulfiteCounts != null) {
                        bc = bisulfiteCounts.getCount(pos);
                    }
                    if ((dX = Math.max(1, (int)(rectX + ((double)(pos + 1) - origin) / scale) - (pX = (int)(rectX + ((double)pos - origin) / scale)))) > 3) {
                        --dX;
                    }
                    if ((double)pX > rectMaxX) continue block2;
                    if (pX + dX < 0) continue;
                    boolean mismatch = false;
                    if (refBases != null && (idx = pos - intervalStart) >= 0 && idx < refBases.length) {
                        if (bisulfiteMode) {
                            mismatch = bc != null && bc.methylatedCount + bc.unmethylatedCount > 0;
                        } else {
                            char ref = Character.toLowerCase((char)refBases[idx]);
                            mismatch = alignmentCounts.isMismatch(pos, ref, context.getChr(), CoverageTrack.this.snpThreshold);
                        }
                    }
                    if (!mismatch) continue;
                    int pY = (int)rectMaxY - 1;
                    int totalCount = alignmentCounts.getTotalCount(pos);
                    double tmp = range.isLog() ? Math.log10(totalCount) / maxRange : (double)totalCount / maxRange;
                    int height = (int)(tmp * rectHeight);
                    if ((height = Math.min(height, rect.height - 1)) <= 0) continue;
                    if (bisulfiteMode) {
                        if (bc == null) continue;
                        CoverageTrack.this.drawBarBisulfite(context, pos, rect, totalCount, maxRange, pY, pX, dX, bc, range.isLog());
                        continue;
                    }
                    CoverageTrack.this.drawBar(context, pos, rect, totalCount, maxRange, pY, pX, dX, alignmentCounts, range.isLog());
                }
            }
        }
    }
}

