/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class IconFactory {
    private Map<IconID, ImageIcon> icons = new HashMap<IconID, ImageIcon>();
    private static IconFactory theInstance = null;

    public static IconFactory getInstance() {
        if (theInstance == null) {
            theInstance = new IconFactory();
        }
        return theInstance;
    }

    private IconFactory() {
        this.icons.put(IconID.DRAG_AND_DROP, this.createImageIcon("/images/dragNdrop.png", "drag and drop"));
        this.icons.put(IconID.ZOOM, this.createImageIcon("/images/zoomin.gif", "zoom"));
        this.icons.put(IconID.ZOOM_IN, this.createImageIcon("/toolbarButtonGraphics/general/ZoomIn24.gif", "Zoom in"));
        this.icons.put(IconID.ZOOM_OUT, this.createImageIcon("/toolbarButtonGraphics/general/ZoomOut24.gif", "zoom out"));
        this.icons.put(IconID.SLIDER, this.createImageIcon("/images/slider.png", "zoom out"));
        this.icons.put(IconID.SLIDER_BOTTOM, this.createImageIcon("/images/dsliderbottom.png", "zoom out"));
        this.icons.put(IconID.SLIDER_TOP, this.createImageIcon("/images/dslidertop.png", "zoom out"));
        this.icons.put(IconID.SLIDER_BAR, this.createImageIcon("/images/dsliderbar.png", "zoom out"));
        this.icons.put(IconID.ZOOM_PLUS, this.createImageIcon("/images/zoom-plus.png", "zoom out"));
        this.icons.put(IconID.ZOOM_MINUS, this.createImageIcon("/images/zoom-minus.png", "zoom out"));
        this.icons.put(IconID.OPEN_HAND, this.createImageIcon("/images/cursor-openhand-dot.png", "drag"));
        this.icons.put(IconID.FIST, this.createImageIcon("/images/cursor-fist.png", "drag"));
        this.icons.put(IconID.REGION_OF_INTEREST, this.createImageIcon("/images/regionTool.png", "region of interest"));
        this.icons.put(IconID.REFRESH, this.createImageIcon("/toolbarButtonGraphics/general/Refresh24.gif", "refresh"));
        this.icons.put(IconID.HOME, this.createImageIcon("/toolbarButtonGraphics/navigation/Home24.gif", "home"));
        this.icons.put(IconID.NO_TOOLTIP, this.createImageIcon("/images/no-tooltip.png", "suppress tooltip"));
        this.icons.put(IconID.TOOLTIP, this.createImageIcon("/images/tooltip.png", "tooltip"));
    }

    public ImageIcon getIcon(IconID id) {
        return this.icons.get((Object)id);
    }

    private ImageIcon createImageIcon(String url, String description) {
        URL imgURL = this.getClass().getResource(url);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + url);
        return null;
    }

    public static enum IconID {
        DRAG_AND_DROP,
        SLIDER,
        SLIDER_BOTTOM,
        SLIDER_TOP,
        SLIDER_BAR,
        ZOOM,
        ZOOM_PLUS,
        ZOOM_MINUS,
        ZOOM_IN,
        ZOOM_OUT,
        REGION_OF_INTEREST,
        NO_TOOLTIP,
        TOOLTIP,
        SEARCH,
        OPEN_HAND,
        REFRESH,
        HOME,
        FIST;

    }
}

