/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.renderer.CytobandRenderer;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.panel.ReferenceFrame;

public class CytobandPanel
extends JPanel {
    private static int fontHeight = 10;
    private static int bandHeight = 10;
    private static String fontFamilyName = "Lucida Sans";
    private boolean isDragging = false;
    private double viewOrigin;
    double cytobandScale;
    ReferenceFrame frame;
    private Rectangle currentRegionRect;
    private CytobandRenderer cytobandRenderer;
    private List<Cytoband> currentCytobands;

    public CytobandPanel(ReferenceFrame frame) {
        this(frame, true);
    }

    public CytobandPanel(ReferenceFrame frame, boolean mouseable) {
        this.frame = frame;
        this.viewOrigin = frame.getOrigin();
        FontManager.getFont(fontHeight);
        this.setFont(new Font(fontFamilyName, 1, fontHeight));
        if (mouseable) {
            this.initMouseAdapter();
        }
        this.cytobandRenderer = new CytobandRenderer();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.frame.getChrName().equals("All") || this.getWidth() < 10) {
            return;
        }
        int dataPanelWidth = this.frame.getWidthInPixels();
        Rectangle cytoRect = new Rectangle(0, 10, dataPanelWidth, bandHeight);
        Chromosome chromosome = this.getReferenceFrame().getChromosome();
        if (chromosome == null) {
            return;
        }
        this.currentCytobands = chromosome.getCytobands();
        if (this.currentCytobands == null) {
            return;
        }
        this.cytobandRenderer.draw(this.currentCytobands, g, cytoRect, this.frame);
        int chromosomeLength = this.getReferenceFrame().getChromosomeLength();
        this.cytobandScale = (double)chromosomeLength / (double)dataPanelWidth;
        if (this.getReferenceFrame().getZoom() > 0) {
            double scale = this.getReferenceFrame().getScale();
            double origin = this.isDragging ? this.viewOrigin : this.getReferenceFrame().getOrigin();
            int start = (int)(origin / this.cytobandScale);
            double scaledDataPanelWidth = (double)dataPanelWidth * scale;
            int span = (int)(scaledDataPanelWidth / this.cytobandScale);
            int height = (int)cytoRect.getHeight();
            g.setColor(Color.RED);
            int y = (int)cytoRect.getY() + 5;
            this.currentRegionRect = new Rectangle(start - 2, y, span + 4, height);
            g.drawRect(start, y, span, height);
            g.drawRect(start - 1, y - 1, span + 2, height + 2);
            g.drawRect(start - 2, y - 2, span + 4, height + 4);
            if (span < 2) {
                g.drawRect(start - 2, y - 2, span + 4, height + 4);
            }
        }
    }

    private void initMouseAdapter() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setToolTipText("<html>Click anywhere on the chromosome<br/>to center view at that location.");
        MouseInputAdapter mouseAdapter = new MouseInputAdapter(){
            int lastMousePressX;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                if (CytobandPanel.this.currentCytobands == null) {
                    return;
                }
                int mouseX = e.getX();
                int clickCount = e.getClickCount();
                WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                try {
                    double newLocation = CytobandPanel.this.cytobandScale * (double)mouseX;
                    if (clickCount > 1) {
                        int newZoom = CytobandPanel.this.getReferenceFrame().getZoom() + 1;
                        CytobandPanel.this.getReferenceFrame().zoomTo(newZoom, newLocation);
                    } else {
                        CytobandPanel.this.getReferenceFrame().centerOnLocation(newLocation);
                    }
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.lastMousePressX = e.getX();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent e) {
                if (CytobandPanel.this.currentCytobands == null) {
                    return;
                }
                if (CytobandPanel.this.isDragging) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        CytobandPanel.this.getReferenceFrame().setOrigin(CytobandPanel.this.viewOrigin);
                        CytobandPanel.this.getReferenceFrame().recordHistory();
                    }
                    finally {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                }
                CytobandPanel.this.isDragging = false;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (CytobandPanel.this.currentCytobands == null) {
                    return;
                }
                if (!CytobandPanel.this.isDragging && CytobandPanel.this.currentRegionRect != null && CytobandPanel.this.currentRegionRect.contains(e.getPoint())) {
                    CytobandPanel.this.isDragging = true;
                    CytobandPanel.this.viewOrigin = CytobandPanel.this.getReferenceFrame().getOrigin();
                }
                int w = CytobandPanel.this.getWidth();
                double scale = CytobandPanel.this.getReferenceFrame().getScale();
                int x = (int)Math.max(0.0, Math.min((double)e.getX(), (double)w * (CytobandPanel.this.cytobandScale - scale)));
                int delta = x - this.lastMousePressX;
                if (delta != 0 && CytobandPanel.this.cytobandScale > 0.0) {
                    CytobandPanel.this.viewOrigin = Math.max(0.0, Math.min(CytobandPanel.this.viewOrigin + (double)delta * CytobandPanel.this.cytobandScale, (double)w * (CytobandPanel.this.cytobandScale - scale)));
                    CytobandPanel.this.repaint();
                }
                this.lastMousePressX = x;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    private ReferenceFrame getReferenceFrame() {
        return this.frame;
    }
}

