/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.channels.ClosedByInterruptException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.batch.CommandExecutor;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.StringUtils;

public class CommandListener
implements Runnable {
    private static Logger log = Logger.getLogger(CommandListener.class);
    private static CommandListener listener;
    private int port = -1;
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private Thread listenerThread;
    boolean halt = false;
    private static final String CRNL = "\r\n";
    private static final String CONTENT_TYPE = "Content-Type: ";
    private static final String HTTP_RESPONSE = "HTTP/1.1 200 OK";
    private static final String HTTP_NO_RESPONSE = "HTTP/1.1 204 No Response";
    private static final String CONTENT_LENGTH = "Content-Length: ";
    private static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    private static final String CONNECTION_CLOSE = "Connection: close";

    public static synchronized void start(int port) {
        listener = new CommandListener(port);
        CommandListener.listener.listenerThread.start();
    }

    public static synchronized void halt() {
        if (listener != null) {
            CommandListener.listener.halt = true;
            CommandListener.listener.listenerThread.interrupt();
            listener.closeSockets();
            listener = null;
        }
    }

    private CommandListener(int port) {
        this.port = port;
        this.listenerThread = new Thread(this);
    }

    @Override
    public void run() {
        block7: {
            CommandExecutor cmdExe = new CommandExecutor();
            try {
                this.serverSocket = new ServerSocket(this.port);
                log.info("Listening on port " + this.port);
                while (!this.halt) {
                    this.clientSocket = this.serverSocket.accept();
                    this.processClientSession(cmdExe);
                    if (this.clientSocket == null) continue;
                    try {
                        this.clientSocket.close();
                        this.clientSocket = null;
                    }
                    catch (IOException e) {
                        log.error("Error in client socket loop", e);
                    }
                }
            }
            catch (BindException e) {
                log.error(e);
            }
            catch (ClosedByInterruptException e) {
                log.error(e);
            }
            catch (IOException e) {
                if (this.halt) break block7;
                log.error("IO Error on port socket ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClientSession(CommandExecutor cmdExe) throws IOException {
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            String inputLine;
            out = new PrintWriter(this.clientSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            while (!this.halt && (inputLine = in.readLine()) != null) {
                String cmd = inputLine;
                if (cmd.startsWith("GET")) {
                    String command = null;
                    Map<String, String> params = null;
                    String[] tokens = inputLine.split(" ");
                    if (tokens.length < 2) {
                        this.sendHTTPResponse(out, "ERROR unexpected command line: " + inputLine);
                        return;
                    }
                    String[] parts = tokens[1].split("\\?");
                    if (parts.length < 2) {
                        this.sendHTTPResponse(out, "ERROR unexpected command line: " + inputLine);
                        return;
                    }
                    command = parts[0];
                    params = this.parseParameters(parts[1]);
                    String nextLine = in.readLine();
                    while (nextLine != null && nextLine.length() > 0) {
                        nextLine = in.readLine();
                    }
                    String callback = params.get("callback");
                    if (callback != null) {
                        this.sendHTTPResponse(out, callback);
                    }
                    this.processGet(command, params, cmdExe);
                    if (callback == null) {
                        this.sendHTTPResponse(out, null);
                    }
                    return;
                }
                Globals.setBatch(true);
                Globals.setSuppressMessages(true);
                String response = cmdExe.execute(inputLine);
                out.println(response);
            }
        }
        catch (IOException e) {
            log.error("Error processing client session", e);
        }
        finally {
            Globals.setSuppressMessages(false);
            Globals.setBatch(false);
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private void closeSockets() {
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
                this.clientSocket = null;
            }
            catch (IOException e) {
                log.error("Error closing clientSocket", e);
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (IOException e) {
                log.error("Error closing server socket", e);
            }
        }
    }

    private void sendHTTPResponse(PrintWriter out, String result) {
        out.println(result == null ? HTTP_NO_RESPONSE : HTTP_RESPONSE);
        if (result != null) {
            out.print("Content-Type: text/html");
            out.print(CRNL);
            out.print(CONTENT_LENGTH + result.length());
            out.print(CRNL);
            out.print(CONNECTION_CLOSE);
            out.print(CRNL);
            out.print(CRNL);
            out.print(result);
            out.print(CRNL);
        }
        out.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String processGet(String command, Map<String, String> params, CommandExecutor cmdExe) throws IOException {
        String result = "OK";
        Frame mainFrame = IGV.getMainFrame();
        mainFrame.toFront();
        mainFrame.setAlwaysOnTop(true);
        mainFrame.setAlwaysOnTop(false);
        if (command.equals("/load")) {
            String file = params.get("file");
            if (file == null) {
                file = params.get("bigDataURL");
            }
            if (file == null) {
                file = params.get("sessionURL");
            }
            if (file == null) {
                file = params.get("dataURL");
            }
            if (file == null) return "ERROR Parameter \"file\" is required";
            String genomeID = params.get("genome");
            if (genomeID == null) {
                genomeID = params.get("db");
            }
            String mergeValue = params.get("merge");
            String locus = params.get("locus");
            String name = params.get("name");
            if (genomeID != null) {
                IGV.getFirstInstance().selectGenomeFromList(genomeID);
            }
            if (genomeID != null) {
                genomeID = URLDecoder.decode(genomeID, "UTF-8");
            }
            if (mergeValue != null) {
                mergeValue = URLDecoder.decode(mergeValue, "UTF-8");
            }
            if (locus != null) {
                locus = URLDecoder.decode(locus, "UTF-8");
            }
            boolean merge = mergeValue != null ? mergeValue.equalsIgnoreCase("true") : !file.endsWith(".xml") && !file.endsWith(".php") && !file.endsWith(".php3");
            return cmdExe.loadFiles(file, locus, merge, name, params);
        }
        if (!command.equals("/reload")) {
            if (!command.equals("/goto")) return "ERROR Unknown command: " + command;
        }
        String locus = params.get("locus");
        IGV.getFirstInstance().goToLocus(locus);
        return result;
    }

    private Map<String, String> parseParameters(String parameterString) {
        String[] kvPairs;
        parameterString = parameterString.replace("&amp;", "&");
        HashMap<String, String> params = new HashMap<String, String>();
        for (String kvString : kvPairs = parameterString.split("&")) {
            String[] kv = kvString.split("=", 2);
            if (kv.length == 1) {
                params.put(kv[0], null);
                continue;
            }
            String key = StringUtils.decodeURL(kv[0]);
            String value = key.equals("locus") ? kv[1] : StringUtils.decodeURL(kv[1]);
            params.put(kv[0], value);
        }
        return params;
    }
}

