/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.FeatureFileHeader;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.readers.LineReader;

public class REPMaskCodec
implements FeatureCodec {
    String[] tokens = new String[15];
    FeatureFileHeader header;
    Genome genome;

    public REPMaskCodec(Genome genome) {
        this.genome = genome;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object readHeader(LineReader reader) {
        this.header = new FeatureFileHeader();
        this.header.setTrackType(TrackType.REPMASK);
        int nLines = 0;
        try {
            while (true) {
                String nextLine;
                if (!((nextLine = reader.readLine()) != null && (nextLine.startsWith("#") || nextLine.startsWith("track")) || nextLine.startsWith("browser"))) {
                    return this.header;
                }
                ++nLines;
                if (nextLine.startsWith("#type")) {
                    String[] tokens = nextLine.split("=");
                    if (tokens.length <= 1) continue;
                    try {
                        this.header.setTrackType(TrackType.valueOf(tokens[1]));
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (!nextLine.startsWith("track")) continue;
                TrackProperties tp = new TrackProperties();
                ParsingUtils.parseTrackLine(nextLine, tp);
                this.header.setTrackProperties(tp);
            }
        }
        catch (IOException e) {
            throw new CodecLineParsingException("Error parsing header", e);
        }
    }

    @Override
    public boolean canDecode(String path) {
        return true;
    }

    @Override
    public Feature decodeLoc(String line) {
        String chr = this.genome == null ? this.tokens[5] : this.genome.getChromosomeAlias(this.tokens[5]);
        int start = Integer.parseInt(this.tokens[6]);
        int end = Integer.parseInt(this.tokens[7]);
        return new BasicFeature(chr, start, end);
    }

    public BasicFeature decode(String nextLine) {
        int strand;
        if (nextLine.trim().length() == 0 || nextLine.startsWith("#")) {
            return null;
        }
        int tokenCount = ParsingUtils.splitWhitespace(nextLine, this.tokens);
        if (tokenCount < 15) {
            return null;
        }
        String chr = this.genome == null ? this.tokens[5] : this.genome.getChromosomeAlias(this.tokens[5]);
        int start = Integer.parseInt(this.tokens[6]);
        int end = Integer.parseInt(this.tokens[7]);
        BasicFeature feature = new BasicFeature(chr, start, end);
        String strandString = this.tokens[3].trim();
        int n = strand = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
        if (strand == 45) {
            feature.setStrand(Strand.NEGATIVE);
        } else if (strand == 43) {
            feature.setStrand(Strand.POSITIVE);
        } else {
            feature.setStrand(Strand.NONE);
        }
        String name = this.tokens[10];
        feature.setName(name);
        feature.setIdentifier(name);
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("Smith Waterman score", this.tokens[1]);
        attributes.put("base mismatches per thousand", this.tokens[2]);
        attributes.put("bases deleted per thousand", this.tokens[3]);
        attributes.put("bases inserted per thousand", this.tokens[4]);
        attributes.put("repeat class", this.tokens[11]);
        attributes.put("repeat family", this.tokens[12]);
        attributes.put("repeat start", this.tokens[13]);
        attributes.put("repeat end", this.tokens[14]);
        feature.setAttributes(attributes);
        return feature;
    }

    public Class getFeatureType() {
        return BasicFeature.class;
    }
}

