/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentPacker;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CachingQueryReader;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ArrayHeapObjectSorter;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;

public class AlignmentDataManager {
    private static Logger log = Logger.getLogger(AlignmentDataManager.class);
    private static final int DEFAULT_DEPTH = 10;
    private HashMap<String, AlignmentInterval> loadedIntervalMap = new HashMap(50);
    private HashMap<String, String> chrMappings = new HashMap();
    private boolean isLoading = false;
    private CachingQueryReader reader;
    private CoverageTrack coverageTrack;
    private boolean viewAsPairs = false;
    private static final int MAX_ROWS = 1000000;
    private Map<String, PEStats> peStats;
    private AlignmentTrack.ExperimentType experimentType;
    private boolean showSpliceJunctions;

    public AlignmentDataManager(ResourceLocator locator, Genome genome) throws IOException {
        PreferenceManager prefs = PreferenceManager.getInstance();
        this.reader = new CachingQueryReader(AlignmentReaderFactory.getReader(locator));
        this.peStats = new HashMap<String, PEStats>();
        this.showSpliceJunctions = prefs.getAsBoolean("SAM.SHOW_JUNCTION_TRACK");
        this.initChrMap(genome);
    }

    public void setShowSpliceJunctions(boolean showSpliceJunctions) {
        this.showSpliceJunctions = showSpliceJunctions;
    }

    private void initChrMap(Genome genome) {
        Set<String> seqNames;
        if (genome != null && (seqNames = this.reader.getSequenceNames()) != null) {
            for (String chr : seqNames) {
                String alias = genome.getChromosomeAlias(chr);
                this.chrMappings.put(alias, chr);
            }
        }
    }

    public void setExperimentType(AlignmentTrack.ExperimentType experimentType) {
        this.experimentType = experimentType;
        this.showSpliceJunctions = experimentType == AlignmentTrack.ExperimentType.BISULFITE ? false : PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_JUNCTION_TRACK");
    }

    public AlignmentTrack.ExperimentType getExperimentType() {
        return this.experimentType;
    }

    public CachingQueryReader getReader() {
        return this.reader;
    }

    public Map<String, PEStats> getPEStats() {
        return this.peStats;
    }

    public boolean isPairedEnd() {
        return this.reader.isPairedEnd();
    }

    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public Set<String> getSequenceNames() {
        return this.reader.getSequenceNames();
    }

    public AlignmentInterval getLoadedInterval(ReferenceFrame frame) {
        return this.loadedIntervalMap.get(frame.getName());
    }

    public void sortRows(AlignmentTrack.SortOption option, ReferenceFrame referenceFrame, double location, String tag) {
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(referenceFrame.getName());
        if (loadedInterval != null) {
            loadedInterval.sortRows(option, location, tag);
        }
    }

    public boolean isViewAsPairs() {
        return this.viewAsPairs;
    }

    public void setViewAsPairs(boolean option, AlignmentTrack.RenderOptions renderOptions) {
        if (option == this.viewAsPairs) {
            return;
        }
        boolean currentPairState = this.viewAsPairs;
        this.viewAsPairs = option;
        for (ReferenceFrame frame : FrameManager.getFrames()) {
            this.repackAlignments(frame, currentPairState, renderOptions);
        }
    }

    private void repackAlignments(ReferenceFrame referenceFrame, boolean currentPairState, AlignmentTrack.RenderOptions renderOptions) {
        if (currentPairState) {
            AlignmentInterval loadedInterval = this.loadedIntervalMap.get(referenceFrame.getName());
            if (loadedInterval == null) {
                return;
            }
            LinkedHashMap<String, List<AlignmentInterval.Row>> groupedAlignments = loadedInterval.getGroupedAlignments();
            ArrayList<Alignment> alignments = new ArrayList<Alignment>(Math.min(50000, groupedAlignments.size() * 10000));
            for (List alignmentRows : groupedAlignments.values()) {
                for (AlignmentInterval.Row row : alignmentRows) {
                    for (Alignment al : row.alignments) {
                        if (al instanceof PairedAlignment) {
                            PairedAlignment pair = (PairedAlignment)al;
                            alignments.add(pair.firstAlignment);
                            if (pair.secondAlignment == null) continue;
                            alignments.add(pair.secondAlignment);
                            continue;
                        }
                        alignments.add(al);
                    }
                }
            }
            ArrayHeapObjectSorter<Alignment> heapSorter = new ArrayHeapObjectSorter<Alignment>();
            heapSorter.sort(alignments, new Comparator<Alignment>(){

                @Override
                public int compare(Alignment alignment, Alignment alignment1) {
                    return alignment.getStart() - alignment1.getStart();
                }
            });
            int max = Integer.MAX_VALUE;
            LinkedHashMap<String, List<AlignmentInterval.Row>> tmp = new AlignmentPacker().packAlignments(alignments.iterator(), loadedInterval.getEnd(), this.viewAsPairs, renderOptions);
            loadedInterval.setAlignmentRows(tmp);
        } else {
            this.repackAlignments(referenceFrame, renderOptions);
        }
    }

    public void repackAlignments(ReferenceFrame referenceFrame, AlignmentTrack.RenderOptions renderOptions) {
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(referenceFrame.getName());
        if (loadedInterval == null) {
            return;
        }
        Iterator<Alignment> iter = loadedInterval.getAlignmentIterator();
        int max = Integer.MAX_VALUE;
        LinkedHashMap<String, List<AlignmentInterval.Row>> alignmentRows = new AlignmentPacker().packAlignments(iter, loadedInterval.getEnd(), this.viewAsPairs || renderOptions.isPairedArcView(), renderOptions);
        loadedInterval.setAlignmentRows(alignmentRows);
    }

    public synchronized LinkedHashMap<String, List<AlignmentInterval.Row>> getGroups(RenderContext context, AlignmentTrack.RenderOptions renderOptions, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        String genomeId = context.getGenomeId();
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation() + 1;
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(context.getReferenceFrame().getName());
        if (loadedInterval == null || !loadedInterval.contains(chr, start, end)) {
            this.loadAlignments(chr, start, end, renderOptions, context, bisulfiteContext);
        }
        if (loadedInterval != null && loadedInterval.overlaps(chr, start, end)) {
            return loadedInterval.getGroupedAlignments();
        }
        return null;
    }

    public void clear() {
        this.reader.clearCache();
        this.loadedIntervalMap.clear();
    }

    public synchronized void loadAlignments(final String chr, final int start, final int end, final AlignmentTrack.RenderOptions renderOptions, final RenderContext context, final AlignmentTrack.BisulfiteContext bisulfiteContext) {
        if (this.isLoading || chr.equals("All")) {
            return;
        }
        log.debug("Load alignments.  isLoading=" + this.isLoading);
        this.isLoading = true;
        NamedRunnable runnable = new NamedRunnable(){

            @Override
            public String getName() {
                return "loadAlignments";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                log.debug("Loading alignments: " + chr + ":" + start + "-" + end);
                int expandLength = Math.min(8000, AlignmentDataManager.this.reader.getTileSize(chr) / 2);
                int intervalStart = start - expandLength;
                int intervalEnd = end + expandLength;
                DownsampleOptions downsampleOptions = new DownsampleOptions();
                CloseableIterator<Alignment> iter = null;
                try {
                    String sequence = AlignmentDataManager.this.chrMappings.containsKey(chr) ? (String)AlignmentDataManager.this.chrMappings.get(chr) : chr;
                    ArrayList<AlignmentCounts> counts = new ArrayList<AlignmentCounts>();
                    ArrayList<CachingQueryReader.DownsampledInterval> downsampledIntervals = new ArrayList<CachingQueryReader.DownsampledInterval>();
                    ArrayList<SpliceJunctionFeature> spliceJunctions = null;
                    if (AlignmentDataManager.this.showSpliceJunctions) {
                        spliceJunctions = new ArrayList<SpliceJunctionFeature>();
                    }
                    iter = AlignmentDataManager.this.reader.query(sequence, intervalStart, intervalEnd, counts, spliceJunctions, downsampledIntervals, downsampleOptions, AlignmentDataManager.this.peStats, bisulfiteContext);
                    AlignmentPacker alignmentPacker = new AlignmentPacker();
                    LinkedHashMap<String, List<AlignmentInterval.Row>> alignmentRows = alignmentPacker.packAlignments(iter, intervalEnd, AlignmentDataManager.this.viewAsPairs || renderOptions.isPairedArcView(), renderOptions);
                    AlignmentInterval loadedInterval = new AlignmentInterval(chr, intervalStart, intervalEnd, alignmentRows, counts, spliceJunctions, downsampledIntervals);
                    AlignmentDataManager.this.loadedIntervalMap.put(context.getReferenceFrame().getName(), loadedInterval);
                    if (AlignmentDataManager.this.coverageTrack != null) {
                        AlignmentDataManager.this.coverageTrack.rescale(context.getReferenceFrame());
                    }
                    if (context.getPanel() != null) {
                        // empty if block
                    }
                }
                catch (Exception exception) {
                    log.error("Error loading alignments", exception);
                    JOptionPane.showMessageDialog(IGV.getMainFrame(), "Error reading file: " + exception.getMessage());
                }
                finally {
                    if (iter != null) {
                        iter.close();
                    }
                    AlignmentDataManager.this.isLoading = false;
                }
            }
        };
        LongRunningTask.submit(runnable);
    }

    private boolean isMitochondria(String chr) {
        return chr.equals("M") || chr.equals("chrM") || chr.equals("MT") || chr.equals("chrMT");
    }

    public Map<String, List<AlignmentInterval.Row>> getGroupedAlignments(ReferenceFrame referenceFrame) {
        AlignmentInterval loadedInterval = this.loadedIntervalMap.get(referenceFrame.getName());
        return loadedInterval == null ? null : loadedInterval.getGroupedAlignments();
    }

    public int getNLevels() {
        int nLevels = 0;
        for (AlignmentInterval loadedInterval : this.loadedIntervalMap.values()) {
            int intervalNLevels = 0;
            Collection<List<AlignmentInterval.Row>> tmp = loadedInterval.getGroupedAlignments().values();
            for (List<AlignmentInterval.Row> rows : tmp) {
                intervalNLevels += rows.size();
            }
            nLevels = Math.max(nLevels, intervalNLevels);
        }
        return nLevels;
    }

    public int getMaxGroupCount() {
        int groupCount = 0;
        for (AlignmentInterval loadedInterval : this.loadedIntervalMap.values()) {
            groupCount = Math.max(groupCount, loadedInterval.getGroupCount());
        }
        return groupCount;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                log.error("Error closing AlignmentQueryReader. ", ex);
            }
        }
    }

    public Collection<AlignmentInterval> getLoadedIntervals() {
        return this.loadedIntervalMap.values();
    }

    public void updatePEStats(AlignmentTrack.RenderOptions renderOptions) {
        if (this.peStats != null) {
            for (PEStats stats : this.peStats.values()) {
                stats.compute(renderOptions.getMinInsertSizePercentile(), renderOptions.getMaxInsertSizePercentile());
            }
        }
    }

    public boolean isShowSpliceJunctions() {
        return this.showSpliceJunctions;
    }

    public static class DownsampleOptions {
        private boolean downsample;
        private int sampleWindowSize;
        private int maxReadCount;

        public DownsampleOptions() {
            PreferenceManager prefs = PreferenceManager.getInstance();
            this.downsample = prefs.getAsBoolean("SAM.DOWNSAMPLE_READS");
            this.sampleWindowSize = prefs.getAsInt("SAM.SAMPLING_WINDOW");
            this.maxReadCount = prefs.getAsInt("SAM.MAX_LEVELS");
        }

        public boolean isDownsample() {
            return this.downsample;
        }

        public void setDownsample(boolean downsample) {
            this.downsample = downsample;
        }

        public int getSampleWindowSize() {
            return this.sampleWindowSize;
        }

        public void setSampleWindowSize(int sampleWindowSize) {
            this.sampleWindowSize = sampleWindowSize;
        }

        public int getMaxReadCount() {
            return this.maxReadCount;
        }

        public void setMaxReadCount(int maxReadCount) {
            this.maxReadCount = maxReadCount;
        }
    }
}

