/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.data;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.hic.data.Block;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.ContactRecord;
import org.broad.igv.hic.data.Dataset;
import org.broad.igv.hic.data.DensityFunction;
import org.broad.igv.hic.data.Matrix;
import org.broad.igv.hic.data.MatrixZoomData;
import org.broad.igv.hic.tools.Preprocessor;
import org.broad.igv.util.CompressionUtils;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class DatasetReader {
    private SeekableStream stream;
    private Map<String, Preprocessor.IndexEntry> masterIndex;
    private long totalCount;
    private DensityFunction densityFunction;
    private Dataset dataset;
    private int version;

    public DatasetReader(SeekableStream stream) {
        this.stream = stream;
        this.masterIndex = new HashMap<String, Preprocessor.IndexEntry>();
        this.dataset = new Dataset(this);
    }

    public Dataset read() throws FileNotFoundException {
        try {
            LittleEndianInputStream dis = new LittleEndianInputStream(new BufferedInputStream(this.stream));
            long masterIndexPos = dis.readLong();
            int nchrs = dis.readInt();
            Chromosome[] chromosomes = new Chromosome[nchrs];
            for (int i = 0; i < nchrs; ++i) {
                String name = dis.readString();
                int size = dis.readInt();
                chromosomes[i] = new Chromosome(i, name, size);
            }
            this.dataset.setChromosomes(chromosomes);
            this.version = 0;
            int nAttributes = dis.readInt();
            for (int i = 0; i < nAttributes; ++i) {
                String key = dis.readString();
                String value = dis.readString();
                if (!key.equals("Version")) continue;
                this.version = Integer.parseInt(value);
            }
            this.readMasterIndex(masterIndexPos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.dataset;
    }

    public int getVersion() {
        return this.version;
    }

    private Map<String, Preprocessor.IndexEntry> readMasterIndex(long position) throws IOException {
        this.stream.seek(position);
        byte[] buffer = new byte[4];
        this.stream.readFully(buffer);
        LittleEndianInputStream dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
        int nBytes = dis.readInt();
        buffer = new byte[nBytes];
        this.stream.readFully(buffer);
        dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
        int nEntries = dis.readInt();
        for (int i = 0; i < nEntries; ++i) {
            String key = dis.readString();
            long filePosition = dis.readLong();
            int sizeInBytes = dis.readInt();
            this.masterIndex.put(key, new Preprocessor.IndexEntry(filePosition, sizeInBytes));
        }
        return this.masterIndex;
    }

    private void readExpectedValues(LittleEndianInputStream dis) throws IOException {
        this.totalCount = dis.readLong();
        int gridSize = dis.readInt();
        int nGrids = dis.readInt();
        double[] densities = new double[nGrids];
        for (int i = 0; i < nGrids; ++i) {
            densities[i] = dis.readDouble();
        }
        int nNormFactors = dis.readInt();
        HashMap<Integer, Double> normFactors = new HashMap<Integer, Double>(nNormFactors);
        for (int i = 0; i < nNormFactors; ++i) {
            Integer key = dis.readInt();
            Double norm = dis.readDouble();
            normFactors.put(key, norm);
        }
        this.densityFunction = new DensityFunction(gridSize, densities, normFactors);
    }

    public Matrix readMatrix(String key) throws IOException {
        Preprocessor.IndexEntry idx = this.masterIndex.get(key);
        if (idx == null) {
            return null;
        }
        byte[] buffer = new byte[idx.size];
        this.stream.seek(idx.position);
        this.stream.readFully(buffer);
        LittleEndianInputStream dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
        int c1 = dis.readInt();
        int c2 = dis.readInt();
        int nZooms = dis.readInt();
        Chromosome chr1 = this.dataset.getChromosomes()[c1];
        Chromosome chr2 = this.dataset.getChromosomes()[c2];
        MatrixZoomData[] zd = new MatrixZoomData[nZooms];
        for (int i = 0; i < nZooms; ++i) {
            zd[i] = new MatrixZoomData(chr1, chr2, this, dis);
        }
        Matrix m = new Matrix(c1, c2, zd);
        return m;
    }

    public Block readBlock(int blockNumber, Preprocessor.IndexEntry idx) throws IOException {
        byte[] compressedBytes = new byte[idx.size];
        this.stream.seek(idx.position);
        this.stream.readFully(compressedBytes);
        byte[] buffer = CompressionUtils.decompress(compressedBytes);
        LittleEndianInputStream dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
        int nRecords = dis.readInt();
        ContactRecord[] records = new ContactRecord[nRecords];
        for (int i = 0; i < nRecords; ++i) {
            try {
                int bin1 = dis.readInt();
                int bin2 = dis.readInt();
                int counts = dis.readInt();
                records[i] = new ContactRecord(blockNumber, bin1, bin2, counts);
                continue;
            }
            catch (EOFException e) {
                nRecords = i;
                ContactRecord[] modifiedRecords = new ContactRecord[nRecords];
                System.arraycopy(records, 0, modifiedRecords, 0, nRecords);
                records = modifiedRecords;
                break;
            }
        }
        return new Block(blockNumber, records);
    }
}

