/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cbio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.cbio.AttributeFilter;
import org.broad.igv.cbio.GeneNetwork;
import org.broad.igv.lists.GeneList;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.util.IndefiniteProgressMonitor;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.BrowserLauncher;
import org.broad.igv.util.HttpUtils;
import org.w3c.dom.Node;

public class FilterGeneNetworkUI
extends JDialog {
    private Logger log = Logger.getLogger(FilterGeneNetworkUI.class);
    private GeneList geneList;
    private List<AttributeFilter> filterRows = new ArrayList<AttributeFilter>(1);
    GeneNetwork network = null;
    private GraphListModel listModel;
    private Map<String, JTextField> thresholdsMap = new HashMap<String, JTextField>(5);
    private static List<String> columnNames;
    private static Map<Integer, String> columnNumToKeyMap;
    private JTabbedPane tabbedPane;
    private JPanel dialogPane;
    private JPanel panel1;
    private JButton addRow;
    private JPanel contentPane;
    private JPanel buttonBar;
    private JCheckBox keepIsolated;
    private JButton okButton;
    private JButton refFilter;
    private JButton cancelButton;
    private JButton helpButton;
    private JScrollPane scrollPane1;
    private JTable geneTable;
    private JPanel thresholds;
    private JPanel contentPanel;
    private JLabel label1;
    private JTextField mutInput;
    private JLabel label2;
    private JTextField ampInput;
    private JLabel label3;
    private JTextField delInput;
    private JLabel label4;
    private JTextField expUpInput;
    private JLabel label7;
    private JTextField expDownInput;

    public FilterGeneNetworkUI(Frame owner, GeneList geneList) {
        super(owner);
        this.geneList = geneList;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.network == null) {
            this.loadcBioData(this.geneList.getLoci());
        } else {
            super.setVisible(visible);
        }
    }

    private void loadcBioData(final List<String> geneLoci) {
        final IndefiniteProgressMonitor indefMonitor = new IndefiniteProgressMonitor(60);
        final ProgressBar progressBar = ProgressBar.showProgressDialog((Frame)this.getOwner(), "Loading cBio data...", indefMonitor, true);
        progressBar.setIndeterminate(true);
        indefMonitor.start();
        final Runnable showUI = new Runnable(){

            @Override
            public void run() {
                FilterGeneNetworkUI.this.initComponents();
                FilterGeneNetworkUI.this.initComponentData();
                FilterGeneNetworkUI.this.setVisible(true);
            }
        };
        final Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WaitCursorManager.CursorToken token = null;
                try {
                    token = WaitCursorManager.showWaitCursor();
                    FilterGeneNetworkUI.this.network = GeneNetwork.getFromCBIO(geneLoci);
                    if (FilterGeneNetworkUI.this.network.vertexSet().size() == 0) {
                        MessageUtils.showMessage("No results found for " + HttpUtils.buildURLString(geneLoci, ", "));
                    } else {
                        FilterGeneNetworkUI.this.network.annotateAll(IGV.getInstance().getAllTracks(false));
                        UIUtilities.invokeOnEventThread(showUI);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FilterGeneNetworkUI.this.log.error(e.getMessage());
                    MessageUtils.showMessage("Error loading data: " + e.getMessage());
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                    if (progressBar != null) {
                        progressBar.close();
                        indefMonitor.stop();
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    runnable.run();
                    return null;
                }
            };
            worker.execute();
        } else {
            runnable.run();
        }
    }

    private void initThresholdsMap() {
        this.thresholdsMap.put("CBIO_MUTATION_THRESHOLD", this.mutInput);
        this.thresholdsMap.put("CBIO_AMPLIFICATION_THRESHOLD", this.ampInput);
        this.thresholdsMap.put("CBIO_DELETION_THRESHOLD", this.delInput);
        this.thresholdsMap.put("CBIO_EXPRESSION_UP_THRESHOLD", this.expUpInput);
        this.thresholdsMap.put("CBIO_EXPRESSION_DOWN_THRESHOLD", this.expDownInput);
    }

    private void initComponentData() {
        this.add();
        this.initThresholdsMap();
        this.loadThresholds();
        this.listModel = new GraphListModel();
        this.geneTable.setModel(this.listModel);
        this.applySoftFilters();
    }

    private void remove(AttributeFilter row) {
        this.contentPane.remove(row.getComponent());
        this.filterRows.remove(row);
        int numRows = this.filterRows.size();
        this.filterRows.get(numRows - 1).setIsLast(true);
        this.filterRows.get(0).setShowDel(numRows >= 2);
        this.validateTree();
    }

    private void add() {
        final AttributeFilter row = new AttributeFilter();
        row.getDelRow().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterGeneNetworkUI.this.remove(row);
            }
        });
        row.getAddRow().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterGeneNetworkUI.this.add();
            }
        });
        this.contentPane.add(row.getComponent());
        if (this.filterRows.size() >= 1) {
            this.filterRows.get(this.filterRows.size() - 1).setIsLast(false);
        }
        this.filterRows.add(row);
        int numRows = this.filterRows.size();
        this.filterRows.get(numRows - 1).setIsLast(true);
        this.filterRows.get(0).setShowDel(numRows >= 2);
        this.validateTree();
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void applySoftFilters() {
        this.network.clearAllFilters();
        for (AttributeFilter filter : this.filterRows) {
            String filt_el = (String)filter.attrName.getSelectedItem();
            if (!GeneNetwork.attributeMap.containsKey(filt_el) && !"PERCENT_ALTERED".equals(filt_el)) continue;
            float min = Float.parseFloat(filter.minVal.getText());
            float max = Float.parseFloat(filter.maxVal.getText());
            this.network.filterNodesRange(filt_el, min / 100.0f, max / 100.0f);
        }
        if (!this.keepIsolated.isSelected()) {
            this.network.pruneGraph();
        }
        this.listModel.markDirty();
    }

    private void showNetwork() {
        try {
            String url = this.network.outputForcBioView();
            url = "file://" + url;
            BrowserLauncher.openURL(url);
        }
        catch (IOException err) {
            MessageUtils.showMessage("Error opening network for viewing. " + err.getMessage());
        }
    }

    private int[] getModelIndices() {
        int[] selection = this.geneTable.getSelectedRows();
        for (int i = 0; i < selection.length; ++i) {
            selection[i] = this.geneTable.convertRowIndexToModel(selection[i]);
        }
        return selection;
    }

    private void okButtonActionPerformed(ActionEvent e) {
        int[] keepRows = this.getModelIndices();
        if (keepRows.length > 0) {
            final HashSet keepNodes = new HashSet(keepRows.length);
            GraphListModel model = (GraphListModel)this.geneTable.getModel();
            List vertices = model.getVertices();
            int[] arr$ = keepRows;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer loc = arr$[i$];
                keepNodes.add(vertices.get(loc));
            }
            Predicate<Node> selectedPredicated = new Predicate<Node>(){

                @Override
                public boolean evaluate(Node object) {
                    return keepNodes.contains(object);
                }
            };
            this.network.filterNodes(selectedPredicated);
        }
        this.setVisible(false);
        this.showNetwork();
    }

    private void addRowActionPerformed(ActionEvent e) {
        this.add();
    }

    private void refFilterActionPerformed(ActionEvent e) {
        this.applySoftFilters();
        this.listModel.markDirty();
        this.validateTree();
    }

    private boolean saveThresholds() {
        try {
            for (Map.Entry<String, JTextField> entry : this.thresholdsMap.entrySet()) {
                float value = Float.parseFloat(entry.getValue().getText());
                PreferenceManager.getInstance().put(entry.getKey(), "" + value);
            }
        }
        catch (NumberFormatException e) {
            MessageUtils.showMessage("Inputs must be numeric. " + e.getMessage());
            return false;
        }
        return true;
    }

    private void loadThresholds() {
        for (Map.Entry<String, JTextField> entry : this.thresholdsMap.entrySet()) {
            String value = PreferenceManager.getInstance().get(entry.getKey());
            entry.getValue().setText(value);
        }
    }

    private void tabbedPaneStateChanged(ChangeEvent e) {
        int thresholdTabNum = this.tabbedPane.indexOfTab("Thresholds");
        if (thresholdTabNum < 0) {
            return;
        }
        Component thresholdTab = this.tabbedPane.getComponentAt(thresholdTabNum);
        if (!this.tabbedPane.getSelectedComponent().equals(thresholdTab) && !this.saveThresholds()) {
            this.tabbedPane.setSelectedComponent(thresholdTab);
        }
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.dialogPane = new JPanel();
        this.panel1 = new JPanel();
        this.addRow = new JButton();
        this.contentPane = new JPanel();
        this.buttonBar = new JPanel();
        this.keepIsolated = new JCheckBox();
        this.okButton = new JButton();
        this.refFilter = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.scrollPane1 = new JScrollPane();
        this.geneTable = new JTable();
        this.thresholds = new JPanel();
        this.contentPanel = new JPanel();
        this.label1 = new JLabel();
        this.mutInput = new JTextField();
        this.label2 = new JLabel();
        this.ampInput = new JTextField();
        this.label3 = new JLabel();
        this.delInput = new JTextField();
        this.label4 = new JLabel();
        this.expUpInput = new JTextField();
        this.label7 = new JLabel();
        this.expDownInput = new JTextField();
        this.setMinimumSize(new Dimension(600, 22));
        Container contentPane2 = this.getContentPane();
        contentPane2.setLayout(new BorderLayout());
        this.tabbedPane.setPreferredSize(new Dimension(550, 346));
        this.tabbedPane.setMinimumSize(new Dimension(550, 346));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FilterGeneNetworkUI.this.tabbedPaneStateChanged(e);
            }
        });
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setMinimumSize(new Dimension(443, 300));
        this.dialogPane.setPreferredSize(new Dimension(443, 300));
        this.dialogPane.setLayout(new GridBagLayout());
        ((GridBagLayout)this.dialogPane.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)this.dialogPane.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0};
        ((GridBagLayout)this.dialogPane.getLayout()).columnWeights = new double[]{1.0, 1.0E-4};
        ((GridBagLayout)this.dialogPane.getLayout()).rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, 1.0E-4};
        this.panel1.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panel1.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.panel1.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)this.panel1.getLayout()).columnWeights = new double[]{0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.panel1.getLayout()).rowWeights = new double[]{0.0, 1.0E-4};
        this.addRow.setText("Add Filter");
        this.addRow.setMaximumSize(new Dimension(200, 28));
        this.addRow.setMinimumSize(new Dimension(100, 28));
        this.addRow.setPreferredSize(new Dimension(150, 28));
        this.addRow.setVisible(false);
        this.addRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterGeneNetworkUI.this.addRowActionPerformed(e);
            }
        });
        this.panel1.add((Component)this.addRow, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.panel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.dialogPane.add((Component)this.contentPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0, 0.0};
        this.keepIsolated.setText("Keep Isolated Genes");
        this.keepIsolated.setVisible(false);
        this.buttonBar.add((Component)this.keepIsolated, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.okButton.setText("View Network");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterGeneNetworkUI.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.refFilter.setText("Refresh Filter");
        this.refFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterGeneNetworkUI.this.refFilterActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.refFilter, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterGeneNetworkUI.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.helpButton.setText("Help");
        this.helpButton.setVisible(false);
        this.buttonBar.add((Component)this.helpButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.geneTable.setAutoCreateRowSorter(true);
        this.scrollPane1.setViewportView(this.geneTable);
        this.dialogPane.add((Component)this.scrollPane1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.addTab("Filter", this.dialogPane);
        this.thresholds.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.thresholds.setPreferredSize(new Dimension(550, 196));
        this.thresholds.setMinimumSize(new Dimension(550, 196));
        this.thresholds.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.contentPanel.getLayout()).columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0, 1.0, 1.0, 1.0E-4};
        ((GridBagLayout)this.contentPanel.getLayout()).rowWeights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0E-4};
        this.label1.setText("Mutation:");
        this.label1.setHorizontalAlignment(4);
        this.label1.setLabelFor(this.mutInput);
        this.contentPanel.add((Component)this.label1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 5), 0, 0));
        this.mutInput.setText("1");
        this.mutInput.setAutoscrolls(false);
        this.mutInput.setMinimumSize(new Dimension(34, 28));
        this.mutInput.setPreferredSize(new Dimension(45, 28));
        this.contentPanel.add((Component)this.mutInput, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 5), 0, 0));
        this.label2.setText("Amplification:");
        this.label2.setHorizontalAlignment(4);
        this.label2.setLabelFor(this.ampInput);
        this.contentPanel.add((Component)this.label2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 5), 0, 0));
        this.ampInput.setText("0.7");
        this.ampInput.setMinimumSize(new Dimension(34, 28));
        this.ampInput.setPreferredSize(new Dimension(45, 28));
        this.contentPanel.add((Component)this.ampInput, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 5), 0, 0));
        this.label3.setText("Deletion:");
        this.label3.setHorizontalAlignment(4);
        this.label3.setLabelFor(this.delInput);
        this.contentPanel.add((Component)this.label3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 5), 0, 0));
        this.delInput.setText("0.7");
        this.delInput.setMinimumSize(new Dimension(34, 28));
        this.delInput.setPreferredSize(new Dimension(45, 28));
        this.delInput.setMaximumSize(new Dimension(50, Integer.MAX_VALUE));
        this.contentPanel.add((Component)this.delInput, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 5), 0, 0));
        this.label4.setText("Expression Up:");
        this.label4.setHorizontalAlignment(4);
        this.label4.setLabelFor(this.expUpInput);
        this.contentPanel.add((Component)this.label4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 5), 0, 0));
        this.expUpInput.setText("0.1");
        this.expUpInput.setMinimumSize(new Dimension(34, 28));
        this.expUpInput.setPreferredSize(new Dimension(35, 28));
        this.contentPanel.add((Component)this.expUpInput, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 5), 0, 0));
        this.label7.setText("Expression Down:");
        this.label7.setHorizontalAlignment(4);
        this.label7.setLabelFor(this.expDownInput);
        this.contentPanel.add((Component)this.label7, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 5), 0, 0));
        this.expDownInput.setText("0.1");
        this.expDownInput.setPreferredSize(new Dimension(45, 28));
        this.expDownInput.setMinimumSize(new Dimension(34, 28));
        this.expDownInput.setMaximumSize(new Dimension(50, Integer.MAX_VALUE));
        this.contentPanel.add((Component)this.expDownInput, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 5), 0, 0));
        this.thresholds.add((Component)this.contentPanel, "Center");
        this.tabbedPane.addTab("Thresholds", this.thresholds);
        contentPane2.add((Component)this.tabbedPane, "North");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    static {
        String[] firstLabels = new String[]{"Gene label", "Interactions"};
        columnNumToKeyMap = new HashMap<Integer, String>(GeneNetwork.attributeMap.size());
        columnNames = new ArrayList<String>(firstLabels.length + GeneNetwork.attributeMap.size());
        for (String label : firstLabels) {
            columnNames.add(label);
        }
        int ind = columnNames.size();
        for (String label : GeneNetwork.attributeMap.keySet()) {
            columnNumToKeyMap.put(ind, label);
            ++ind;
            label = label.replace('_', ' ');
            label = label.replace("PERCENT", "%");
            columnNames.add(label);
        }
    }

    private class GraphListModel
    extends AbstractTableModel {
        private List<Node> vertices = null;

        private GraphListModel() {
        }

        private List<Node> getVertices() {
            if (this.vertices == null) {
                Set<Node> nodes = FilterGeneNetworkUI.this.network.vertexSetFiltered();
                this.vertices = Arrays.asList(nodes.toArray(new Node[0]));
            }
            return this.vertices;
        }

        public void markDirty() {
            this.vertices = null;
            this.fireTableStructureChanged();
        }

        @Override
        public int getRowCount() {
            return this.getVertices().size();
        }

        @Override
        public int getColumnCount() {
            return columnNames.size();
        }

        @Override
        public String getColumnName(int col) {
            return (String)columnNames.get(col);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Node n = this.getVertices().get(rowIndex);
            String nm = GeneNetwork.getNodeKeyData(n, "label");
            switch (columnIndex) {
                case 0: {
                    return nm;
                }
                case 1: {
                    return FilterGeneNetworkUI.this.network.edgesOfFiltered(n).size();
                }
            }
            String key = (String)columnNumToKeyMap.get(columnIndex);
            if (key == null) {
                return null;
            }
            String val = GeneNetwork.getNodeKeyData(n, key);
            if ("nan".equalsIgnoreCase(val)) {
                return null;
            }
            return val;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

