/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.IGVFeature;
import org.broad.tribble.Feature;

public class FeatureUtils {
    public static Map<String, List<IGVFeature>> divideByChromosome(List<IGVFeature> features) {
        LinkedHashMap<String, List<IGVFeature>> featureMap = new LinkedHashMap<String, List<IGVFeature>>();
        for (IGVFeature f : features) {
            ArrayList<IGVFeature> flist = (ArrayList<IGVFeature>)featureMap.get(f.getChr());
            if (flist == null) {
                flist = new ArrayList<IGVFeature>();
                featureMap.put(f.getChr(), flist);
            }
            flist.add(f);
        }
        return featureMap;
    }

    public static List<List<IGVFeature>> segreateFeatures(List<IGVFeature> features, double scale) {
        ArrayList<List<IGVFeature>> segmentedLists = new ArrayList<List<IGVFeature>>();
        LinkedList<IGVFeature> workingList = new LinkedList<IGVFeature>(features);
        FeatureUtils.sortFeatureList(workingList);
        while (workingList.size() > 0) {
            LinkedList<IGVFeature> nonOverlappingFeatures = new LinkedList<IGVFeature>();
            LinkedList<IGVFeature> overlappingFeatures = new LinkedList<IGVFeature>();
            IGVFeature f1 = (IGVFeature)workingList.remove(0);
            nonOverlappingFeatures.add(f1);
            while (workingList.size() > 0) {
                int scaledEnd;
                IGVFeature f2 = (IGVFeature)workingList.remove(0);
                int scaledStart = (int)((double)f2.getStart() / scale);
                if (scaledStart > (scaledEnd = (int)((double)f1.getEnd() / scale))) {
                    nonOverlappingFeatures.add(f2);
                    f1 = f2;
                    continue;
                }
                overlappingFeatures.add(f2);
            }
            segmentedLists.add(nonOverlappingFeatures);
            workingList = overlappingFeatures;
        }
        return segmentedLists;
    }

    public static void sortFeatureList(List<? extends Feature> features) {
        Collections.sort(features, new Comparator(){

            public int compare(Object o1, Object o2) {
                Feature f1 = (Feature)o1;
                Feature f2 = (Feature)o2;
                return f1.getStart() - f2.getStart();
            }
        });
    }

    public static Feature getFeatureAt(double position, int buffer, List<? extends Feature> features) {
        int startIdx = 0;
        int endIdx = features.size();
        while (startIdx != endIdx) {
            int idx = (startIdx + endIdx) / 2;
            Feature feature = features.get(idx);
            int effectiveStart = feature.getStart();
            int effectiveEnd = feature.getEnd();
            if (position >= (double)(effectiveStart - buffer)) {
                if (position <= (double)(effectiveEnd + buffer)) {
                    return features.get(idx);
                }
                if (idx == startIdx) {
                    return null;
                }
                startIdx = idx;
                continue;
            }
            endIdx = idx;
        }
        return null;
    }

    public static Feature getFeatureAfter(double position, List<? extends Feature> features) {
        int idx;
        if (features.size() == 0 || (double)features.get(features.size() - 1).getStart() <= position) {
            return null;
        }
        int startIdx = 0;
        int endIdx = features.size();
        while (startIdx != endIdx) {
            idx = (startIdx + endIdx) / 2;
            double distance = (double)features.get(idx).getStart() - position;
            if (distance <= 0.0) {
                startIdx = idx;
            } else {
                endIdx = idx;
            }
            if (endIdx - startIdx >= 10) continue;
            break;
        }
        for (idx = startIdx; idx < features.size(); ++idx) {
            if (!((double)features.get(idx).getStart() > position)) continue;
            return features.get(idx);
        }
        return null;
    }

    public static Feature getFeatureBefore(double position, List<? extends Feature> features) {
        for (int index = FeatureUtils.getIndexBefore(position, features); index >= 0; --index) {
            Feature f = features.get(index);
            if (!((double)f.getStart() < position)) continue;
            return f;
        }
        return null;
    }

    public static Feature getFeatureClosest(double position, List<? extends Feature> features) {
        Feature f0 = FeatureUtils.getFeatureAt(position, features);
        if (f0 != null) {
            return f0;
        }
        Feature f1 = FeatureUtils.getFeatureBefore(position, features);
        Feature f2 = FeatureUtils.getFeatureAfter(position, features);
        double d1 = f1 == null ? Double.MAX_VALUE : Math.abs((double)f1.getEnd() - position);
        double d2 = f2 == null ? Double.MAX_VALUE : Math.abs((double)f2.getStart() - position);
        return d1 < d2 ? f1 : f2;
    }

    private static Feature getFeatureAt(double position, List<? extends Feature> features) {
        BasicFeature key = new BasicFeature("", (int)position, (int)position + 1);
        int r = Collections.binarySearch(features, key, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Feature f1 = (Feature)o1;
                Feature f2 = (Feature)o2;
                return f1.getStart() - f2.getStart();
            }
        });
        if (r > 0) {
            return features.get(r);
        }
        return null;
    }

    public static int getIndexBefore(double position, List<? extends Feature> features) {
        int idx;
        if (features == null || features.size() == 0) {
            return -1;
        }
        if ((double)features.get(features.size() - 1).getStart() <= position) {
            return features.size() - 1;
        }
        if ((double)features.get(0).getStart() >= position) {
            return 0;
        }
        int startIdx = 0;
        int endIdx = features.size() - 1;
        while (startIdx != endIdx) {
            idx = (startIdx + endIdx) / 2;
            double distance = (double)features.get(idx).getStart() - position;
            if (distance <= 0.0) {
                startIdx = idx;
            } else {
                endIdx = idx;
            }
            if (endIdx - startIdx >= 10) continue;
            break;
        }
        if ((double)features.get(endIdx).getStart() >= position) {
            for (idx = endIdx; idx >= 0; --idx) {
                if (!((double)features.get(idx).getStart() < position)) continue;
                return idx;
            }
        } else {
            for (idx = endIdx + 1; idx < features.size(); ++idx) {
                if (!((double)features.get(idx).getStart() >= position)) continue;
                return idx - 1;
            }
        }
        return -1;
    }

    public static List<Feature> getAllFeaturesAt(double position, double maxLength, double minWidth, List<? extends Feature> features) {
        int startIdx;
        Feature feature;
        int start;
        ArrayList<Feature> returnList = null;
        double adjustedPosition = Math.max(0.0, position - maxLength);
        for (int idx = startIdx = Math.max(0, FeatureUtils.getIndexBefore(adjustedPosition, features)); idx < features.size() && !((double)(start = (feature = features.get(idx)).getStart() - (int)(minWidth / 2.0)) > position); ++idx) {
            int end = feature.getEnd() + (int)(minWidth / 2.0);
            if (!(position >= (double)start) || !(position <= (double)end)) continue;
            if (returnList == null) {
                returnList = new ArrayList<Feature>();
            }
            returnList.add(feature);
        }
        return returnList;
    }
}

