/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.DynamicIndexCreator;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.interval.IntervalIndexCreator;
import org.broad.tribble.index.interval.IntervalTreeIndex;
import org.broad.tribble.index.linear.LinearIndex;
import org.broad.tribble.index.linear.LinearIndexCreator;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.BufferedLineReader;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.ParsingUtils;

public class IndexFactory {
    private static Logger log = Logger.getLogger(IndexFactory.class);

    public static Index loadIndex(String indexFile) {
        Index idx = null;
        InputStream is = null;
        FilterInputStream dis = null;
        try {
            is = indexFile.endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(ParsingUtils.openInputStream(indexFile)), 512000) : new BufferedInputStream(ParsingUtils.openInputStream(indexFile), 512000);
            dis = new LittleEndianInputStream(is);
            int magicNumber = ((LittleEndianInputStream)dis).readInt();
            int type = ((LittleEndianInputStream)dis).readInt();
            Class indexClass = IndexType.getIndexType(type).getIndexType();
            idx = (Index)indexClass.newInstance();
            idx.read((LittleEndianInputStream)dis);
        }
        catch (IOException ex) {
            throw new TribbleException.UnableToReadIndexFile("Unable to read index file", indexFile, ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error closing indexFile: " + indexFile), (Throwable)e);
            }
        }
        return idx;
    }

    public static Index createLinearIndex(File inputFile, FeatureCodec codec) {
        return IndexFactory.createLinearIndex(inputFile, codec, LinearIndexCreator.DEFAULT_BIN_WIDTH);
    }

    public static Index createLinearIndex(File inputFile, FeatureCodec codec, int binSize) {
        LinearIndexCreator idx = new LinearIndexCreator();
        idx.initialize(inputFile, binSize);
        return IndexFactory.createIndex(new FeatureIterator(inputFile, codec), idx);
    }

    public static Index createIntervalIndex(File inputFile, FeatureCodec codec) {
        return IndexFactory.createIntervalIndex(inputFile, codec, IntervalIndexCreator.DEFAULT_FEATURE_COUNT);
    }

    public static Index createIntervalIndex(File inputFile, FeatureCodec codec, int binSize) {
        IntervalIndexCreator idx = new IntervalIndexCreator();
        idx.initialize(inputFile, binSize);
        return IndexFactory.createIndex(new FeatureIterator(inputFile, codec), idx);
    }

    public static Index createDynamicIndex(File inputFile, FeatureCodec codec) {
        return IndexFactory.createDynamicIndex(inputFile, codec, IndexBalanceApproach.FOR_SEEK_TIME);
    }

    public static Index createDynamicIndex(File inputFile, FeatureCodec codec, IndexBalanceApproach iba) {
        DynamicIndexCreator indexCreator = new DynamicIndexCreator(iba);
        indexCreator.initialize(inputFile, indexCreator.defaultBinSize());
        return IndexFactory.createIndex(new FeatureIterator(inputFile, codec), indexCreator);
    }

    private static Index createIndex(FeatureIterator iterator, IndexCreator creator) {
        while (iterator.hasNext()) {
            long position = iterator.getPosition();
            creator.addFeature(iterator.next(), position);
        }
        return creator.finalizeIndex(iterator.getPosition());
    }

    static class FeatureIterator
    implements Iterator<Feature> {
        private AsciiLineReader reader;
        private Feature nextFeature;
        private final FeatureCodec codec;
        private final File inputFile;
        private long cachedPosition;

        public FeatureIterator(File inputFile, FeatureCodec codec) {
            this.codec = codec;
            this.inputFile = inputFile;
            this.readHeader();
            this.reader = this.initReader(inputFile);
            this.readNextFeature();
        }

        private void readHeader() {
            BufferedLineReader br = null;
            try {
                br = new BufferedLineReader(new FileReader(this.inputFile));
                this.codec.readHeader(br);
            }
            catch (IOException e) {
                log.error((Object)"Error reading header", (Throwable)e);
                throw new TribbleException.InvalidHeader("Error reading header " + e.getMessage());
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }

        private AsciiLineReader initReader(File inputFile) {
            FileInputStream is;
            try {
                is = new FileInputStream(inputFile);
            }
            catch (FileNotFoundException e) {
                throw new TribbleException.FeatureFileDoesntExist("Unable to open the input file, most likely the file doesn't exist.", inputFile.getAbsolutePath());
            }
            this.reader = new AsciiLineReader(is);
            return this.reader;
        }

        @Override
        public boolean hasNext() {
            return this.nextFeature != null;
        }

        @Override
        public Feature next() {
            Feature ret = this.nextFeature;
            this.readNextFeature();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("We cannot remove");
        }

        public long getPosition() {
            return this.hasNext() ? this.cachedPosition : this.reader.getPosition();
        }

        private void readNextFeature() {
            this.cachedPosition = this.reader.getPosition();
            try {
                String nextLine = null;
                do {
                    this.nextFeature = (nextLine = this.reader.readLine()) != null ? this.codec.decode(nextLine) : null;
                } while (this.nextFeature == null && nextLine != null);
            }
            catch (IOException e) {
                throw new TribbleException.MalformedFeatureFile("Unable to read a line from the file", this.inputFile.getAbsolutePath(), e);
            }
        }
    }

    public static enum IndexType {
        LINEAR(1, new LinearIndexCreator(), LinearIndex.class),
        INTERVAL_TREE(2, new IntervalIndexCreator(), IntervalTreeIndex.class);

        private final int indexValue;
        private final IndexCreator indexCreator;
        private final Class indexType;

        private IndexType(int headerValue, IndexCreator creator, Class indexClass) {
            this.indexValue = headerValue;
            this.indexCreator = creator;
            this.indexType = indexClass;
        }

        public int getHeaderValue() {
            return this.indexValue;
        }

        public Class getIndexType() {
            return this.indexType;
        }

        public static IndexType getIndexType(int headerValue) {
            for (IndexType type : IndexType.values()) {
                if (type.indexValue != headerValue) continue;
                return type;
            }
            throw new TribbleException.UnableToCreateCorrectIndexType("Unknown index type value" + headerValue);
        }
    }

    public static enum IndexBalanceApproach {
        FOR_SIZE,
        FOR_SEEK_TIME;

    }
}

