/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import org.broad.igv.hic.tools.AlignmentPair;
import org.broad.igv.hic.tools.PairIterator;
import org.broad.tribble.util.LittleEndianInputStream;

public class BinPairIterator
implements PairIterator {
    LittleEndianInputStream is;
    AlignmentPair next;

    public BinPairIterator(String path) throws IOException {
        this.is = new LittleEndianInputStream(new BufferedInputStream(new FileInputStream(path)));
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public AlignmentPair next() {
        AlignmentPair retValue = this.next;
        this.advance();
        return retValue;
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void advance() {
        block2: {
            try {
                int chr1 = this.is.readInt();
                int pos1 = this.is.readInt();
                int chr2 = this.is.readInt();
                int pos2 = this.is.readInt();
                this.next = new AlignmentPair(chr1, pos1, chr2, pos2);
            }
            catch (IOException e) {
                this.next = null;
                if (e instanceof EOFException) break block2;
                e.printStackTrace();
            }
        }
    }
}

