/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import java.util.EnumMap;
import org.broad.tribble.TribbleException;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.variantcontext.Genotype;

public class GenotypeLikelihoods {
    public static final boolean CAP_PLS = false;
    public static final int PL_CAP = 255;
    private double[] log10Likelihoods = null;
    private String likelihoodsAsString_PLs = null;

    public static final GenotypeLikelihoods fromPLField(String PLs) {
        return new GenotypeLikelihoods(PLs);
    }

    public static final GenotypeLikelihoods fromGLField(String GLs) {
        return new GenotypeLikelihoods(GenotypeLikelihoods.parseDeprecatedGLString(GLs));
    }

    public static final GenotypeLikelihoods fromLog10Likelihoods(double[] log10Likelihoods) {
        return new GenotypeLikelihoods(log10Likelihoods);
    }

    protected GenotypeLikelihoods(String asString) {
        this.likelihoodsAsString_PLs = asString;
    }

    protected GenotypeLikelihoods(double[] asVector) {
        this.log10Likelihoods = asVector;
    }

    public double[] getAsVector() {
        if (this.log10Likelihoods == null) {
            this.log10Likelihoods = GenotypeLikelihoods.parsePLsIntoLikelihoods(this.likelihoodsAsString_PLs);
        }
        return this.log10Likelihoods;
    }

    public String toString() {
        return this.getAsString();
    }

    public String getAsString() {
        if (this.likelihoodsAsString_PLs == null) {
            if (this.log10Likelihoods == null) {
                throw new TribbleException("BUG: Attempted to get likelihoods as strings and neither the vector nor the string is set!");
            }
            this.likelihoodsAsString_PLs = GenotypeLikelihoods.convertLikelihoodsToPLString(this.log10Likelihoods);
        }
        return this.likelihoodsAsString_PLs;
    }

    public EnumMap<Genotype.Type, Double> getAsMap(boolean normalizeFromLog10) {
        double[] likelihoods;
        double[] dArray = likelihoods = normalizeFromLog10 ? MathUtils.normalizeFromLog10((double[])this.getAsVector()) : this.getAsVector();
        if (likelihoods == null) {
            return null;
        }
        EnumMap<Genotype.Type, Double> likelihoodsMap = new EnumMap<Genotype.Type, Double>(Genotype.Type.class);
        likelihoodsMap.put(Genotype.Type.HOM_REF, likelihoods[Genotype.Type.HOM_REF.ordinal() - 1]);
        likelihoodsMap.put(Genotype.Type.HET, likelihoods[Genotype.Type.HET.ordinal() - 1]);
        likelihoodsMap.put(Genotype.Type.HOM_VAR, likelihoods[Genotype.Type.HOM_VAR.ordinal() - 1]);
        return likelihoodsMap;
    }

    public double getLog10GQ(Genotype.Type genotype) {
        return GenotypeLikelihoods.getQualFromLikelihoods(genotype.ordinal() - 1, this.getAsVector());
    }

    public static double getQualFromLikelihoods(int iOfChoosenGenotype, double[] likelihoods) {
        if (likelihoods == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double qual = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < likelihoods.length; ++i) {
            if (i == iOfChoosenGenotype || !(likelihoods[i] >= qual)) continue;
            qual = likelihoods[i];
        }
        if ((qual = likelihoods[iOfChoosenGenotype] - qual) < 0.0) {
            double[] normalized = MathUtils.normalizeFromLog10((double[])likelihoods);
            double chosenGenotype = normalized[iOfChoosenGenotype];
            return Math.log10(1.0 - chosenGenotype);
        }
        return -1.0 * qual;
    }

    private static final double[] parsePLsIntoLikelihoods(String likelihoodsAsString_PLs) {
        if (!likelihoodsAsString_PLs.equals(".")) {
            String[] strings = likelihoodsAsString_PLs.split(",");
            double[] likelihoodsAsVector = new double[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                likelihoodsAsVector[i] = (double)Integer.parseInt(strings[i]) / -10.0;
            }
            return likelihoodsAsVector;
        }
        return null;
    }

    private static final double[] parseDeprecatedGLString(String GLString) {
        if (!GLString.equals(".")) {
            String[] strings = GLString.split(",");
            double[] likelihoodsAsVector = new double[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                likelihoodsAsVector[i] = Double.parseDouble(strings[i]);
            }
            return likelihoodsAsVector;
        }
        return null;
    }

    private static final String convertLikelihoodsToPLString(double[] GLs) {
        if (GLs == null) {
            return ".";
        }
        StringBuilder s = new StringBuilder();
        double adjust = Double.NEGATIVE_INFINITY;
        for (double l : GLs) {
            adjust = Math.max(adjust, l);
        }
        boolean first = true;
        for (double l : GLs) {
            if (!first) {
                s.append(",");
            } else {
                first = false;
            }
            long PL = Math.round(-10.0 * (l - adjust));
            s.append(Long.toString(PL));
        }
        return s.toString();
    }
}

