/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.data.BasicScore;
import org.broad.igv.data.CompositeScore;
import org.broad.igv.data.CoverageDataSource;
import org.broad.igv.data.NamedScore;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tdf.Accumulator;
import org.broad.igv.tdf.TDFDataset;
import org.broad.igv.tdf.TDFGroup;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.util.LRUCache;

public class TDFDataSource
implements CoverageDataSource {
    private static Logger log = Logger.getLogger(TDFDataSource.class);
    int maxPrecomputedZoom = 6;
    TDFReader reader;
    private int trackNumber = 0;
    String trackName;
    LRUCache<String, List<LocusScore>> summaryScoreCache = new LRUCache(this, 20);
    Genome genome;
    Interval currentInterval;
    WindowFunction windowFunction = WindowFunction.mean;
    List<WindowFunction> availableFunctions;
    private boolean aggregateLikeBins = true;
    boolean normalizeCounts = false;
    int totalCount = 0;
    float normalizationFactor = 1.0f;
    private Map<String, String> chrNameMap = new HashMap<String, String>();

    public TDFDataSource(TDFReader reader, int trackNumber, String trackName, Genome genome) {
        this.genome = genome;
        this.trackNumber = trackNumber;
        this.trackName = trackName;
        this.reader = reader;
        this.availableFunctions = reader.getWindowFunctions();
        TDFGroup rootGroup = reader.getGroup("/");
        try {
            this.maxPrecomputedZoom = Integer.parseInt(rootGroup.getAttribute("maxZoom"));
        }
        catch (Exception e) {
            log.error("Error reading attribute 'maxZoom'", e);
        }
        try {
            String dataGenome = rootGroup.getAttribute("genome");
        }
        catch (Exception e) {
            log.error("Unknown genome " + rootGroup.getAttribute("genome"));
            throw new RuntimeException("Unknown genome " + rootGroup.getAttribute("genome"));
        }
        try {
            String totalCountString = rootGroup.getAttribute("totalCount");
            if (totalCountString != null) {
                this.totalCount = Integer.parseInt(totalCountString);
            }
        }
        catch (Exception e) {
            log.error("Error reading attribute 'totalCount'", e);
        }
        if (genome != null) {
            Set<String> chrNames = reader.getChromosomeNames();
            for (String chr : chrNames) {
                String igvChr = genome.getChromosomeAlias(chr);
                if (igvChr == null || igvChr.equals(chr)) continue;
                this.chrNameMap.put(igvChr, chr);
            }
        }
        boolean normalizeCounts = PreferenceManager.getInstance().getAsBoolean("NORMALIZE_COVERAGE");
        this.setNormalize(normalizeCounts);
    }

    @Override
    public void setNormalize(boolean normalizeCounts) {
        this.setNormalizeCounts(normalizeCounts, 1000000.0f);
    }

    public void setNormalizeCounts(boolean normalizeCounts, float scalingFactor) {
        this.normalizeCounts = normalizeCounts;
        this.normalizationFactor = normalizeCounts && this.totalCount > 0 ? scalingFactor / (float)this.totalCount : 1.0f;
    }

    @Override
    public String getPath() {
        return this.reader == null ? null : this.reader.getPath();
    }

    public String getTrackName() {
        return this.trackName;
    }

    @Override
    public double getDataMax() {
        return this.reader.getUpperLimit() * (double)this.normalizationFactor;
    }

    @Override
    public double getDataMin() {
        return this.reader.getLowerLimit() * (double)this.normalizationFactor;
    }

    public void setAggregateLikeBins(boolean aggregateLikeBins) {
        this.aggregateLikeBins = aggregateLikeBins;
    }

    private List<LocusScore> getCachedSummaryScores(String querySeq, int zoom, int tileNumber, double tileWidth) {
        String key = querySeq + "_" + zoom + "_" + tileNumber + "_" + (Object)((Object)this.windowFunction);
        List<LocusScore> scores = this.summaryScoreCache.get(key);
        if (scores == null) {
            int startLocation = (int)((double)tileNumber * tileWidth);
            int endLocation = (int)((double)(tileNumber + 1) * tileWidth);
            scores = this.getSummaryScores(querySeq, startLocation, endLocation, zoom);
            this.summaryScoreCache.put(key, scores);
        }
        return scores;
    }

    protected List<LocusScore> getSummaryScores(String querySeq, int startLocation, int endLocation, int zoom) {
        List<LocusScore> scores;
        if (zoom <= this.maxPrecomputedZoom) {
            List<TDFTile> tiles;
            WindowFunction wf = this.windowFunction == WindowFunction.none ? WindowFunction.mean : this.windowFunction;
            scores = new ArrayList<LocusScore>(1000);
            TDFDataset ds = this.reader.getDataset(querySeq, zoom, wf);
            if (ds != null && (tiles = ds.getTiles(startLocation, endLocation)).size() > 0) {
                for (TDFTile tile : tiles) {
                    if (tile.getSize() <= 0) continue;
                    for (int i = 0; i < tile.getSize(); ++i) {
                        float v = tile.getValue(this.trackNumber, i);
                        if (Float.isNaN(v)) continue;
                        scores.add(new BasicScore(tile.getStartPosition(i), tile.getEndPosition(i), v *= this.normalizationFactor));
                    }
                }
            }
        } else {
            int chrLength = this.getChrLength(querySeq);
            if (chrLength == 0) {
                return Collections.emptyList();
            }
            endLocation = Math.min(endLocation, chrLength);
            int nTiles = (int)Math.pow(2.0, zoom);
            double binSize = Math.max(1.0, (double)chrLength / (double)nTiles / 700.0);
            scores = this.computeSummaryScores(querySeq, startLocation, endLocation, binSize);
        }
        return scores;
    }

    public int getChrLength(String chr) {
        if (chr.equals("All")) {
            return (int)(this.genome.getLength() / 1000L);
        }
        Chromosome c = this.genome.getChromosome(chr);
        return c == null ? 0 : c.getLength();
    }

    private List<LocusScore> computeSummaryScores(String chr, int startLocation, int endLocation, double scale) {
        ArrayList<LocusScore> scores;
        block11: {
            List<TDFTile> rawTiles;
            scores = new ArrayList<LocusScore>(1000);
            String dsName = "/" + chr + "/raw";
            TDFDataset rawDataset = this.reader.getDataset(dsName);
            if (rawDataset == null || (rawTiles = rawDataset.getTiles(startLocation, endLocation)).size() <= 0) break block11;
            if (this.windowFunction == WindowFunction.none) {
                block0: for (TDFTile rawTile : rawTiles) {
                    if (rawTile == null || rawTile.getSize() <= 0) continue;
                    for (int i = 0; i < rawTile.getSize(); ++i) {
                        int s = rawTile.getStartPosition(i);
                        int e = Math.max(s, rawTile.getEndPosition(i) - 1);
                        if (e < startLocation) continue;
                        if (s > endLocation) continue block0;
                        float v = rawTile.getValue(this.trackNumber, i);
                        if (!Float.isNaN(v)) {
                            v *= this.normalizationFactor;
                        }
                        scores.add(new BasicScore(s, e, v));
                    }
                }
            } else {
                Accumulator accumulator = new Accumulator(this.windowFunction, 5);
                int accumulatedStart = -1;
                int accumulatedEnd = -1;
                int lastEndBin = 0;
                for (TDFTile rawTile : rawTiles) {
                    int size = rawTile.getSize();
                    if (rawTile == null || size <= 0) continue;
                    int[] starts = rawTile.getStart();
                    int[] ends = rawTile.getEnd();
                    String[] features = rawTile.getNames();
                    float[] values = rawTile.getData(this.trackNumber);
                    for (int i = 0; i < size && starts[i] < endLocation; ++i) {
                        int s = Math.max(startLocation, starts[i]);
                        int e = ends == null ? s + 1 : Math.min(endLocation, ends[i]);
                        float v = values[i] * this.normalizationFactor;
                        if (e < startLocation || Float.isNaN(v)) continue;
                        String probeName = features == null ? null : features[i];
                        int endBin = (int)((double)(e - startLocation) / scale);
                        int startBin = (int)((double)(s - startLocation) / scale);
                        if ((endBin > lastEndBin || endBin > startBin) && accumulator.hasData()) {
                            scores.add(this.getCompositeScore(accumulator, accumulatedStart, accumulatedEnd));
                            accumulator = new Accumulator(this.windowFunction, 5);
                        }
                        if (endBin > startBin) {
                            scores.add(new NamedScore(s, e, v, probeName));
                        } else {
                            if (!accumulator.hasData()) {
                                accumulatedStart = s;
                            }
                            accumulatedEnd = e;
                            accumulator.add(e - s, v, probeName);
                        }
                        lastEndBin = endBin;
                    }
                    if (!accumulator.hasData()) continue;
                    scores.add(this.getCompositeScore(accumulator, accumulatedStart, accumulatedEnd));
                }
            }
        }
        return scores;
    }

    private LocusScore getCompositeScore(Accumulator accumulator, int accumulatedStart, int accumulatedEnd) {
        LocusScore ls;
        if (accumulator.getNpts() == 1) {
            ls = new NamedScore(accumulatedStart, accumulatedEnd, accumulator.getData()[0], accumulator.getNames()[0]);
        } else {
            float value = accumulator.getValue();
            ls = new CompositeScore(accumulatedStart, accumulatedEnd, value, accumulator.getData(), accumulator.getNames(), this.windowFunction);
        }
        return ls;
    }

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        String querySeq;
        Chromosome chromosome = this.genome.getChromosome(chr);
        String tmp = this.chrNameMap.get(chr);
        String string = querySeq = tmp == null ? chr : tmp;
        if (Globals.isHeadless() || FrameManager.isGeneListMode()) {
            return this.getSummaryScores(querySeq, startLocation, endLocation, zoom);
        }
        ArrayList<LocusScore> scores = new ArrayList<LocusScore>();
        double tileWidth = 0.0;
        if (chr.equals("All")) {
            tileWidth = (double)this.genome.getLength() / 1000.0;
        } else if (chromosome != null) {
            tileWidth = chromosome.getLength() / (int)Math.pow(2.0, zoom);
        }
        if (tileWidth == 0.0) {
            return null;
        }
        int startTile = (int)((double)startLocation / tileWidth);
        int endTile = (int)((double)endLocation / tileWidth);
        block0: for (int t = startTile; t <= endTile; ++t) {
            List<LocusScore> cachedScores = this.getCachedSummaryScores(querySeq, zoom, t, tileWidth);
            if (cachedScores == null) continue;
            for (LocusScore s : cachedScores) {
                if (s.getEnd() >= startLocation) {
                    scores.add(s);
                    continue;
                }
                if (s.getStart() <= endLocation) continue;
                continue block0;
            }
        }
        return scores;
    }

    @Override
    public TrackType getTrackType() {
        return this.reader.getTrackType();
    }

    @Override
    public void setWindowFunction(WindowFunction wf) {
        this.windowFunction = wf;
    }

    @Override
    public boolean isLogNormalized() {
        return this.getDataMin() < 0.0;
    }

    public void refreshData(long timestamp) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.windowFunction;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.availableFunctions;
    }

    class Interval {
        String chr;
        private int start;
        private int end;
        private int zoom;
        private List<LocusScore> scores;

        public Interval(String chr, int start, int end, int zoom, List<LocusScore> scores) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.zoom = zoom;
            this.scores = scores;
        }

        public boolean contains(String chr, int s, int e, int zoom) {
            return chr.equals(this.chr) && zoom == this.zoom && s >= this.getStart() && e <= this.getEnd();
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public List<LocusScore> getScores() {
            return this.scores;
        }
    }
}

