/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.lists;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.broad.igv.feature.Locus;

public class GeneList {
    private String group;
    private boolean editable = true;
    private String name;
    private String description;
    private List<String> loci;
    private boolean showName = true;
    private static Comparator<String> POSITION_COMPARATOR;

    public GeneList(String name, String description, String group, List<String> loci) {
        this.group = group;
        this.description = description;
        this.name = name;
        this.loci = loci;
    }

    public GeneList(String name, List<String> loci) {
        this(name, null, "My lists", loci);
    }

    public GeneList(String name, List<String> loci, boolean showName) {
        this(name, null, "My lists", loci);
        this.showName = showName;
    }

    public GeneList() {
        this.group = "My lists";
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.showName ? this.name : "";
    }

    public List<String> getLoci() {
        return this.loci;
    }

    public int size() {
        return this.loci == null ? 0 : this.loci.size();
    }

    public void add(String gene) {
        if (this.loci == null) {
            this.loci = new ArrayList<String>(1);
        }
        try {
            this.loci.add(gene);
        }
        catch (Exception e) {
            this.loci = new ArrayList<String>(this.loci);
            this.loci.add(gene);
        }
    }

    public GeneList copy() {
        return new GeneList(this.name + " copy", this.loci);
    }

    public void setLoci(List<String> strings) {
        this.loci = strings;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getGroup() {
        return this.group;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static void sortByPosition(List<String> loci) {
        if (POSITION_COMPARATOR == null) {
            GeneList.initComparator();
        }
        Collections.sort(loci, POSITION_COMPARATOR);
    }

    private static synchronized void initComparator() {
        POSITION_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                Locus l1 = new Locus(s1);
                Locus l2 = new Locus(s2);
                if (!l1.isValid() && !l2.isValid()) {
                    return 0;
                }
                if (!l1.isValid()) {
                    return -1;
                }
                if (!l2.isValid()) {
                    return 1;
                }
                if (!l1.getChr().equals(l2.getChr())) {
                    return l1.getChr().compareTo(l2.getChr());
                }
                return l1.getStart() - l2.getStart();
            }
        };
    }
}

