/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.hic.data.Chromosome;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;

public class DensityCalculation {
    private int gridSize;
    private int numberOfBins;
    private double[] actualDistances;
    private double[] possibleDistances;
    private double[] densityAvg;
    private List<Chromosome> chromosomes;
    private Map<Integer, Integer> chromosomeCounts;
    private LinkedHashMap<Integer, Double> normalizationFactors;

    DensityCalculation(List<Chromosome> chromosomes, int gridSize) {
        this.gridSize = gridSize;
        this.chromosomes = chromosomes;
        long totalLen = 0L;
        for (Chromosome chromosome : chromosomes) {
            if (chromosome == null) continue;
            totalLen += (long)chromosome.getSize();
        }
        this.numberOfBins = (int)(totalLen / (long)gridSize) + 1;
        this.actualDistances = new double[this.numberOfBins];
        Arrays.fill(this.actualDistances, 0.0);
        this.chromosomeCounts = new HashMap<Integer, Integer>();
        this.normalizationFactors = new LinkedHashMap();
    }

    public DensityCalculation(LittleEndianInputStream les) {
        try {
            this.read(les);
        }
        catch (IOException e) {
            System.err.println("Error reading density file");
            e.printStackTrace();
        }
    }

    public void addDistance(Integer chr, int dist) {
        int bin;
        Integer count = this.chromosomeCounts.get(chr);
        if (count == null) {
            this.chromosomeCounts.put(chr, 1);
        } else {
            this.chromosomeCounts.put(chr, count + 1);
        }
        int n = bin = dist / this.gridSize;
        this.actualDistances[n] = this.actualDistances[n] + 1.0;
    }

    public void computeDensity() {
        int k;
        double sum;
        int kMax;
        int kMin;
        int i;
        this.possibleDistances = new double[this.numberOfBins];
        for (Chromosome chr : this.chromosomes) {
            if (chr == null) continue;
            int nChrBins = chr.getSize() / this.gridSize;
            for (i = 0; i < nChrBins; ++i) {
                int n = i;
                this.possibleDistances[n] = this.possibleDistances[n] + (double)(nChrBins - i);
            }
        }
        double[] density = new double[this.numberOfBins];
        this.densityAvg = new double[this.numberOfBins];
        for (int i2 = 0; i2 < this.numberOfBins; ++i2) {
            density[i2] = this.actualDistances[i2] / this.possibleDistances[i2];
            this.densityAvg[i2] = density[i2];
        }
        int smoothingWidow1 = 15000000;
        int start = 15000000 / this.gridSize;
        int window = (int)(5.0f * (2000000.0f / (float)this.gridSize));
        if (window == 0) {
            window = 1;
        }
        for (i = start; i < this.numberOfBins; ++i) {
            kMin = i - window;
            kMax = Math.min(i + window, this.numberOfBins);
            sum = 0.0;
            for (k = kMin; k < kMax; ++k) {
                sum += density[k];
            }
            this.densityAvg[i] = sum / (double)(kMax - kMin);
        }
        start = 70000000 / this.gridSize;
        window = (int)(20.0f * (2000000.0f / (float)this.gridSize));
        for (i = start; i < this.numberOfBins; ++i) {
            kMin = i - window;
            kMax = Math.min(i + window, this.numberOfBins);
            sum = 0.0;
            for (k = kMin; k < kMax; ++k) {
                sum += density[k];
            }
            this.densityAvg[i] = sum / (double)(kMax - kMin);
        }
        for (i = start = 170000000 / this.gridSize; i < this.numberOfBins; ++i) {
            this.densityAvg[i] = this.densityAvg[start];
        }
        for (Chromosome chr : this.chromosomes) {
            if (chr == null || !this.chromosomeCounts.containsKey(chr.getIndex())) continue;
            int len = chr.getSize();
            int nGrids = len / this.gridSize + 1;
            double expectedCount = 0.0;
            for (int n = 0; n < nGrids; ++n) {
                double v = this.densityAvg[n];
                if (Double.isNaN(v)) {
                    System.err.println("Density was NaN, this shouldn't happen.");
                    continue;
                }
                expectedCount += (double)(nGrids - n) * v;
            }
            double observedCount = this.chromosomeCounts.get(chr.getIndex()).intValue();
            double f = expectedCount / observedCount;
            this.normalizationFactors.put(chr.getIndex(), f);
        }
    }

    private void printDensities(int chrIndex) {
        double norm = this.normalizationFactors.get(chrIndex);
        long center = this.gridSize / 2;
        System.out.println(this.gridSize);
        for (int i = 0; i < this.numberOfBins; ++i) {
            System.out.println((float)center / 1000000.0f + "M " + this.actualDistances[i] + "\t" + this.possibleDistances[i] + "\t" + this.densityAvg[i] + "\t" + norm + "\t" + this.densityAvg[i] / norm);
            center += (long)this.gridSize;
        }
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public LinkedHashMap<Integer, Double> getNormalizationFactors() {
        return this.normalizationFactors;
    }

    public double[] getDensityAvg() {
        return this.densityAvg;
    }

    public void outputBinary(LittleEndianOutputStream os) throws IOException {
        os.writeInt(this.gridSize);
        int nonNullChrCount = 0;
        for (Chromosome chr : this.chromosomes) {
            if (chr == null) continue;
            ++nonNullChrCount;
        }
        os.writeInt(nonNullChrCount);
        for (Chromosome chr : this.chromosomes) {
            if (chr == null) continue;
            os.writeInt(chr.getIndex());
        }
        for (Chromosome chr : this.chromosomes) {
            if (chr == null) continue;
            Integer idx = chr.getIndex();
            Double normFactor = this.normalizationFactors.get(idx);
            os.writeInt(idx);
            os.writeDouble(normFactor == null ? 0.0 : normFactor);
        }
        os.writeInt(this.densityAvg.length);
        for (double aDensityAvg : this.densityAvg) {
            os.writeDouble(aDensityAvg);
        }
    }

    public void read(LittleEndianInputStream is) throws IOException {
        int i;
        this.gridSize = is.readInt();
        int nChromosomes = is.readInt();
        Integer[] chrIndexes = new Integer[nChromosomes];
        for (i = 0; i < nChromosomes; ++i) {
            chrIndexes[i] = is.readInt();
        }
        this.normalizationFactors = new LinkedHashMap(nChromosomes);
        for (i = 0; i < nChromosomes; ++i) {
            Integer chrIdx = is.readInt();
            double normFactor = is.readDouble();
            this.normalizationFactors.put(chrIdx, normFactor);
        }
        int nDensities = is.readInt();
        this.densityAvg = new double[nDensities];
        for (int i2 = 0; i2 < nDensities; ++i2) {
            this.densityAvg[i2] = is.readDouble();
        }
    }
}

