/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ClickTaskScheduler;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.TrackPanel;

public abstract class TrackPanelComponent
extends JPanel {
    private static Logger log = Logger.getLogger(TrackPanelComponent.class);
    List<MouseableRegion> mouseRegions;
    private TrackPanel trackPanel;
    protected ClickTaskScheduler clickScheduler = new ClickTaskScheduler();
    int searchIdx = 0;

    public TrackPanelComponent(TrackPanel trackPanel) {
        this.trackPanel = trackPanel;
        this.setFocusable(true);
        this.mouseRegions = new ArrayList<MouseableRegion>();
    }

    public TrackPanel getTrackPanel() {
        if (this.trackPanel == null) {
            this.trackPanel = (TrackPanel)this.getParent();
        }
        return this.trackPanel;
    }

    public String getTrackSetID() {
        return this.getTrackPanel().getName();
    }

    protected void addMousableRegion(MouseableRegion region) {
        this.mouseRegions.add(region);
    }

    protected void removeMousableRegions() {
        this.mouseRegions.clear();
    }

    protected List<MouseableRegion> getMouseRegions() {
        return this.mouseRegions;
    }

    public boolean scrollTo(String trackName) {
        Track t = this.findNextTrackMatching(trackName);
        if (t != null) {
            IGV.getInstance().clearSelections();
            t.setSelected(true);
            if (this.trackPanel.getScrollPane().getVerticalScrollBar().isShowing()) {
                this.trackPanel.getScrollPane().getVerticalScrollBar().setValue(t.getY());
            }
            return true;
        }
        return false;
    }

    private synchronized Track findNextTrackMatching(String trackName) {
        Track t;
        int i;
        List<Track> tracks = this.getAllTracks();
        for (i = this.searchIdx = Math.min(this.searchIdx, tracks.size()); i < tracks.size(); ++i) {
            t = tracks.get(i);
            if (!t.getName().toUpperCase().contains(trackName.toUpperCase())) continue;
            this.searchIdx = i + 1;
            return t;
        }
        for (i = 0; i < this.searchIdx; ++i) {
            t = tracks.get(i);
            if (!t.getName().toUpperCase().contains(trackName.toUpperCase())) continue;
            this.searchIdx = i + 1;
            return t;
        }
        return null;
    }

    public String getPopupMenuTitle(int x, int y) {
        Collection<Track> tracks = this.getSelectedTracks();
        String popupTitle = tracks.size() == 1 ? tracks.iterator().next().getName() : "Total Tracks Selected: " + tracks.size();
        return popupTitle;
    }

    protected Collection<Track> getSelectedTracks() {
        return IGV.getInstance().getSelectedTracks();
    }

    public List<Track> getAllTracks() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getTracks();
    }

    protected void openPopupMenu(TrackClickEvent te) {
        this.openPopupMenu(te, null);
    }

    protected void openPopupMenu(TrackClickEvent te, List<Component> extraItems) {
        MouseEvent e = te.getMouseEvent();
        Collection<Track> selectedTracks = this.getSelectedTracks();
        if (selectedTracks.size() == 0) {
            return;
        }
        JPopupMenu menu = null;
        if (selectedTracks.size() == 1) {
            Track track = selectedTracks.iterator().next();
            menu = track.getPopupMenu(te);
        }
        if (menu == null) {
            String title = this.getPopupMenuTitle(e.getX(), e.getY());
            menu = TrackMenuUtils.getPopupMenu(selectedTracks, title, te);
        }
        if (extraItems != null) {
            menu.addSeparator();
            for (Component item : extraItems) {
                menu.add(item);
            }
        }
        menu.addSeparator();
        JMenuItem item = new JMenuItem("Save image...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackPanelComponent.this.saveImage();
            }
        });
        menu.add(item);
        if (menu != null) {
            menu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    TrackPanelComponent.this.clearTrackSelections();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    TrackPanelComponent.this.clearTrackSelections();
                }
            });
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected void toggleTrackSelections(MouseEvent e) {
        for (MouseableRegion mouseRegion : this.mouseRegions) {
            if (!mouseRegion.containsPoint(e.getX(), e.getY())) continue;
            IGV.getInstance().toggleTrackSelections(mouseRegion.getTracks());
            return;
        }
    }

    protected void clearTrackSelections() {
        IGV.getInstance().clearSelections();
        IGV.getMainFrame().repaint();
    }

    protected void selectTracks(MouseEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("Enter selectTracks");
        }
        for (MouseableRegion mouseRegion : this.mouseRegions) {
            if (!mouseRegion.containsPoint(e.getX(), e.getY())) continue;
            IGV.getInstance().setTrackSelections(mouseRegion.getTracks());
            return;
        }
    }

    protected boolean isTrackSelected(MouseEvent e) {
        for (MouseableRegion mouseRegion : this.mouseRegions) {
            if (!mouseRegion.containsPoint(e.getX(), e.getY())) continue;
            for (Track t : mouseRegion.getTracks()) {
                if (!t.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public void saveImage() {
        IGV.getInstance().saveImage(this.getTrackPanel().getScrollPane(), "igv_panel");
    }
}

