/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.util.ParsingUtils;

public class IGVPreferences {
    private static Logger log = Logger.getLogger(IGVPreferences.class);
    static Hashtable<String, String> sessionCache = new Hashtable();
    static Hashtable<String, String> userPreferences = null;
    private File prefFile;

    public IGVPreferences() {
        this.prefFile = null;
    }

    public IGVPreferences(File prefFile) {
        this.prefFile = prefFile;
    }

    public void setPrefFile(File prefFile) {
        this.prefFile = prefFile;
    }

    public void put(String key, String value) {
        sessionCache.remove(key);
        if (userPreferences == null) {
            this.loadUserPreferences();
        }
        if (value == null) {
            userPreferences.remove(key);
        } else {
            userPreferences.put(key, value);
        }
        this.storePreferences();
    }

    public void putOverride(String key, String value) {
        sessionCache.put(key, value);
    }

    public String get(String key, String defaultValue) {
        if (sessionCache.containsKey(key)) {
            return sessionCache.get(key);
        }
        String val = this.get(key);
        return val == null ? defaultValue : val;
    }

    private String get(String key) {
        if (userPreferences == null) {
            this.loadUserPreferences();
        }
        return userPreferences.get(key);
    }

    public void remove(String key) {
        sessionCache.remove(key);
        userPreferences.remove(key);
        this.storePreferences();
    }

    public void clear() {
        userPreferences.clear();
        this.storePreferences();
    }

    synchronized void loadUserPreferences() {
        userPreferences = new Hashtable();
        if (this.prefFile == null) {
            this.prefFile = DirectoryManager.getPreferencesFile();
        }
        if (this.prefFile.exists()) {
            String prefFileName = this.prefFile.getAbsolutePath();
            this.load(prefFileName, false);
        }
    }

    public void loadOverrides(String path) {
        if (userPreferences == null) {
            this.loadUserPreferences();
        }
        this.load(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String prefFileName, boolean override) {
        if (prefFileName.contains("=")) {
            String[] kvPairs;
            for (String kvPair : kvPairs = prefFileName.split(",")) {
                String[] kv = kvPair.split("=");
                if (kv.length != 2) continue;
                this.override(kv[0], kv[1], override);
            }
        } else {
            BufferedReader reader = null;
            try {
                reader = ParsingUtils.openBufferedReader(prefFileName);
                String nextLine = null;
                while ((nextLine = reader.readLine()) != null) {
                    int idx = nextLine.indexOf(61);
                    if (idx <= 0) continue;
                    String key = nextLine.substring(0, idx);
                    String value = nextLine.substring(idx + 1);
                    this.override(key, value, override);
                }
            }
            catch (IOException e) {
                log.error("Error loading preferences", e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    log.error("Error closing preferences file", ex);
                }
            }
        }
    }

    private void override(String key, String value, boolean override) {
        if (!value.equals("null")) {
            if (override) {
                log.info("Overriding preference: " + key + "=" + value);
                sessionCache.put(key, value);
            } else {
                if (userPreferences == null) {
                    this.loadUserPreferences();
                }
                userPreferences.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void storePreferences() {
        if (userPreferences != null) {
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(this.prefFile);
                PrintWriter pw = new PrintWriter(new BufferedWriter(fileWriter));
                for (Map.Entry<String, String> entry : userPreferences.entrySet()) {
                    pw.print(entry.getKey());
                    pw.print("=");
                    pw.println(entry.getValue());
                }
                pw.flush();
                pw.close();
            }
            catch (IOException e) {
                log.error("Error loading preferences", e);
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

