/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.goby.GobyCountArchiveDataSource;
import org.broad.igv.lists.GeneList;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.CachingQueryReader;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.FeatureRenderer;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SpliceJunctionFinderTrack;
import org.broad.igv.session.Session;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.InsertSizeSettingsDialog;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.event.AlignmentTrackEvent;
import org.broad.igv.ui.event.AlignmentTrackEventListener;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.Pair;
import org.broad.igv.util.ResourceLocator;

public class AlignmentTrack
extends AbstractTrack
implements AlignmentTrackEventListener {
    private static Logger log = Logger.getLogger(AlignmentTrack.class);
    static final int GROUP_MARGIN = 5;
    static final int TOP_MARGIN = 20;
    static final int DS_MARGIN_0 = 2;
    static final int DOWNAMPLED_ROW_HEIGHT = 3;
    static final int DS_MARGIN_2 = 5;
    protected static final Map<BisulfiteContext, String> bisulfiteContextToPubString = new HashMap<BisulfiteContext, String>();
    protected static final Map<BisulfiteContext, Pair<byte[], byte[]>> bisulfiteContextToContextString;
    static final ColorOption DEFAULT_COLOR_OPTION;
    static final boolean DEFAULT_SHOWALLBASES = false;
    static final BisulfiteContext DEFAULT_BISULFITE_CONTEXT;
    private SequenceTrack sequenceTrack;
    private CoverageTrack coverageTrack;
    private SpliceJunctionFinderTrack spliceJunctionTrack;
    private RenderOptions renderOptions;
    private int expandedHeight = 14;
    private int maxSquishedHeight;
    private int squishedHeight = this.maxSquishedHeight = 4;
    private FeatureRenderer renderer;
    private double minVisibleScale = 25.0;
    private HashMap<String, Color> selectedReadNames = new HashMap();
    private int selectionColorIndex = 0;
    private int minHeight = 50;
    private AlignmentDataManager dataManager;
    private Genome genome;
    JComponent parent;
    private Rectangle alignmentsRect;
    private Rectangle downsampleRect;

    public AlignmentTrack(ResourceLocator locator, AlignmentDataManager dataManager, Genome genome) {
        super(locator);
        this.genome = genome;
        this.dataManager = dataManager;
        this.minimumHeight = 50;
        this.maximumHeight = Integer.MAX_VALUE;
        PreferenceManager prefs = PreferenceManager.getInstance();
        dataManager.setShowSpliceJunctions(prefs.getAsBoolean("SAM.SHOW_JUNCTION_TRACK"));
        float maxRange = prefs.getAsFloat("SAM.MAX_VISIBLE_RANGE");
        this.minVisibleScale = maxRange * 1000.0f / 700.0f;
        this.renderer = AlignmentRenderer.getInstance();
        this.setDisplayMode(Track.DisplayMode.EXPANDED);
        if (prefs.getAsBoolean("SAM.SHOW_REF_SEQ")) {
            this.sequenceTrack = new SequenceTrack("Reference sequence");
            this.sequenceTrack.setHeight(14);
        }
        this.renderOptions = new RenderOptions();
        if (this.renderOptions.getColorOption() == ColorOption.BISULFITE) {
            this.setExperimentType(ExperimentType.BISULFITE);
        }
        if (!Globals.isHeadless()) {
            IGV.getInstance().addAlignmentTrackEventListener(this);
        }
    }

    public void setExperimentType(ExperimentType type) {
        this.dataManager.setExperimentType(type);
        if (this.spliceJunctionTrack != null) {
            this.spliceJunctionTrack.setVisible(type != ExperimentType.BISULFITE);
        }
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public CoverageTrack getCoverageTrack() {
        return this.coverageTrack;
    }

    public void setSpliceJunctionTrack(SpliceJunctionFinderTrack spliceJunctionTrack) {
        this.spliceJunctionTrack = spliceJunctionTrack;
        if (this.dataManager.getExperimentType() == ExperimentType.BISULFITE) {
            spliceJunctionTrack.setVisible(false);
        }
    }

    public void setRenderer(FeatureRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        return new PopupMenu(te);
    }

    @Override
    public void setHeight(int preferredHeight) {
        super.setHeight(preferredHeight);
        this.minimumHeight = preferredHeight;
    }

    @Override
    public int getHeight() {
        if (this.parent != null && this.parent instanceof DataPanel && ((DataPanel)this.parent).getFrame().getScale() > this.minVisibleScale) {
            return this.minimumHeight;
        }
        int nGroups = this.dataManager.getMaxGroupCount();
        int h = Math.max(this.minHeight, this.getNLevels() * this.getRowHeight() + nGroups * 5 + 20 + 2 + 3 + 5);
        h = Math.min(this.maximumHeight, h);
        return h;
    }

    private int getRowHeight() {
        return this.getDisplayMode() == Track.DisplayMode.EXPANDED ? this.expandedHeight : this.squishedHeight;
    }

    private int getNLevels() {
        return this.dataManager.getNLevels();
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int seqHeight;
        this.parent = context.getPanel();
        int n = seqHeight = this.sequenceTrack == null ? 0 : this.sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            this.sequenceTrack.render(context, seqRect);
        }
        rect.y += 2;
        if (context.getScale() > this.minVisibleScale) {
            Rectangle visibleRect = context.getVisibleRect().intersection(rect);
            Graphics2D g = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Zoom in to see alignments.", visibleRect, g);
            return;
        }
        this.downsampleRect = new Rectangle(rect);
        this.downsampleRect.height = 3;
        this.renderDownsampledIntervals(context, this.downsampleRect);
        this.alignmentsRect = new Rectangle(rect);
        this.alignmentsRect.y += 8;
        this.renderAlignments(context, this.alignmentsRect);
    }

    private void renderDownsampledIntervals(RenderContext context, Rectangle downsampleRect) {
        if (!context.getVisibleRect().intersects(downsampleRect)) {
            return;
        }
        AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(context.getReferenceFrame());
        if (loadedInterval == null) {
            return;
        }
        Graphics2D g = context.getGraphic2DForColor(Color.black);
        List<CachingQueryReader.DownsampledInterval> intervals = loadedInterval.getDownsampledIntervals();
        for (CachingQueryReader.DownsampledInterval interval : intervals) {
            int x0 = context.bpToScreenPixel(interval.getStart());
            int x1 = context.bpToScreenPixel(interval.getEnd());
            int w = Math.max(1, x1 - x0);
            if (w > 5) {
                --w;
            }
            g.fillRect(x0, downsampleRect.y, w, downsampleRect.height);
        }
    }

    private void renderAlignments(RenderContext context, Rectangle inputRect) {
        try {
            boolean leaveMargin;
            log.debug("Render features");
            LinkedHashMap<String, List<AlignmentInterval.Row>> groups = this.dataManager.getGroups(context, this.renderOptions, this.renderOptions.bisulfiteContext);
            Map<String, PEStats> peStats = this.dataManager.getPEStats();
            if (peStats != null) {
                this.renderOptions.peStats = peStats;
            }
            if (groups == null) {
                return;
            }
            Rectangle visibleRect = context.getVisibleRect();
            boolean bl = leaveMargin = this.getDisplayMode() == Track.DisplayMode.EXPANDED;
            if (this.renderOptions.isPairedArcView()) {
                this.maximumHeight = (int)inputRect.getHeight();
                AlignmentRenderer.getInstance().clearCurveMaps();
            } else {
                this.maximumHeight = Integer.MAX_VALUE;
            }
            double y = inputRect.getY();
            double h = this.expandedHeight;
            if (this.getDisplayMode() != Track.DisplayMode.EXPANDED) {
                int visHeight = visibleRect.height;
                int depth = this.dataManager.getNLevels();
                this.squishedHeight = Math.min(this.maxSquishedHeight, Math.max(1, Math.min(this.expandedHeight, visHeight / depth)));
                h = this.squishedHeight;
            }
            Graphics2D groupBorderGraphics = context.getGraphic2DForColor(AlignmentRenderer.GROUP_DIVIDER_COLOR);
            int nGroups = groups.size();
            int groupNumber = 0;
            for (Map.Entry entry : groups.entrySet()) {
                String group = (String)entry.getKey();
                ++groupNumber;
                List rows = (List)entry.getValue();
                for (AlignmentInterval.Row row : rows) {
                    if (visibleRect != null && y > visibleRect.getMaxY()) {
                        return;
                    }
                    if (this.renderOptions.isPairedArcView()) {
                        y = Math.min((double)(this.getY() + this.getHeight()), visibleRect.getMaxY());
                        y -= h;
                    }
                    if (y + h > visibleRect.getY()) {
                        Rectangle rowRectangle = new Rectangle(inputRect.x, (int)y, inputRect.width, (int)h);
                        this.renderer.renderAlignments(row.alignments, context, rowRectangle, inputRect, this.renderOptions, leaveMargin, this.selectedReadNames);
                    }
                    y += h;
                }
                if (groupNumber < nGroups) {
                    int borderY = (int)y + 2;
                    groupBorderGraphics.drawLine(inputRect.x, borderY, inputRect.width, borderY);
                }
                y += 5.0;
            }
            int bottom = inputRect.y + inputRect.height;
            groupBorderGraphics.drawLine(inputRect.x, bottom, inputRect.width, bottom);
        }
        catch (Exception ex) {
            log.error("Error rendering track", ex);
            throw new RuntimeException("Error rendering track ", ex);
        }
    }

    public void clearCaches() {
        this.dataManager.clear();
    }

    public void sortRows(SortOption option, ReferenceFrame referenceFrame, double location, String tag) {
        this.dataManager.sortRows(option, referenceFrame, location, tag);
    }

    public void groupAlignments(GroupOption option, ReferenceFrame referenceFrame) {
        if (this.renderOptions.groupByOption != option) {
            this.renderOptions.groupByOption = option == GroupOption.NONE ? null : option;
            this.dataManager.repackAlignments(referenceFrame, this.renderOptions);
        }
    }

    public void packAlignments(ReferenceFrame referenceFrame) {
        this.dataManager.repackAlignments(referenceFrame, this.renderOptions);
    }

    public void copyToClipboard(TrackClickEvent e, Alignment alignment, double location) {
        if (alignment != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(alignment.getValueString(location, null).replace("<br>", "\n"));
            buf.append("\n");
            buf.append("Alignment start position = " + alignment.getChr() + ":" + (alignment.getAlignmentStart() + 1));
            buf.append("\n");
            buf.append(alignment.getReadSequence());
            StringSelection stringSelection = new StringSelection(buf.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    public void gotoMate(TrackClickEvent te, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                this.setSelected(alignment);
                String chr = mate.getChr();
                int start = mate.start - 1;
                te.getFrame().centerOnLocation(chr, start);
                te.getFrame().recordHistory();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    public void splitScreenMate(TrackClickEvent te, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                this.setSelected(alignment);
                String mateChr = mate.getChr();
                int mateStart = mate.start - 1;
                ReferenceFrame frame = te.getFrame();
                String locus1 = frame.getFormattedLocusString();
                ReferenceFrame.Range range = frame.getCurrentRange();
                int length = range.getLength();
                int s2 = Math.max(0, mateStart - length / 2);
                int e2 = s2 + length;
                String startStr = NumberFormat.getInstance().format(s2);
                String endStr = NumberFormat.getInstance().format(e2);
                String mateLocus = mateChr + ":" + startStr + "-" + endStr;
                Session currentSession = IGV.getInstance().getSession();
                ArrayList<String> loci = null;
                if (FrameManager.isGeneListMode()) {
                    loci = new ArrayList(FrameManager.getFrames().size());
                    for (ReferenceFrame ref : FrameManager.getFrames()) {
                        loci.add(ref.getInitialLocus().toString());
                    }
                    loci.add(mateLocus);
                } else {
                    loci = Arrays.asList(locus1, mateLocus);
                }
                GeneList.sortByPosition(loci);
                StringBuffer listName = new StringBuffer();
                for (String s : loci) {
                    listName.append(s + "   ");
                }
                GeneList geneList = new GeneList(listName.toString(), loci, false);
                currentSession.setCurrentGeneList(geneList);
                IGV.getInstance().resetFrames();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public void setRendererClass(Class rc) {
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        if (this.downsampleRect != null && y > this.downsampleRect.y && y <= this.downsampleRect.y + this.downsampleRect.height) {
            AlignmentInterval iv = this.dataManager.getLoadedInterval(frame);
            if (iv == null) {
                return null;
            }
            List<CachingQueryReader.DownsampledInterval> intervals = iv.getDownsampledIntervals();
            CachingQueryReader.DownsampledInterval interval = (CachingQueryReader.DownsampledInterval)FeatureUtils.getFeatureAt(position, 0, intervals);
            return interval == null ? null : interval.getValueString();
        }
        if (this.renderOptions.isPairedArcView()) {
            LocusScore feature = null;
            double xloc = (position - frame.getOrigin()) / frame.getScale();
            SortedSet<Shape> arcs = AlignmentRenderer.getInstance().curveOverlap(xloc);
            int halfLength = 2;
            int sideLength = 2 * halfLength;
            for (Shape curve : arcs) {
                if (!curve.intersects(xloc - (double)halfLength, y - halfLength, sideLength, sideLength)) continue;
                feature = AlignmentRenderer.getInstance().getAlignmentForCurve(curve);
                break;
            }
            return feature == null ? null : feature.getValueString(position, this.getWindowFunction());
        }
        Alignment feature = this.getAlignmentAt(position, y, frame);
        return feature == null ? null : feature.getValueString(position, this.getWindowFunction());
    }

    private Alignment getAlignmentAt(double position, int y, ReferenceFrame frame) {
        Map<String, List<AlignmentInterval.Row>> groups = this.dataManager.getGroupedAlignments(frame);
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        int h = this.getDisplayMode() == Track.DisplayMode.EXPANDED ? this.expandedHeight : this.squishedHeight;
        int startY = this.alignmentsRect.y;
        boolean leaveMargin = this.getDisplayMode() == Track.DisplayMode.EXPANDED;
        for (List<AlignmentInterval.Row> rows : groups.values()) {
            int endY = startY + rows.size() * h;
            if (y >= startY && y < endY) {
                int levelNumber = (y - startY) / h;
                AlignmentInterval.Row row = rows.get(levelNumber);
                List<Alignment> features = row.alignments;
                int buffer = 0;
                return (Alignment)FeatureUtils.getFeatureAt(position, buffer, features);
            }
            startY = endY + 5;
        }
        return null;
    }

    @Override
    public void onAlignmentTrackEvent(AlignmentTrackEvent e) {
        AlignmentTrackEvent.Type type = e.getType();
        switch (type) {
            case VISIBILITY_WINDOW: {
                this.visibilityWindowChanged();
                break;
            }
            case RELOAD: 
            case SPLICE_JUNCTION: {
                boolean showJunctions = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_JUNCTION_TRACK");
                this.dataManager.setShowSpliceJunctions(showJunctions);
                this.clearCaches();
            }
        }
    }

    private void visibilityWindowChanged() {
        PreferenceManager prefs = PreferenceManager.getInstance();
        float maxRange = prefs.getAsFloat("SAM.MAX_VISIBLE_RANGE");
        this.minVisibleScale = maxRange * 1000.0f / 700.0f;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        ReferenceFrame frame;
        MouseEvent e = te.getMouseEvent();
        if ((Globals.IS_MAC && e.isMetaDown() || !Globals.IS_MAC && e.isControlDown()) && (frame = te.getFrame()) != null) {
            this.selectAlignment(e, frame);
            if (this.parent != null) {
                this.parent.repaint();
            }
            return true;
        }
        if (IGV.getInstance().isSuppressTooltip()) {
            this.openTooltipWindow(te);
        }
        return false;
    }

    private void selectAlignment(MouseEvent e, ReferenceFrame frame) {
        double location = frame.getChromosomePosition(e.getX());
        Alignment alignment = this.getAlignmentAt(location, e.getY(), frame);
        if (alignment != null) {
            if (this.selectedReadNames.containsKey(alignment.getReadName())) {
                this.selectedReadNames.remove(alignment.getReadName());
            } else {
                this.setSelected(alignment);
            }
        }
    }

    private void setSelected(Alignment alignment) {
        Color c = alignment.isPaired() && alignment.getMate() != null && alignment.getMate().isMapped() ? ColorUtilities.randomColor(this.selectionColorIndex++) : Color.black;
        this.selectedReadNames.put(alignment.getReadName(), c);
    }

    private void refresh() {
        IGV.getInstance().getContentPane().getMainPanel().invalidate();
        IGV.getInstance().repaintDataPanels();
    }

    public static boolean isBisulfiteColorType(ColorOption o) {
        return o.equals((Object)ColorOption.BISULFITE) || o.equals((Object)ColorOption.NOMESEQ);
    }

    public static String getBisulfiteContextPubStr(BisulfiteContext item) {
        return bisulfiteContextToPubString.get((Object)item);
    }

    public static byte[] getBisulfiteContextPreContext(BisulfiteContext item) {
        Pair<byte[], byte[]> pair = bisulfiteContextToContextString.get((Object)item);
        return pair.getFirst();
    }

    public static byte[] getBisulfiteContextPostContext(BisulfiteContext item) {
        Pair<byte[], byte[]> pair = bisulfiteContextToContextString.get((Object)item);
        return pair.getSecond();
    }

    @Override
    public Map<String, String> getPersistentState() {
        Map<String, String> attrs = super.getPersistentState();
        attrs.putAll(this.renderOptions.getPersistentState());
        if (this.dataManager.isShowSpliceJunctions()) {
            attrs.put("showSpliceJunctions", String.valueOf(this.dataManager.isShowSpliceJunctions()));
        }
        return attrs;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        super.restorePersistentState(attributes);
        this.renderOptions.restorePersistentState(attributes);
        String spliceJunctionOption = attributes.get("showSpliceJunctions");
        if (spliceJunctionOption != null) {
            try {
                this.dataManager.setShowSpliceJunctions(Boolean.parseBoolean(spliceJunctionOption));
            }
            catch (Exception e) {
                log.error("Error restoring splice junction option: " + spliceJunctionOption);
            }
        }
    }

    public void setViewAsPairs(boolean vAP) {
        if (vAP && this.renderOptions.groupByOption == GroupOption.STRAND) {
            boolean ungroup = MessageUtils.confirm("\"View as pairs\" is incompatible with \"Group by strand\". Ungroup?");
            if (ungroup) {
                this.renderOptions.groupByOption = null;
            } else {
                return;
            }
        }
        this.dataManager.setViewAsPairs(vAP, this.renderOptions);
        this.refresh();
    }

    public boolean isPairedArcView() {
        return this.renderOptions.isPairedArcView();
    }

    public void setPairedArcView(boolean option) {
        if (option == this.isPairedArcView()) {
            return;
        }
        if (option) {
            this.setViewAsPairs(false);
        }
        this.renderOptions.setPairedArcView(option);
        for (ReferenceFrame frame : FrameManager.getFrames()) {
            this.dataManager.repackAlignments(frame, this.renderOptions);
        }
        this.refresh();
    }

    static {
        bisulfiteContextToPubString.put(BisulfiteContext.CG, "CG");
        bisulfiteContextToPubString.put(BisulfiteContext.CHH, "CHH");
        bisulfiteContextToPubString.put(BisulfiteContext.CHG, "CHG");
        bisulfiteContextToPubString.put(BisulfiteContext.HCG, "HCG");
        bisulfiteContextToPubString.put(BisulfiteContext.GCH, "GCH");
        bisulfiteContextToPubString.put(BisulfiteContext.WCG, "WCG");
        bisulfiteContextToContextString = new HashMap<BisulfiteContext, Pair<byte[], byte[]>>();
        bisulfiteContextToContextString.put(BisulfiteContext.CG, new Pair<byte[], byte[]>(new byte[0], new byte[]{71}));
        bisulfiteContextToContextString.put(BisulfiteContext.CHH, new Pair<byte[], byte[]>(new byte[0], new byte[]{72, 72}));
        bisulfiteContextToContextString.put(BisulfiteContext.CHG, new Pair<byte[], byte[]>(new byte[0], new byte[]{72, 71}));
        bisulfiteContextToContextString.put(BisulfiteContext.HCG, new Pair<byte[], byte[]>(new byte[]{72}, new byte[]{71}));
        bisulfiteContextToContextString.put(BisulfiteContext.GCH, new Pair<byte[], byte[]>(new byte[]{71}, new byte[]{72}));
        bisulfiteContextToContextString.put(BisulfiteContext.WCG, new Pair<byte[], byte[]>(new byte[]{87}, new byte[]{71}));
        DEFAULT_COLOR_OPTION = ColorOption.INSERT_SIZE;
        DEFAULT_BISULFITE_CONTEXT = BisulfiteContext.CG;
    }

    class PopupMenu
    extends IGVPopupMenu {
        PopupMenu(TrackClickEvent e) {
            ArrayList<Track> tracks = new ArrayList<Track>();
            tracks.add(AlignmentTrack.this);
            JLabel popupTitle = new JLabel("  " + AlignmentTrack.this.getName(), 0);
            Font newFont = this.getFont().deriveFont(1, 12.0f);
            popupTitle.setFont(newFont);
            if (popupTitle != null) {
                this.add(popupTitle);
            }
            this.addSeparator();
            this.add(TrackMenuUtils.getTrackRenameItem(tracks));
            this.addCopyToClipboardItem(e);
            this.addSeparator();
            this.addGroupMenuItem();
            this.addSortMenuItem();
            this.addColorByMenuItem();
            this.addSeparator();
            this.addShadeBaseMenuItem();
            this.addShowMismatchesMenuItem();
            this.addShowAllBasesMenuItem();
            this.addSeparator();
            this.addViewAsPairsMenuItem();
            boolean viewPairArcsPresent = Boolean.parseBoolean(System.getProperty("pairedArcViewPresent", "false"));
            if (viewPairArcsPresent) {
                this.addViewPairedArcsMenuItem();
            }
            this.addGoToMate(e);
            this.showMateRegion(e);
            this.addInsertSizeMenuItem();
            this.addSeparator();
            this.addPackMenuItem();
            this.addShowCoverageItem();
            this.addLoadCoverageDataItem();
            this.addSeparator();
            TrackMenuUtils.addDisplayModeItems(tracks, this);
            this.addSeparator();
            this.addSelecteByNameItem();
            this.addClearSelectionsMenuItem();
            this.addSeparator();
            this.add(TrackMenuUtils.getRemoveMenuItem(tracks));
        }

        private JMenu getBisulfiteContextMenuItem(ButtonGroup group) {
            JMenu bisulfiteContextMenu = new JMenu("bisulfite mode");
            JRadioButtonMenuItem nomeESeqOption = null;
            boolean showNomeESeq = PreferenceManager.getInstance().getAsBoolean("SAM.NOMESEQ_ENABLED");
            if (showNomeESeq) {
                nomeESeqOption = new JRadioButtonMenuItem("NOMe-seq bisulfite mode");
                nomeESeqOption.setSelected(AlignmentTrack.this.renderOptions.colorOption == ColorOption.NOMESEQ);
                nomeESeqOption.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        PopupMenu.this.setColorOption(ColorOption.NOMESEQ);
                        AlignmentTrack.this.refresh();
                    }
                });
                group.add(nomeESeqOption);
            }
            for (final BisulfiteContext item : BisulfiteContext.values()) {
                String optionStr = AlignmentTrack.getBisulfiteContextPubStr(item);
                JRadioButtonMenuItem m1 = new JRadioButtonMenuItem(optionStr);
                m1.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.bisulfiteContext == item);
                m1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        PopupMenu.this.setColorOption(ColorOption.BISULFITE);
                        PopupMenu.this.setBisulfiteContext(item);
                        AlignmentTrack.this.refresh();
                    }
                });
                bisulfiteContextMenu.add(m1);
                group.add(m1);
            }
            if (nomeESeqOption != null) {
                bisulfiteContextMenu.add(nomeESeqOption);
            }
            return bisulfiteContextMenu;
        }

        public void addSelecteByNameItem() {
            JMenuItem item = new JMenuItem("Select by name...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    String val = MessageUtils.showInputDialog("Enter read name: ");
                    if (val != null && val.trim().length() > 0) {
                        AlignmentTrack.this.selectedReadNames.put(val, ColorUtilities.randomColor(AlignmentTrack.this.selectedReadNames.size() + 1));
                        AlignmentTrack.this.refresh();
                    }
                }
            });
            this.add(item);
        }

        private JCheckBoxMenuItem getGroupMenuItem(String label, final GroupOption option) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(label);
            mi.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.groupByOption == option);
            if (option == GroupOption.NONE) {
                mi.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.groupByOption == null);
            }
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    IGV.getInstance().groupAlignmentTracks(option);
                    AlignmentTrack.this.refresh();
                }
            });
            return mi;
        }

        public void addGroupMenuItem() {
            JMenu groupMenu = new JMenu("Group alignments by");
            ButtonGroup group = new ButtonGroup();
            LinkedHashMap<String, GroupOption> mappings = new LinkedHashMap<String, GroupOption>();
            mappings.put("none", GroupOption.NONE);
            mappings.put("read strand", GroupOption.STRAND);
            mappings.put("first-in-pair strand", GroupOption.FIRST_OF_PAIR_STRAND);
            mappings.put("sample", GroupOption.SAMPLE);
            mappings.put("read group", GroupOption.READ_GROUP);
            for (Map.Entry el : mappings.entrySet()) {
                JCheckBoxMenuItem mi = this.getGroupMenuItem((String)el.getKey(), (GroupOption)((Object)el.getValue()));
                groupMenu.add(mi);
                group.add(mi);
            }
            JCheckBoxMenuItem tagOption = new JCheckBoxMenuItem("tag");
            tagOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    String tag = MessageUtils.showInputDialog("Enter tag", AlignmentTrack.this.renderOptions.getGroupByTag());
                    AlignmentTrack.this.renderOptions.setGroupByTag(tag);
                    IGV.getInstance().groupAlignmentTracks(GroupOption.TAG);
                    AlignmentTrack.this.refresh();
                }
            });
            tagOption.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.groupByOption == GroupOption.TAG);
            groupMenu.add(tagOption);
            group.add(tagOption);
            this.add(groupMenu);
        }

        private JMenuItem getSortMenuItem(String label, final SortOption option) {
            JMenuItem mi = new JMenuItem(label);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    IGV.getInstance().sortAlignmentTracks(option, null);
                    AlignmentTrack.this.refresh();
                }
            });
            return mi;
        }

        public void addSortMenuItem() {
            JMenu sortMenu = new JMenu("Sort alignments by");
            LinkedHashMap<String, SortOption> mappings = new LinkedHashMap<String, SortOption>();
            mappings.put("start location", SortOption.START);
            mappings.put("read strand", SortOption.STRAND);
            mappings.put("first-of-pair strand", SortOption.FIRST_OF_PAIR_STRAND);
            mappings.put("base", SortOption.NUCELOTIDE);
            mappings.put("mapping quality", SortOption.QUALITY);
            mappings.put("sample", SortOption.SAMPLE);
            mappings.put("read group", SortOption.READ_GROUP);
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                mappings.put("insert size", SortOption.INSERT_SIZE);
                mappings.put("chromosome of mate", SortOption.MATE_CHR);
            }
            for (Map.Entry el : mappings.entrySet()) {
                sortMenu.add(this.getSortMenuItem((String)el.getKey(), (SortOption)((Object)el.getValue())));
            }
            JMenuItem tagOption = new JMenuItem("tag");
            tagOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    String tag = MessageUtils.showInputDialog("Enter tag", AlignmentTrack.this.renderOptions.getSortByTag());
                    AlignmentTrack.this.renderOptions.setSortByTag(tag);
                    IGV.getInstance().sortAlignmentTracks(SortOption.TAG, tag);
                    AlignmentTrack.this.refresh();
                }
            });
            sortMenu.add(tagOption);
            this.add(sortMenu);
        }

        private void setBisulfiteContext(BisulfiteContext option) {
            ((AlignmentTrack)AlignmentTrack.this).renderOptions.bisulfiteContext = option;
            PreferenceManager.getInstance().put("SAM.BISULFITE_CONTEXT", option.toString());
        }

        private void setColorOption(ColorOption option) {
            AlignmentTrack.this.renderOptions.colorOption = option;
            PreferenceManager.getInstance().put("SAM.COLOR_BY", option.toString());
            ExperimentType t = option == ColorOption.BISULFITE ? ExperimentType.BISULFITE : ExperimentType.OTHER;
            AlignmentTrack.this.setExperimentType(t);
        }

        private JRadioButtonMenuItem getColorMenuItem(String label, final ColorOption option) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(label);
            mi.setSelected(AlignmentTrack.this.renderOptions.colorOption == option);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    PopupMenu.this.setColorOption(option);
                    AlignmentTrack.this.refresh();
                }
            });
            return mi;
        }

        public void addColorByMenuItem() {
            JMenu colorMenu = new JMenu("Color alignments by");
            ButtonGroup group = new ButtonGroup();
            LinkedHashMap<String, ColorOption> mappings = new LinkedHashMap<String, ColorOption>();
            mappings.put("no color", ColorOption.NONE);
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                mappings.put("insert size", ColorOption.INSERT_SIZE);
                mappings.put("pair orientation", ColorOption.PAIR_ORIENTATION);
                mappings.put("insert size and pair orientation", ColorOption.UNEXPECTED_PAIR);
            }
            mappings.put("read strand", ColorOption.READ_STRAND);
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                mappings.put("first-of-pair strand", ColorOption.FIRST_OF_PAIR_STRAND);
            }
            mappings.put("read group", ColorOption.READ_GROUP);
            mappings.put("sample", ColorOption.SAMPLE);
            for (Map.Entry el : mappings.entrySet()) {
                JRadioButtonMenuItem mi = this.getColorMenuItem((String)el.getKey(), (ColorOption)((Object)el.getValue()));
                colorMenu.add(mi);
                group.add(mi);
            }
            JRadioButtonMenuItem tagOption = new JRadioButtonMenuItem("tag");
            tagOption.setSelected(AlignmentTrack.this.renderOptions.colorOption == ColorOption.TAG);
            tagOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    PopupMenu.this.setColorOption(ColorOption.TAG);
                    String tag = MessageUtils.showInputDialog("Enter tag", AlignmentTrack.this.renderOptions.getColorByTag());
                    AlignmentTrack.this.renderOptions.setColorByTag(tag);
                    PreferenceManager.getInstance();
                    AlignmentTrack.this.refresh();
                }
            });
            colorMenu.add(tagOption);
            group.add(tagOption);
            colorMenu.add(this.getBisulfiteContextMenuItem(group));
            this.add(colorMenu);
        }

        public void addPackMenuItem() {
            JMenuItem item = new JMenuItem("Re-pack alignments");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            IGV.getInstance().packAlignmentTracks();
                            AlignmentTrack.this.refresh();
                        }
                    });
                }
            });
            this.add(item);
        }

        public void addCopyToClipboardItem(final TrackClickEvent te) {
            MouseEvent me = te.getMouseEvent();
            JMenuItem item = new JMenuItem("Copy read details to clipboard");
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                final double location = frame.getChromosomePosition(me.getX());
                final Alignment alignment = AlignmentTrack.this.getAlignmentAt(location, me.getY(), frame);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.copyToClipboard(te, alignment, location);
                    }
                });
                if (alignment == null) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        public void addViewPairedArcsMenuItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("View paired arcs");
            item.setSelected(AlignmentTrack.this.isPairedArcView());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    boolean isPairedArcView = item.isSelected();
                    AlignmentTrack.this.setPairedArcView(isPairedArcView);
                }
            });
            item.setEnabled(AlignmentTrack.this.dataManager.isPairedEnd());
            this.add(item);
        }

        public void addViewAsPairsMenuItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("View as pairs");
            item.setSelected(AlignmentTrack.this.dataManager.isViewAsPairs());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    boolean viewAsPairs = item.isSelected();
                    AlignmentTrack.this.setViewAsPairs(viewAsPairs);
                }
            });
            item.setEnabled(AlignmentTrack.this.dataManager.isPairedEnd());
            this.add(item);
        }

        public void addGoToMate(final TrackClickEvent te) {
            JMenuItem item = new JMenuItem("Go to mate");
            MouseEvent e = te.getMouseEvent();
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                double location = frame.getChromosomePosition(e.getX());
                final Alignment alignment = AlignmentTrack.this.getAlignmentAt(location, e.getY(), frame);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.gotoMate(te, alignment);
                    }
                });
                if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        public void showMateRegion(final TrackClickEvent te) {
            JMenuItem item = new JMenuItem("View mate region in split screen");
            MouseEvent e = te.getMouseEvent();
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                double location = frame.getChromosomePosition(e.getX());
                final Alignment alignment = AlignmentTrack.this.getAlignmentAt(location, e.getY(), frame);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.splitScreenMate(te, alignment);
                    }
                });
                if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        public void addClearSelectionsMenuItem() {
            JMenuItem item = new JMenuItem("Clear selections");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    AlignmentTrack.this.selectedReadNames.clear();
                    AlignmentTrack.this.refresh();
                }
            });
            this.add(item);
        }

        public void addShowAllBasesMenuItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show all bases");
            if (AlignmentTrack.this.renderOptions.colorOption != ColorOption.BISULFITE && AlignmentTrack.this.renderOptions.colorOption != ColorOption.NOMESEQ) {
                item.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.showAllBases);
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    ((AlignmentTrack)AlignmentTrack.this).renderOptions.showAllBases = item.isSelected();
                    AlignmentTrack.this.refresh();
                }
            });
            this.add(item);
        }

        public void addShowMismatchesMenuItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show mismatched bases");
            item.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.showMismatches);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    ((AlignmentTrack)AlignmentTrack.this).renderOptions.showMismatches = item.isSelected();
                    AlignmentTrack.this.refresh();
                }
            });
            this.add(item);
        }

        public void addInsertSizeMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Set insert size options ...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    InsertSizeSettingsDialog dlg = new InsertSizeSettingsDialog(IGV.getMainFrame(), AlignmentTrack.this.renderOptions);
                    dlg.setModal(true);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        AlignmentTrack.this.renderOptions.setComputeIsizes(dlg.isComputeIsize());
                        AlignmentTrack.this.renderOptions.setMinInsertSizePercentile(dlg.getMinPercentile());
                        AlignmentTrack.this.renderOptions.setMaxInsertSizePercentile(dlg.getMaxPercentile());
                        if (AlignmentTrack.this.renderOptions.isComputeIsizes()) {
                            AlignmentTrack.this.dataManager.updatePEStats(AlignmentTrack.this.renderOptions);
                        }
                        AlignmentTrack.this.renderOptions.setMinInsertSize(dlg.getMinThreshold());
                        AlignmentTrack.this.renderOptions.setMaxInsertSize(dlg.getMaxThreshold());
                        AlignmentTrack.this.refresh();
                    }
                }
            });
            item.setEnabled(AlignmentTrack.this.dataManager.isPairedEnd());
            this.add(item);
        }

        public void addShadeBaseMenuItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Shade base by quality");
            item.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.shadeBases);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            ((AlignmentTrack)AlignmentTrack.this).renderOptions.shadeBases = item.isSelected();
                            AlignmentTrack.this.refresh();
                        }
                    });
                }
            });
            this.add(item);
        }

        public void addShowCoverageItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show coverage track");
            item.setSelected(AlignmentTrack.this.getCoverageTrack() != null && AlignmentTrack.this.getCoverageTrack().isVisible());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            if (AlignmentTrack.this.getCoverageTrack() != null) {
                                AlignmentTrack.this.getCoverageTrack().setVisible(item.isSelected());
                                AlignmentTrack.this.refresh();
                                IGV.getInstance().repaintNamePanels();
                            }
                        }
                    });
                }
            });
            this.add(item);
        }

        public void addLoadCoverageDataItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Load coverage data...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            PreferenceManager prefs = PreferenceManager.getInstance();
                            File initDirectory = prefs.getLastTrackDirectory();
                            File file = FileDialogUtils.chooseFile("Select coverage file", initDirectory, 0);
                            if (file != null) {
                                prefs.setLastTrackDirectory(file.getParentFile());
                                String path = file.getAbsolutePath();
                                if (path.endsWith(".tdf") || path.endsWith(".tdf")) {
                                    TDFReader reader = TDFReader.getReader(file.getAbsolutePath());
                                    TDFDataSource ds = new TDFDataSource(reader, 0, PopupMenu.this.getName() + " coverage", AlignmentTrack.this.genome);
                                    AlignmentTrack.this.getCoverageTrack().setDataSource(ds);
                                    AlignmentTrack.this.refresh();
                                } else if (path.endsWith(".counts")) {
                                    GobyCountArchiveDataSource ds = new GobyCountArchiveDataSource(file);
                                    AlignmentTrack.this.getCoverageTrack().setDataSource(ds);
                                    AlignmentTrack.this.refresh();
                                } else {
                                    MessageUtils.showMessage("Coverage data must be in .tdf format");
                                }
                            }
                        }
                    });
                }
            });
            this.add(item);
        }
    }

    public static class RenderOptions {
        boolean shadeBases;
        boolean shadeCenters;
        boolean flagUnmappedPairs;
        boolean showAllBases;
        boolean showMismatches = true;
        private boolean computeIsizes;
        private int minInsertSize;
        private int maxInsertSize;
        private double minInsertSizePercentile;
        private double maxInsertSizePercentile;
        private ColorOption colorOption;
        GroupOption groupByOption = null;
        BisulfiteContext bisulfiteContext;
        private boolean viewPairs = false;
        private boolean pairedArcView = false;
        public boolean flagZeroQualityAlignments = true;
        Map<String, PEStats> peStats;
        private String colorByTag;
        private String groupByTag;
        private String sortByTag;

        RenderOptions() {
            PreferenceManager prefs = PreferenceManager.getInstance();
            this.shadeBases = prefs.getAsBoolean("SAM.SHADE_BASE_QUALITY");
            this.shadeCenters = prefs.getAsBoolean("SAM.SHADE_CENTER");
            this.flagUnmappedPairs = prefs.getAsBoolean("SAM.FLAG_UNMAPPED_PAIR");
            this.computeIsizes = prefs.getAsBoolean("SAM.COMPUTE_ISIZES");
            this.minInsertSize = prefs.getAsInt("SAM.MIN_INSERT_SIZE_THRESHOLD");
            this.maxInsertSize = prefs.getAsInt("SAM.INSERT_SIZE_THRESHOLD");
            this.minInsertSizePercentile = prefs.getAsFloat("SAM.MIN_ISIZE_MIN_PERCENTILE");
            this.maxInsertSizePercentile = prefs.getAsFloat("SAM.ISIZE_MAX_PERCENTILE");
            this.showAllBases = false;
            this.colorOption = ColorOption.strToValue(prefs.get("SAM.COLOR_BY"));
            this.groupByOption = null;
            this.flagZeroQualityAlignments = prefs.getAsBoolean("SAM.FLAG_ZERO_QUALITY");
            this.bisulfiteContext = DEFAULT_BISULFITE_CONTEXT;
            this.colorByTag = prefs.get("SAM.COLOR_BY_TAG");
            this.sortByTag = prefs.get("SAM.SORT_BY_TAG");
            this.groupByTag = prefs.get("SAM.GROUP_BY_TAG");
            this.peStats = new HashMap<String, PEStats>();
        }

        public Map<String, String> getPersistentState() {
            HashMap<String, String> attributes = new HashMap<String, String>();
            PreferenceManager prefs = PreferenceManager.getInstance();
            if (this.shadeBases != prefs.getAsBoolean("SAM.SHADE_BASE_QUALITY")) {
                attributes.put("shadeBases", String.valueOf(this.shadeBases));
            }
            if (this.shadeCenters != prefs.getAsBoolean("SAM.SHADE_CENTER")) {
                attributes.put("shadeCenters", String.valueOf(this.shadeBases));
            }
            if (this.flagUnmappedPairs != prefs.getAsBoolean("SAM.FLAG_UNMAPPED_PAIR")) {
                attributes.put("flagUnmappedPairs", String.valueOf(this.flagUnmappedPairs));
            }
            if (this.maxInsertSize != prefs.getAsInt("SAM.INSERT_SIZE_THRESHOLD")) {
                attributes.put("insertSizeThreshold", String.valueOf(this.maxInsertSize));
            }
            if (this.getMinInsertSize() != prefs.getAsInt("SAM.MIN_INSERT_SIZE_THRESHOLD")) {
                attributes.put("minInsertSizeThreshold", String.valueOf(this.maxInsertSize));
            }
            if (this.showAllBases) {
                attributes.put("showAllBases", String.valueOf(this.showAllBases));
            }
            if (this.colorOption != DEFAULT_COLOR_OPTION) {
                attributes.put("colorOption", this.colorOption.toString());
            }
            if (this.groupByOption != null) {
                attributes.put("groupByOption", this.groupByOption.toString());
            }
            if (this.colorByTag != null && this.colorByTag.length() > 0) {
                attributes.put("colorByTag", this.colorByTag);
            }
            if (this.groupByTag != null && this.groupByTag.length() > 0) {
                attributes.put("groupByTag", this.groupByTag);
            }
            if (this.sortByTag != null) {
                attributes.put("sortByTag", this.sortByTag);
            }
            return attributes;
        }

        public void restorePersistentState(Map<String, String> attributes) {
            String value = attributes.get("insertSizeThreshold");
            if (value != null) {
                this.maxInsertSize = Integer.parseInt(value);
            }
            if ((value = attributes.get("minInsertSizeThreshold")) != null) {
                this.setMinInsertSize(Integer.parseInt(value));
            }
            if ((value = attributes.get("shadeBases")) != null) {
                this.shadeBases = Boolean.parseBoolean(value);
            }
            if ((value = attributes.get("shadeCenters")) != null) {
                this.shadeCenters = Boolean.parseBoolean(value);
            }
            if ((value = attributes.get("flagUnmappedPairs")) != null) {
                this.flagUnmappedPairs = Boolean.parseBoolean(value);
            }
            if ((value = attributes.get("showAllBases")) != null) {
                this.showAllBases = Boolean.parseBoolean(value);
            }
            if ((value = attributes.get("colorOption")) != null) {
                this.colorOption = ColorOption.strToValue(value);
            }
            if ((value = attributes.get("groupByOption")) != null) {
                this.groupByOption = GroupOption.strToValue(value);
            }
            if ((value = attributes.get("bisulfiteContextRenderOption")) != null) {
                this.bisulfiteContext = BisulfiteContext.strToValue(value);
            }
            if ((value = attributes.get("groupByTag")) != null) {
                this.groupByTag = value;
            }
            if ((value = attributes.get("sortByTag")) != null) {
                this.sortByTag = value;
            }
            if ((value = attributes.get("colorByTag")) != null) {
                this.colorByTag = value;
            }
        }

        public boolean isPairedArcView() {
            return this.pairedArcView;
        }

        public void setPairedArcView(boolean pairedArcView) {
            this.pairedArcView = pairedArcView;
        }

        public int getMinInsertSize() {
            return this.minInsertSize;
        }

        public void setMinInsertSize(int minInsertSize) {
            this.minInsertSize = minInsertSize;
        }

        public int getMaxInsertSize() {
            return this.maxInsertSize;
        }

        public boolean isViewPairs() {
            return this.viewPairs;
        }

        public void setViewPairs(boolean viewPairs) {
            this.viewPairs = viewPairs;
        }

        public boolean isComputeIsizes() {
            return this.computeIsizes;
        }

        public void setComputeIsizes(boolean computeIsizes) {
            this.computeIsizes = computeIsizes;
        }

        public double getMinInsertSizePercentile() {
            return this.minInsertSizePercentile;
        }

        public void setMinInsertSizePercentile(double minInsertSizePercentile) {
            this.minInsertSizePercentile = minInsertSizePercentile;
        }

        public double getMaxInsertSizePercentile() {
            return this.maxInsertSizePercentile;
        }

        public void setMaxInsertSizePercentile(double maxInsertSizePercentile) {
            this.maxInsertSizePercentile = maxInsertSizePercentile;
        }

        public void setMaxInsertSize(int maxInsertSize) {
            this.maxInsertSize = maxInsertSize;
        }

        public ColorOption getColorOption() {
            return this.colorOption;
        }

        public void setColorOption(ColorOption colorOption) {
            this.colorOption = colorOption;
        }

        public void setColorByTag(String colorByTag) {
            this.colorByTag = colorByTag;
            PreferenceManager.getInstance().put("SAM.COLOR_BY_TAG", colorByTag);
        }

        public String getColorByTag() {
            return this.colorByTag;
        }

        public String getSortByTag() {
            return this.sortByTag;
        }

        public void setSortByTag(String sortByTag) {
            this.sortByTag = sortByTag;
        }

        public String getGroupByTag() {
            return this.groupByTag;
        }

        public void setGroupByTag(String groupByTag) {
            this.groupByTag = groupByTag;
        }
    }

    public static enum BisulfiteContext {
        CG,
        CHH,
        CHG,
        HCG,
        GCH,
        WCG;


        static BisulfiteContext strToValue(String str) {
            try {
                return BisulfiteContext.valueOf(str);
            }
            catch (Exception e) {
                return CG;
            }
        }
    }

    public static enum GroupOption {
        STRAND,
        SAMPLE,
        READ_GROUP,
        FIRST_OF_PAIR_STRAND,
        TAG,
        NONE;


        static GroupOption strToValue(String str) {
            try {
                return GroupOption.valueOf(str);
            }
            catch (Exception e) {
                return NONE;
            }
        }
    }

    public static enum SortOption {
        START,
        STRAND,
        NUCELOTIDE,
        QUALITY,
        SAMPLE,
        READ_GROUP,
        INSERT_SIZE,
        FIRST_OF_PAIR_STRAND,
        MATE_CHR,
        TAG;


        static SortOption strToValue(String str) {
            try {
                return SortOption.valueOf(str);
            }
            catch (Exception e) {
                return START;
            }
        }
    }

    public static enum ColorOption {
        UNEXPECTED_PAIR,
        INSERT_SIZE,
        READ_STRAND,
        FIRST_OF_PAIR_STRAND,
        PAIR_ORIENTATION,
        SAMPLE,
        READ_GROUP,
        BISULFITE,
        NOMESEQ,
        TAG,
        NONE;


        static ColorOption strToValue(String str) {
            try {
                return ColorOption.valueOf(str);
            }
            catch (Exception e) {
                return NONE;
            }
        }
    }

    public static enum ExperimentType {
        RNA,
        BISULFITE,
        OTHER;


        static ExperimentType strToValue(String str) {
            try {
                return ExperimentType.valueOf(str);
            }
            catch (Exception e) {
                return OTHER;
            }
        }
    }
}

