/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.MainPanel;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.svg.SVGGraphics;
import org.broad.igv.ui.util.SnapshotFileChooser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SnapshotUtilities {
    private static Logger log = Logger.getLogger(SnapshotUtilities.class);
    public static int DEFAULT_MAX_PANEL_HEIGHT = 1000;
    private static ThreadLocal<Integer> maxPanelHeight = new ThreadLocal(){

        protected Object initialValue() {
            return new Integer(DEFAULT_MAX_PANEL_HEIGHT);
        }
    };

    public static int getMaxPanelHeight() {
        return maxPanelHeight.get();
    }

    public static void setMaxPanelHeight(int h) {
        maxPanelHeight.set(h);
    }

    private SnapshotUtilities() {
    }

    public static void doComponentSnapshot(Component component, File file, SnapshotFileChooser.SnapshotFileType type) {
        int width = component.getWidth();
        int height = component.getHeight();
        switch (type) {
            case JPEG: {
                SnapshotUtilities.exportScreenShotJPEG(component, file, width, height);
                break;
            }
            case PNG: {
                SnapshotUtilities.exportScreenShotPNG(component, file, width, height);
                break;
            }
            case SVG: {
                log.debug("Exporting svg screenshot");
                SnapshotUtilities.exportScreenshotSVG(component, file);
            }
        }
    }

    private static void exportScreenshotSVG2(Component target, File selecteddFile) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(selecteddFile));
            pw.println("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n\n<svg width=\"100%\" height=\"100%\" version=\"1.1\"\nxmlns=\"http://www.w3.org/2000/svg\">");
            Rectangle rectangle = target.getBounds();
            SVGGraphics g2d = new SVGGraphics(pw, rectangle);
            target.paint(g2d);
            pw.print("</svg>");
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void exportScreenshotSVG(Component target, File selectedFile) {
        SnapshotUtilities.setMaxPanelHeight(-1);
        SnapshotUtilities.doSnapshotOffscreen(target, selectedFile);
    }

    private static void exportScreenShotJPEG(Component target, File selectedFile, int width, int height) {
        BufferedImage image = SnapshotUtilities.getDeviceCompatibleImage(width, height);
        Graphics2D g = image.createGraphics();
        target.paintAll(g);
        if (selectedFile != null) {
            if (!selectedFile.getName().toLowerCase().endsWith(".jpeg")) {
                String correctedFilename = selectedFile.getAbsolutePath() + ".jpeg";
                selectedFile = new File(correctedFilename);
            }
            SnapshotUtilities.writeImage(image, selectedFile, "jpeg");
        }
    }

    private static void exportScreenShotPNG(Component target, File selectedFile, int width, int height) {
        BufferedImage image = SnapshotUtilities.getDeviceCompatibleImage(width, height);
        Graphics2D g = image.createGraphics();
        target.paintAll(g);
        if (selectedFile != null) {
            if (!selectedFile.getName().toLowerCase().endsWith(".png")) {
                String correctedFilename = selectedFile.getAbsolutePath() + ".png";
                selectedFile = new File(correctedFilename);
            }
            SnapshotUtilities.writeImage(image, selectedFile, "png");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doSnapshotOffscreen(Component target, File selectedFile) {
        if (!(target instanceof Paintable)) {
            return "Error: target is not paintable";
        }
        try {
            int height;
            IGV.getInstance().setExportingSnapshot(true);
            Rectangle rect = target.getBounds();
            rect.height = height = ((MainPanel)target).getOffscreenImageHeight();
            int dx = rect.x;
            int dy = rect.y;
            rect.x = 0;
            rect.y = 0;
            rect.width -= dx;
            rect.height -= dy;
            Paintable paintable = (Paintable)((Object)target);
            String filenameLowercase = selectedFile.getName().toLowerCase();
            if (filenameLowercase.endsWith(".svg")) {
                log.debug("Getting dom");
                DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                String svgNS = "http://www.w3.org/2000/svg";
                Document document = domImpl.createDocument(svgNS, "svg", null);
                SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                paintable.paintOffscreen(svgGenerator, rect);
                boolean useCSS = true;
                BufferedWriter out = new BufferedWriter(new FileWriter(selectedFile));
                svgGenerator.stream(out, useCSS);
            } else {
                BufferedImage image = SnapshotUtilities.getDeviceCompatibleImage(rect.width, rect.height);
                Graphics2D g = image.createGraphics();
                paintable.paintOffscreen(g, rect);
                if (selectedFile != null) {
                    if (!filenameLowercase.endsWith(".png")) {
                        String correctedFilename = selectedFile.getAbsolutePath() + ".png";
                        selectedFile = new File(correctedFilename);
                    }
                    SnapshotUtilities.writeImage(image, selectedFile, "png");
                }
            }
        }
        catch (Exception e) {
            log.error("Error creating snapshot", e);
            String string = "Error: " + e.toString();
            return string;
        }
        finally {
            IGV.getInstance().setExportingSnapshot(false);
        }
        return "OK";
    }

    private static void writeImage(BufferedImage image, File f, String type) {
        try {
            ImageIO.write((RenderedImage)image, type, f);
        }
        catch (IOException e) {
            log.error("Error creating: " + f.getAbsolutePath(), e);
        }
    }

    public static BufferedImage getDeviceCompatibleImage(int width, int height) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice screenDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicConfiguration = screenDevice.getDefaultConfiguration();
        BufferedImage image = graphicConfiguration.createCompatibleImage(width, height);
        return image;
    }
}

