/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.feature.GisticScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.GisticTrack;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.readers.AsciiLineReader;

public class GisticFileParser {
    private static Logger log = Logger.getLogger(GisticFileParser.class);

    public static GisticTrack loadData(ResourceLocator locator) {
        AsciiLineReader reader = null;
        String nextLine = null;
        try {
            Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
            reader = ParsingUtils.openAsciiReader(locator);
            reader.readLine();
            GisticTrack track = new GisticTrack(locator);
            track.setName(locator.getTrackName());
            ArrayList<GisticScore> scores = new ArrayList<GisticScore>();
            nextLine = reader.readLine();
            while (nextLine != null && nextLine.length() > 0) {
                String[] tokens = nextLine.split("\t");
                GisticScore.Type type = GisticFileParser.getType(tokens[0].trim());
                String chr = genome.getChromosomeAlias(tokens[1].trim());
                int start = -1;
                try {
                    start = Integer.parseInt(tokens[2]);
                }
                catch (NumberFormatException ne) {
                    throw new ParserException("Column 3 must be a numeric value.", reader.getCurrentLineNumber(), nextLine);
                }
                int end = -1;
                try {
                    end = Integer.parseInt(tokens[3]);
                }
                catch (NumberFormatException ne) {
                    throw new ParserException("Column 4 must be a numeric value.", reader.getCurrentLineNumber(), nextLine);
                }
                float qValue = 0.0f;
                try {
                    qValue = Float.parseFloat(tokens[4]);
                }
                catch (NumberFormatException numberFormatException) {
                    qValue = tokens[4].toLowerCase().equals("inf") ? Float.POSITIVE_INFINITY : Float.NaN;
                }
                try {
                    float gScore = Float.parseFloat(tokens[5]);
                    scores.add(new GisticScore(chr, start, end, qValue, gScore, type));
                }
                catch (Exception ex) {
                    log.error("Skipping line: " + nextLine, ex);
                }
                nextLine = reader.readLine();
            }
            if (scores.isEmpty()) {
                throw new RuntimeException("No gistic scores were found.");
            }
            track.setScores(scores);
            GisticFileParser.computeWholeGenome(track, genome);
            GisticTrack gisticTrack = track;
            return gisticTrack;
        }
        catch (FileNotFoundException e) {
            log.error("File not found: " + locator.getPath());
            throw new RuntimeException(e);
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            log.error("Exception when loading: " + locator.getPath(), e);
            if (reader.getCurrentLineNumber() != 0L) {
                throw new ParserException(e.getMessage(), reader.getCurrentLineNumber(), nextLine);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void computeWholeGenome(GisticTrack track, Genome genome) {
        int unit = 1000;
        String chrAll = "All";
        ArrayList<GisticScore> allFeatures = new ArrayList<GisticScore>(1000);
        if (genome == null) {
            throw new RuntimeException("Unknown genome: " + genome.getId());
        }
        genome.getChromosomeNames();
        long offset = 0L;
        for (String chr : genome.getChromosomeNames()) {
            List<GisticScore> delScores;
            int chrLength = genome.getChromosome(chr).getLength();
            int chrStart = (int)(offset / (long)unit);
            allFeatures.add(new GisticScore(chrAll, chrStart, chrStart, 0.0f, 0.0f, GisticScore.Type.AMP));
            allFeatures.add(new GisticScore(chrAll, chrStart, chrStart, 0.0f, 0.0f, GisticScore.Type.DEL));
            List<GisticScore> ampScores = track.getAmpScores(chr);
            if (ampScores != null) {
                for (GisticScore m : ampScores) {
                    int start = (int)((offset + (long)m.getStart()) / (long)unit);
                    int end = (int)((offset + (long)m.getEnd()) / (long)unit);
                    allFeatures.add(new GisticScore(chrAll, start, end, (float)m.getQValue(), (float)m.getGScore(), m.getType()));
                }
            }
            if ((delScores = track.getDelScores(chr)) != null) {
                for (GisticScore m : delScores) {
                    int start = (int)((offset + (long)m.getStart()) / (long)unit);
                    int end = (int)((offset + (long)m.getEnd()) / (long)unit);
                    allFeatures.add(new GisticScore(chrAll, start, end, (float)m.getQValue(), (float)m.getGScore(), m.getType()));
                }
            }
            offset += (long)chrLength;
        }
        track.setScores(allFeatures);
    }

    static GisticScore.Type getType(String typeString) {
        if (typeString.toUpperCase().equals("AMP")) {
            return GisticScore.Type.AMP;
        }
        if (typeString.toUpperCase().equals("DEL")) {
            return GisticScore.Type.DEL;
        }
        throw new IllegalArgumentException("Unkown score type: " + typeString);
    }
}

