/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.CachingFeatureReader;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.feature.tribble.VCFWrapperCodec;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.RuntimeUtils;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureReader;

public class TribbleFeatureSource
implements FeatureSource {
    CachingFeatureReader reader;
    DataSource coverageSource;
    boolean isVCF;
    Genome genome;
    Map<String, String> chrNameMap = new HashMap<String, String>();
    private int featureWindowSize;
    Object header;
    Class featureClass;

    public TribbleFeatureSource(String path, Genome genome) throws IOException {
        FeatureCodec codec = CodecFactory.getCodec(path, genome);
        this.genome = genome;
        this.isVCF = codec.getClass() == VCFWrapperCodec.class;
        this.featureClass = codec.getFeatureType();
        AbstractFeatureReader basicReader = AbstractFeatureReader.getFeatureReader(path, codec, true);
        this.header = basicReader.getHeader();
        this.initFeatureWindowSize(basicReader);
        this.reader = new CachingFeatureReader(basicReader, 5, this.getFeatureWindowSize());
        this.init();
        this.initCoverageSource(path + ".tdf");
    }

    private void initCoverageSource(String covPath) {
        if (ParsingUtils.pathExists(covPath)) {
            TDFReader reader = TDFReader.getReader(covPath);
            this.coverageSource = new TDFDataSource(reader, 0, "", this.genome);
        }
    }

    private void init() {
        List<String> seqNames;
        if (this.genome != null && (seqNames = this.reader.getSequenceNames()) != null) {
            for (String seqName : seqNames) {
                String igvChr = this.genome.getChromosomeAlias(seqName);
                if (igvChr == null || igvChr.equals(seqName)) continue;
                this.chrNameMap.put(igvChr, seqName);
            }
        }
    }

    public Class getFeatureClass() {
        return this.featureClass;
    }

    public CloseableTribbleIterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
        String seqName = this.chrNameMap.get(chr);
        if (seqName == null) {
            seqName = chr;
        }
        return this.reader.query(seqName, start, end);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return this.coverageSource == null ? null : this.coverageSource.getSummaryScoresForRange(chr, start, end, zoom);
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureWindowSize;
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.featureWindowSize = size;
        this.reader.setBinSize(size);
    }

    public Object getHeader() {
        return this.header;
    }

    private void initFeatureWindowSize(FeatureReader reader) {
        CloseableTribbleIterator iter = null;
        try {
            double mem = RuntimeUtils.getAvailableMemory();
            iter = reader.iterator();
            if (iter.hasNext()) {
                Feature firstFeature;
                int nSamples = this.isVCF ? 100 : 1000;
                Feature lastFeature = firstFeature = (Feature)iter.next();
                String chr = firstFeature.getChr();
                int n = 1;
                long len = 0L;
                while (iter.hasNext() && n < nSamples) {
                    Feature f = (Feature)iter.next();
                    if (f == null) continue;
                    ++n;
                    if (f.getChr().equals(chr)) {
                        lastFeature = f;
                        continue;
                    }
                    len += (long)(lastFeature.getEnd() - firstFeature.getStart() + 1);
                    firstFeature = f;
                    lastFeature = f;
                    chr = f.getChr();
                }
                double dMem = mem - (double)RuntimeUtils.getAvailableMemory();
                double bytesPerFeature = Math.max(100.0, dMem / (double)n);
                double featuresPerBase = (double)n / (double)(len += (long)(lastFeature.getEnd() - firstFeature.getStart() + 1));
                double targetBinMemory = 2.0E7;
                int maxBinSize = this.isVCF ? 1000000 : Integer.MAX_VALUE;
                int bs = Math.min(maxBinSize, (int)(targetBinMemory / (bytesPerFeature * featuresPerBase)));
                this.featureWindowSize = Math.max(1000000, bs);
            } else {
                this.featureWindowSize = Integer.MAX_VALUE;
            }
        }
        catch (IOException e) {
            this.featureWindowSize = 1000000;
        }
    }
}

