/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.log4j.Logger;
import org.broad.igv.util.ParsingUtils;

public class CompressionUtils {
    private static Logger log = Logger.getLogger(CompressionUtils.class);

    public static byte[] decompress(byte[] data) {
        return CompressionUtils.decompress(data, data.length * 4);
    }

    public static byte[] decompress(byte[] data, int uncompressedChunkSize) {
        int rem = data.length;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(uncompressedChunkSize);
        byte[] outbuf = new byte[uncompressedChunkSize];
        Inflater decompressor = new Inflater();
        decompressor.setInput(data);
        while (rem > 0) {
            if (decompressor.finished()) {
                decompressor = new Inflater();
                int offset = data.length - rem;
                decompressor.setInput(data, offset, rem);
            }
            try {
                int count = decompressor.inflate(outbuf, 0, outbuf.length);
                rem = decompressor.getRemaining();
                bos.write(outbuf, 0, count);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static byte[] compress(byte[] data) {
        Deflater compressor = new Deflater();
        compressor.setLevel(-1);
        compressor.setInput(data);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            log.error("Error clossing ByteArrayOutputStream", e);
        }
        byte[] compressedData = bos.toByteArray();
        return compressedData;
    }

    public static byte[] compress(byte[] data, int chunkSize) {
        int sz;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        for (int bytesRemaining = data.length; bytesRemaining > 0; bytesRemaining -= sz) {
            sz = Math.min(bytesRemaining, chunkSize);
            int position = data.length - bytesRemaining;
            byte[] chunk = new byte[sz];
            System.arraycopy(data, position, chunk, 0, sz);
            byte[] compressedChunk = CompressionUtils.compress(chunk);
            bos.write(compressedChunk, 0, compressedChunk.length);
        }
        byte[] compressedData = bos.toByteArray();
        return compressedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ungzipFile(String srcPath, String destPath) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        if (destPath == null) {
            if (srcPath.endsWith(".gz")) {
                destPath = srcPath.substring(0, srcPath.length() - ".gz".length());
            } else {
                throw new IllegalArgumentException(srcPath + " does not have a gzip extension and destPath is null. Don't know where to write out");
            }
        }
        try {
            inputStream = ParsingUtils.openInputStream(srcPath);
            outputStream = new FileOutputStream(destPath, false);
            int buffersize = 4096;
            byte[] buffer = new byte[buffersize];
            int len = inputStream.read(buffer);
            while (len > 0) {
                outputStream.write(buffer, 0, len);
                len = inputStream.read(buffer);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return destPath;
    }
}

