/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.Collection;
import java.util.Iterator;

public class SyncCollection
implements Collection {
    protected final Collection c_;
    protected final Sync rd_;
    protected final Sync wr_;
    protected final SynchronizedLong syncFailures_ = new SynchronizedLong(0L);

    public SyncCollection(Collection collection, Sync sync) {
        this(collection, sync, sync);
    }

    public SyncCollection(Collection collection, ReadWriteLock readWriteLock) {
        this(collection, readWriteLock.readLock(), readWriteLock.writeLock());
    }

    public SyncCollection(Collection collection, Sync sync, Sync sync2) {
        this.c_ = collection;
        this.rd_ = sync;
        this.wr_ = sync2;
    }

    public Sync readerSync() {
        return this.rd_;
    }

    public Sync writerSync() {
        return this.wr_;
    }

    public long syncFailures() {
        return this.syncFailures_.get();
    }

    protected boolean beforeRead() {
        try {
            this.rd_.acquire();
            return false;
        }
        catch (InterruptedException interruptedException) {
            this.syncFailures_.increment();
            return true;
        }
    }

    protected void afterRead(boolean bl) {
        if (bl) {
            Thread.currentThread().interrupt();
        } else {
            this.rd_.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        boolean bl = this.beforeRead();
        try {
            int n = this.c_.size();
            return n;
        }
        finally {
            this.afterRead(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean bl = this.beforeRead();
        try {
            boolean bl2 = this.c_.isEmpty();
            return bl2;
        }
        finally {
            this.afterRead(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        boolean bl = this.beforeRead();
        try {
            boolean bl2 = this.c_.contains(object);
            return bl2;
        }
        finally {
            this.afterRead(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        boolean bl = this.beforeRead();
        try {
            Object[] objectArray = this.c_.toArray();
            return objectArray;
        }
        finally {
            this.afterRead(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] objectArray) {
        boolean bl = this.beforeRead();
        try {
            Object[] objectArray2 = this.c_.toArray(objectArray);
            return objectArray2;
        }
        finally {
            this.afterRead(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        boolean bl = this.beforeRead();
        try {
            boolean bl2 = this.c_.containsAll(collection);
            return bl2;
        }
        finally {
            this.afterRead(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.add(object);
            this.wr_.release();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.remove(object);
            this.wr_.release();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.addAll(collection);
            this.wr_.release();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.removeAll(collection);
            this.wr_.release();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection collection) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.retainAll(collection);
            this.wr_.release();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.wr_.acquire();
            try {
                this.c_.clear();
            }
            finally {
                this.wr_.release();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator unprotectedIterator() {
        boolean bl = this.beforeRead();
        try {
            Iterator iterator = this.c_.iterator();
            return iterator;
        }
        finally {
            this.afterRead(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        boolean bl = this.beforeRead();
        try {
            SyncCollectionIterator syncCollectionIterator = new SyncCollectionIterator(this.c_.iterator());
            return syncCollectionIterator;
        }
        finally {
            this.afterRead(bl);
        }
    }

    public class SyncCollectionIterator
    implements Iterator {
        protected final Iterator baseIterator_;

        SyncCollectionIterator(Iterator iterator) {
            this.baseIterator_ = iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            boolean bl = SyncCollection.this.beforeRead();
            try {
                boolean bl2 = this.baseIterator_.hasNext();
                return bl2;
            }
            finally {
                SyncCollection.this.afterRead(bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            boolean bl = SyncCollection.this.beforeRead();
            try {
                Object e = this.baseIterator_.next();
                return e;
            }
            finally {
                SyncCollection.this.afterRead(bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            try {
                SyncCollection.this.wr_.acquire();
                try {
                    this.baseIterator_.remove();
                }
                finally {
                    SyncCollection.this.wr_.release();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }
}

