/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;
import org.apache.commons.math.linear.RealMatrix;
import org.broad.igv.hic.HiC;
import org.broad.igv.hic.HiCColorScale;
import org.broad.igv.hic.MainWindow;
import org.broad.igv.hic.ObservedColorScale;
import org.broad.igv.hic.data.Block;
import org.broad.igv.hic.data.ContactRecord;
import org.broad.igv.hic.data.DensityFunction;
import org.broad.igv.hic.data.MatrixZoomData;
import org.broad.igv.renderer.ColorScale;

public class HeatmapRenderer {
    HiC hic;
    MainWindow mainWindow;
    private ObservedColorScale observedColorScale;
    private ColorScale oeColorScale;
    private ColorScale pearsonColorScale;

    public HeatmapRenderer(MainWindow mainWindow, HiC hic) {
        this.mainWindow = mainWindow;
        this.hic = hic;
        int initialMaxCount = 50;
        this.observedColorScale = new ObservedColorScale();
        this.observedColorScale.setMaxCount(initialMaxCount);
        this.observedColorScale.setBackground(Color.white);
        this.oeColorScale = new HiCColorScale();
        this.pearsonColorScale = new HiCColorScale();
    }

    public void render(int originX, int originY, int width, int height, MatrixZoomData zd, MainWindow.DisplayOption displayOption, Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        int chr1 = zd.getChr1();
        int chr2 = zd.getChr2();
        int maxX = originX + width;
        int maxY = originY + height;
        int x = originX;
        int y = originY;
        boolean isWholeGenome = zd.getChr1() == 0 && zd.getChr2() == 0;
        boolean sameChr = chr1 == chr2;
        double binSizeMB = (double)zd.getBinSize() / (isWholeGenome ? 1000.0 : 1000000.0);
        if (sameChr) {
            if (x > y) {
                x = originY;
                y = originX;
            }
            if (maxX > maxY) {
                int tmp = maxX;
                maxX = maxY;
                maxY = tmp;
            }
        }
        ColorScale colorScale = this.getColorScale();
        if (displayOption == MainWindow.DisplayOption.PEARSON) {
            RealMatrix pearsonsMatrix = zd.getPearsons();
            if (pearsonsMatrix != null) {
                ((HiCColorScale)colorScale).setMin((float)zd.getPearsonsMin());
                ((HiCColorScale)colorScale).setMax((float)zd.getPearsonsMax());
                this.renderMatrix(originX, originY, pearsonsMatrix, colorScale, g, zd.getZoom());
            }
        } else {
            DensityFunction df = null;
            if (displayOption == MainWindow.DisplayOption.OE) {
                df = this.hic.getDensityFunction(zd.getZoom());
            }
            List<Block> blocks = zd.getBlocksOverlapping(x, y, maxX, maxY);
            for (Block b : blocks) {
                this.renderBlock(originX, originY, chr1, chr2, binSizeMB, b, colorScale, df, g);
            }
        }
    }

    private ColorScale getColorScale() {
        switch (this.hic.getDisplayOption()) {
            case OE: {
                return this.oeColorScale;
            }
            case PEARSON: {
                return this.pearsonColorScale;
            }
        }
        return this.observedColorScale;
    }

    private void renderBlock(int originX, int originY, int chr1, int chr2, double binSizeMB, Block b, ColorScale colorScale, DensityFunction df, Graphics2D g) {
        MainWindow.DisplayOption displayOption = this.hic.getDisplayOption();
        double binSizeMB2 = binSizeMB * binSizeMB;
        boolean sameChr = chr1 == chr2;
        ContactRecord[] recs = b.getContactRecords();
        if (recs != null) {
            for (int i = 0; i < recs.length; ++i) {
                double score;
                ContactRecord rec = recs[i];
                Color color = null;
                if (displayOption == MainWindow.DisplayOption.OE && df != null) {
                    int x = rec.getX();
                    int y = rec.getY();
                    int dist = Math.abs(x - y);
                    double expected = df.getDensity(chr1, dist);
                    score = (double)rec.getCounts() / expected;
                    score = Math.log10(score);
                } else {
                    score = (double)rec.getCounts() / binSizeMB2;
                }
                color = colorScale.getColor((float)score);
                int px = rec.getX() - originX;
                int py = rec.getY() - originY;
                g.setColor(color);
                if (px > -1 && py > -1) {
                    g.fillRect(px, py, 1, 1);
                }
                if (!sameChr || rec.getX() == rec.getY()) continue;
                px = rec.getY() - originX;
                py = rec.getX() - originY;
                if (px <= -1 || py <= -1) continue;
                g.fillRect(px, py, 1, 1);
            }
        }
    }

    private void renderMatrix(int originX, int originY, RealMatrix rm, ColorScale colorScale, Graphics g, int zoomLevel) {
        int nBinsX = rm.getColumnDimension();
        int nBinsY = rm.getRowDimension();
        for (int i = 0; i < nBinsX; ++i) {
            for (int j = 0; j < nBinsY; ++j) {
                double score = rm.getEntry(i, j);
                Color color = score == 0.0 ? Color.black : colorScale.getColor((float)score);
                int px = i - originX;
                int py = j - originY;
                g.setColor(color);
                g.fillRect(px, py, 1, 1);
                if (i == j) continue;
                px = j - originX;
                py = i - originY;
                g.fillRect(px, py, 1, 1);
            }
        }
    }

    public void setObservedRange(int min, int max) {
        this.observedColorScale.setRange(min, max);
    }
}

