/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.expression;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.exceptions.LoadResourceFromServerException;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.tribble.readers.AsciiLineReader;

public class ProbeToLocusMap {
    public static final String SERVER_URL = "http://www.broadinstitute.org";
    private static Logger log = Logger.getLogger(ProbeToLocusMap.class);
    private static String affyGenesMappingURL = "http://www.broadinstitute.org/igvdata/probes/affy/affy_probe_gene_mapping.txt.gz";
    private static String affyHumanMappingURL = "http://www.broadinstitute.org/igvdata/probes/affy/affy_human_mappings.txt.gz";
    private static String affyMouseMappingURL = "http://www.broadinstitute.org/igvdata/probes/affy/affy_mouse_mappings.txt.gz";
    private static String affyOtherMappingURL = "http://www.broadinstitute.org/igvdata/probes/affy/affy_other_mappings.txt.gz";
    private static String agilentGenesMappingURL = "http://www.broadinstitute.org/igvdata/probes/agilent/agilent_probe_gene_mapping.txt.gz";
    private static String agilentHumanMappingURL = "http://www.broadinstitute.org/igvdata/probes/agilent/agilent_human_mappings.txt.gz";
    private static String agilentMouseMappingURL = "http://www.broadinstitute.org/igvdata/probes/agilent/agilent_mouse_mappings.txt.gz";
    private static String agilentOtherMappingURL = "http://www.broadinstitute.org/igvdata/probes/agilent/agilent_other_mappings.txt.gz";
    private static String illuminaMappingURL = "http://www.broadinstitute.org/igvdata/probes/illumina/illumina_allMappings.txt.gz";
    private static String illuminaGenesMappingURL = "http://www.broadinstitute.org/igvdata/probes/illumina/illumina_probe_gene_mapping.txt.gz";
    private static String methylationGeneMappingURL = "http://www.broadinstitute.org/igvdata/probes/meth/methylation_pobeToGene.tab.gz";
    private static String methylationLociMappingURL = "http://www.broadinstitute.org/igvdata/probes/meth/methylation_probeToLoci.mappings.txt.gz";
    private static ProbeToLocusMap instance;
    private Map<String, Map<String, String[]>> probeMaps = new HashMap<String, Map<String, String[]>>();
    private MappingUrlCache mappingUrlCache = new MappingUrlCache();

    public static synchronized ProbeToLocusMap getInstance() {
        if (instance == null) {
            instance = new ProbeToLocusMap();
        }
        return instance;
    }

    public void clearProbeMappings() {
        if (this.probeMaps != null) {
            this.probeMaps.clear();
        }
        if (this.mappingUrlCache != null) {
            this.mappingUrlCache.clear();
        }
    }

    public void loadMapping(String urlString, Map<String, String[]> map) {
        AsciiLineReader bufReader = null;
        InputStream is = null;
        try {
            HttpUtils.getInstance();
            if (HttpUtils.isURL(urlString)) {
                URL url = new URL(urlString);
                is = HttpUtils.getInstance().openConnectionStream(url);
            } else {
                is = new FileInputStream(urlString);
            }
            if (urlString.endsWith("gz")) {
                is = new GZIPInputStream(is);
            }
            bufReader = new AsciiLineReader(is);
            this.loadMapping(bufReader, map);
        }
        catch (Exception e) {
            log.error("Error loading probe mapping", e);
            throw new LoadResourceFromServerException(e.getMessage(), urlString, e.getClass().getSimpleName());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("Error closing probe mapping stream", e);
                }
            }
        }
    }

    public void loadMapping(AsciiLineReader bufReader, Map<String, String[]> map) throws IOException {
        String line;
        while ((line = bufReader.readLine()) != null) {
            String[] result = Globals.tabPattern.split(line);
            int nTokens = result.length;
            if (nTokens != 2) continue;
            String[] genes = result[1].split("///");
            map.put(result[0].trim(), genes);
        }
    }

    public String getMappingURL(String genomeId, Platform platform) {
        if (platform == Platform.unknown) {
            return null;
        }
        String mappingUrl = this.mappingUrlCache.getMappingUrl(genomeId, platform);
        if (mappingUrl == null) {
            boolean hasLociMapping;
            boolean mapToGenes = PreferenceManager.getInstance().getAsBoolean("PROBE_MAPPING_KEY");
            if (!mapToGenes && !(hasLociMapping = ProbeToLocusMap.checkForLociMapping(platform, genomeId))) {
                MessageUtils.showMessage("<html>" + platform.toString() + " probe locations are not available for the selected genome " + " (" + genomeId + "). <br>Expression data will be mapped to gene locations.");
                mapToGenes = true;
            }
            if (platform == Platform.Affymetrix) {
                mappingUrl = mapToGenes ? affyGenesMappingURL : (genomeId.startsWith("hg") ? affyHumanMappingURL : (genomeId.startsWith("mm") ? affyMouseMappingURL : affyOtherMappingURL));
            } else if (platform == Platform.Agilient) {
                mappingUrl = mapToGenes ? agilentGenesMappingURL : (genomeId.startsWith("hg") ? agilentHumanMappingURL : (genomeId.startsWith("mm") ? agilentMouseMappingURL : agilentOtherMappingURL));
            } else if (platform == Platform.Illumina) {
                mappingUrl = mapToGenes ? illuminaGenesMappingURL : illuminaMappingURL;
            } else if (platform == Platform.Methylation) {
                mappingUrl = mapToGenes ? methylationGeneMappingURL : methylationLociMappingURL;
            } else {
                return null;
            }
            this.mappingUrlCache.put(genomeId, platform, mappingUrl);
        }
        return mappingUrl;
    }

    public static Platform getPlatform(String probeId) {
        if (probeId.endsWith("_at") || probeId.endsWith("_st")) {
            return Platform.Affymetrix;
        }
        if (probeId.startsWith("A_")) {
            return Platform.Agilient;
        }
        if (probeId.startsWith("ILMN_") || probeId.startsWith("GI_") || probeId.startsWith("NM_") || probeId.startsWith("XM_")) {
            return Platform.Illumina;
        }
        if (probeId.startsWith("cg")) {
            return Platform.Methylation;
        }
        return Platform.unknown;
    }

    private static boolean checkForLociMapping(Platform platform, String genomeId) {
        boolean hasLociMapping = true;
        if (genomeId.startsWith("hg") && !genomeId.equals("hg18")) {
            hasLociMapping = false;
        } else if (genomeId.startsWith("mm")) {
            switch (platform) {
                case Affymetrix: {
                    if (genomeId.equals("mm9")) break;
                    hasLociMapping = false;
                    break;
                }
                case Agilient: {
                    if (genomeId.equals("mm5")) break;
                    hasLociMapping = false;
                    break;
                }
                case Illumina: {
                    if (genomeId.equals("mm8")) break;
                    hasLociMapping = false;
                }
            }
        }
        return hasLociMapping;
    }

    public String[] getLociForProbe(String probeId, String genomeId) {
        Platform platform = ProbeToLocusMap.getPlatform(probeId);
        if (platform == Platform.unknown) {
            return null;
        }
        String mappingURL = this.getMappingURL(genomeId, platform);
        if (mappingURL == null) {
            return null;
        }
        Map<String, String[]> pMap = this.probeMaps.get(mappingURL);
        if (pMap == null) {
            pMap = new HashMap<String, String[]>(500000);
            this.loadMapping(mappingURL, pMap);
            this.probeMaps.put(mappingURL, pMap);
        }
        if (log.isDebugEnabled() && pMap == null) {
            log.debug("Null probeMap for:" + mappingURL);
        }
        return pMap == null ? null : pMap.get(probeId);
    }

    static class MappingUrlCache {
        Map<Platform, Map<String, String>> cache = new Hashtable<Platform, Map<String, String>>();

        MappingUrlCache() {
        }

        public void clear() {
            this.cache.clear();
        }

        public String getMappingUrl(String genomeId, Platform platform) {
            if (this.cache.containsKey((Object)platform)) {
                Map<String, String> urlMap = this.cache.get((Object)platform);
                return urlMap.get(genomeId);
            }
            return null;
        }

        public void put(String genomeId, Platform platform, String mappingUrl) {
            if (!this.cache.containsKey((Object)platform)) {
                this.cache.put(platform, new Hashtable());
            }
            this.cache.get((Object)platform).put(genomeId, mappingUrl);
        }
    }

    static enum Platform {
        Affymetrix,
        Agilient,
        Illumina,
        Methylation,
        Mirna,
        unknown;

    }
}

