/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.broad.igv.util.HttpUtils;
import org.broad.tribble.util.SeekableStream;

public class SeekableServiceStream
extends SeekableStream {
    static Logger log = Logger.getLogger(SeekableServiceStream.class);
    private static final String WEBSERVICE_URL = "http://www.broadinstitute.org/webservices/igv";
    private static final String CLOUD_GENOME_URL = "http://igv.broadinstitute.org/genomes/seq";
    private static final String CLOUDFRONT_GENOME_URL = "http://igvdata.broadinstitute.org/genomes/seq";
    private static final String BROAD_GENOME_URL = "http://www.broadinstitute.org/igvdata/annotations/seq";
    private static final String BROAD_GENOME_PATH = "/xchip/igv/data/public/annotations/seq";
    private static final String IGV_DATA_HOST = "www.broadinstitute.org";
    private static final String BROAD_DATA_URL = "http://www.broadinstitute.org/igvdata";
    private static final String DATA_PATH = "/xchip/igv/data/public";
    private static final String DATA_HTTP_PATH = "/igvdata";
    private long position = 0L;
    private long contentLength = Long.MAX_VALUE;
    private String dataPath;

    public SeekableServiceStream(URL url) {
        this.dataPath = this.convertPath(url);
    }

    private String convertPath(URL url) {
        String urlString = url.toString();
        if (urlString.startsWith(CLOUD_GENOME_URL)) {
            return urlString.replace(CLOUD_GENOME_URL, BROAD_GENOME_PATH);
        }
        if (urlString.startsWith(CLOUDFRONT_GENOME_URL)) {
            return urlString.replace(CLOUDFRONT_GENOME_URL, BROAD_GENOME_PATH);
        }
        if (urlString.startsWith(BROAD_GENOME_URL)) {
            return urlString.replace(BROAD_GENOME_URL, BROAD_GENOME_PATH);
        }
        return url.getPath().replaceFirst(DATA_HTTP_PATH, DATA_PATH);
    }

    @Override
    public long length() {
        return this.contentLength;
    }

    @Override
    public boolean eof() throws IOException {
        return this.position >= this.contentLength;
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long skip(long n) throws IOException {
        this.position += n;
        return n;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int n;
        if (offset < 0 || length < 0 || offset + length > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        InputStream is = null;
        URL url = new URL("http://www.broadinstitute.org/webservices/igv?method=getRange&file=" + this.dataPath + "&position=" + this.position + "&length=" + length);
        try {
            int count;
            is = HttpUtils.getInstance().openConnectionStream(url);
            for (n = 0; n < length; n += count) {
                count = is.read(buffer, offset + n, length - n);
                if (count >= 0) continue;
                int n2 = n;
                return n2;
            }
            this.position += (long)n;
            count = n;
            return count;
        }
        catch (IOException e) {
            if (e.getMessage().contains("416") || e instanceof EOFException) {
                int n3 = n;
                return n3;
            }
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    public byte[] readBytes(long position, int nBytes) throws IOException {
        this.position = position;
        byte[] buffer = new byte[nBytes];
        this.read(buffer, 0, nBytes);
        return buffer;
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableServiceStream.  Must read in blocks.");
    }
}

