/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.hic.HiCGlobals;
import org.broad.igv.hic.data.Block;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.ContactRecord;
import org.broad.igv.hic.tools.AlignmentPair;
import org.broad.igv.hic.tools.AsciiPairIterator;
import org.broad.igv.hic.tools.BinPairIterator;
import org.broad.igv.hic.tools.DensityCalculation;
import org.broad.igv.hic.tools.PairIterator;
import org.broad.igv.util.CompressionUtils;
import org.broad.tribble.util.LittleEndianOutputStream;

public class Preprocessor {
    int nThreads = 0;
    private List<Chromosome> chromosomes;
    private Map<String, Integer> chromosomeOrdinals;
    private File outputFile;
    private LittleEndianOutputStream fos;
    private long masterIndexPosition;
    private Map<String, IndexEntry> matrixPositions;
    private Map<String, Long> blockIndexPositions;
    private Map<String, IndexEntry[]> blockIndexMap;
    private int countThreshold;
    private boolean diagonalsOnly;
    private boolean loadDensities;
    private Set<String> includedChromosomes;

    public Preprocessor(File outputFile, List<Chromosome> chromosomes) {
        this.outputFile = outputFile;
        this.chromosomes = chromosomes;
        this.matrixPositions = new LinkedHashMap<String, IndexEntry>();
        this.blockIndexPositions = new LinkedHashMap<String, Long>();
        this.blockIndexMap = new LinkedHashMap<String, IndexEntry[]>();
        this.countThreshold = 0;
        this.diagonalsOnly = false;
        this.loadDensities = false;
        this.chromosomeOrdinals = new Hashtable<String, Integer>();
        for (int i = 0; i < chromosomes.size(); ++i) {
            this.chromosomeOrdinals.put(chromosomes.get(i).getName(), i);
        }
    }

    public void setNumberOfThreads(int n) {
        this.nThreads = n;
    }

    public void setCountThreshold(int countThreshold) {
        this.countThreshold = countThreshold;
    }

    public void setDiagonalsOnly(boolean diagonalsOnly) {
        this.diagonalsOnly = diagonalsOnly;
    }

    public void setIncludedChromosomes(Set<String> includedChromosomes) {
        this.includedChromosomes = includedChromosomes;
    }

    public void setLoadDensities(boolean loadDensities) {
        this.loadDensities = loadDensities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preprocess(final List<String> inputFileList) throws IOException {
        try {
            System.out.println("Start preprocess");
            if (this.loadDensities) {
                File densitiesFile = new File(this.outputFile.getPath() + ".densities");
                this.calculateDensities(inputFileList, densitiesFile);
            }
            this.fos = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(this.outputFile)));
            this.fos.writeLong(0L);
            int nChrs = this.chromosomes.size();
            this.fos.writeInt(nChrs);
            for (Chromosome chromosome : this.chromosomes) {
                this.fos.writeString(chromosome.getName());
                this.fos.writeInt(chromosome.getSize());
            }
            int nAttributes = 1;
            this.fos.writeInt(nAttributes);
            this.fos.writeString("Version");
            this.fos.writeString("1");
            ArrayList<Thread> threads = new ArrayList<Thread>();
            final ArrayList<MatrixPP> matrices = new ArrayList<MatrixPP>();
            for (int c1 = 0; c1 < nChrs; ++c1) {
                for (int c2 = c1; c2 < nChrs; ++c2) {
                    if (c1 == 0 && c2 != 0 || c2 == 0 && c1 != 0 || this.diagonalsOnly && c1 != c2) continue;
                    if (this.includedChromosomes != null && c1 != 0) {
                        String c1Name = this.chromosomes.get(c1).getName();
                        String c2Name = this.chromosomes.get(c2).getName();
                        if (!this.includedChromosomes.contains(c1Name) && !this.includedChromosomes.contains(c2Name)) continue;
                    }
                    if (this.nThreads <= 1) {
                        MatrixPP matrix = this.computeMatrix(inputFileList, c1, c2);
                        if (matrix == null) continue;
                        this.writeMatrix(matrix);
                        continue;
                    }
                    final int fc1 = c1;
                    final int fc2 = c2;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                MatrixPP matrix = Preprocessor.this.computeMatrix(inputFileList, fc1, fc2);
                                if (matrix != null) {
                                    matrices.add(matrix);
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    threads.add(new Thread(runnable));
                    if (threads.size() < this.nThreads) continue;
                    this.processThreads(threads, matrices);
                    threads.clear();
                    matrices.clear();
                }
            }
            if (threads.size() > 0) {
                this.processThreads(threads, matrices);
            }
            this.masterIndexPosition = this.fos.getWrittenCount();
            this.writeMasterIndex();
        }
        finally {
            if (this.fos != null) {
                this.fos.close();
            }
        }
        this.updateIndexPositions();
    }

    private void processThreads(List<Thread> threads, List<MatrixPP> matrices) throws IOException {
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (MatrixPP matrix : matrices) {
            this.writeMatrix(matrix);
        }
    }

    private void calculateDensities(List<String> paths, File densitiesFile) throws IOException {
        int[] gridSizeArray = new int[8];
        for (int i = 0; i < 8; ++i) {
            gridSizeArray[i] = HiCGlobals.zoomBinSizes[i];
        }
        DensityCalculation[] calcs = new DensityCalculation[gridSizeArray.length];
        for (int z = 0; z < gridSizeArray.length; ++z) {
            calcs[z] = new DensityCalculation(this.chromosomes, gridSizeArray[z]);
        }
        for (String path : paths) {
            PairIterator iter;
            PairIterator pairIterator = iter = path.endsWith(".bin") ? new BinPairIterator(path) : new AsciiPairIterator(path, this.chromosomeOrdinals);
            while (iter.hasNext()) {
                AlignmentPair pair = iter.next();
                if (pair.getChr1() != pair.getChr2()) continue;
                int dist = Math.abs(pair.getPos1() - pair.getPos2());
                int index = pair.getChr1();
                for (int z = 0; z < gridSizeArray.length; ++z) {
                    calcs[z].addDistance(index, dist);
                }
            }
        }
        for (int z = 0; z < gridSizeArray.length; ++z) {
            calcs[z].computeDensity();
        }
        this.outputDensities(calcs, densitiesFile);
    }

    public MatrixPP computeMatrix(List<String> inputFileList, int c1, int c2) throws IOException {
        boolean isWholeGenome = c1 == 0 && c2 == 0;
        MatrixPP matrix = null;
        if (isWholeGenome) {
            int genomeLength = this.chromosomes.get(0).getSize();
            int binSize = genomeLength / 500;
            matrix = new MatrixPP(c1, c2, binSize);
        } else {
            matrix = new MatrixPP(c1, c2);
        }
        for (String file : inputFileList) {
            PairIterator iter;
            PairIterator pairIterator = iter = file.endsWith(".bin") ? new BinPairIterator(file) : new AsciiPairIterator(file, this.chromosomeOrdinals);
            while (iter.hasNext()) {
                AlignmentPair pair = iter.next();
                int pos1 = pair.getPos1();
                int pos2 = pair.getPos2();
                int chr1 = pair.getChr1();
                int chr2 = pair.getChr2();
                if (isWholeGenome) {
                    pos1 = this.getGenomicPosition(chr1, pos1);
                    pos2 = this.getGenomicPosition(chr2, pos2);
                    Preprocessor.incrementCount(matrix, c1, pos1, c2, pos2);
                    continue;
                }
                if ((c1 != chr1 || c2 != chr2) && (c1 != chr2 || c2 != chr1)) continue;
                Preprocessor.incrementCount(matrix, chr1, pos1, chr2, pos2);
            }
            iter.close();
        }
        matrix.parsingComplete();
        return matrix;
    }

    private int getGenomicPosition(int chr, int pos) {
        long len = 0L;
        for (int i = 1; i < chr; ++i) {
            len += (long)this.chromosomes.get(i).getSize();
        }
        return (int)((len += (long)pos) / 1000L);
    }

    private static void incrementCount(MatrixPP matrix, int chr1, int pos1, int chr2, int pos2) {
        if (chr2 > chr1) {
            int tc2 = chr2;
            int tp2 = pos2;
            chr2 = chr1;
            pos2 = pos1;
            chr1 = tc2;
            pos1 = tp2;
        }
        matrix.incrementCount(pos1, pos2);
        if (chr1 == chr2) {
            int dist = Math.abs(pos1 - pos2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndexPositions() throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.outputFile, "rw");
            raf.getChannel().position(0L);
            BufferedByteWriter buffer = new BufferedByteWriter();
            buffer.putLong(this.masterIndexPosition);
            raf.write(buffer.getBytes());
            for (String key : this.blockIndexPositions.keySet()) {
                long pos = this.blockIndexPositions.get(key);
                IndexEntry[] blockIndex = this.blockIndexMap.get(key);
                if (blockIndex == null) {
                    System.err.println("Missing block index for: " + key);
                    continue;
                }
                raf.getChannel().position(pos);
                buffer = new BufferedByteWriter();
                for (int i = 0; i < blockIndex.length; ++i) {
                    buffer.putInt(blockIndex[i].id);
                    buffer.putLong(blockIndex[i].position);
                    buffer.putInt(blockIndex[i].size);
                }
                raf.write(buffer.getBytes());
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    public void writeMasterIndex() throws IOException {
        BufferedByteWriter buffer = new BufferedByteWriter();
        buffer.putInt(this.matrixPositions.size());
        for (Map.Entry<String, IndexEntry> entry : this.matrixPositions.entrySet()) {
            buffer.putString(entry.getKey());
            buffer.putLong(entry.getValue().position);
            buffer.putInt(entry.getValue().size);
        }
        byte[] bytes = buffer.getBytes();
        this.fos.writeInt(bytes.length);
        this.fos.write(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputDensities(DensityCalculation[] calcs, File outputFile) throws IOException {
        FilterOutputStream os = null;
        try {
            os = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            ((LittleEndianOutputStream)os).writeInt(calcs.length);
            for (int i = 0; i < calcs.length; ++i) {
                calcs[i].outputBinary((LittleEndianOutputStream)os);
            }
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public synchronized void writeMatrix(MatrixPP matrix) throws IOException {
        System.out.println("Start writing matrix: " + matrix.getKey());
        long position = this.fos.getWrittenCount();
        this.fos.writeInt(matrix.getChr1());
        this.fos.writeInt(matrix.getChr2());
        this.fos.writeInt(matrix.getZoomData().length);
        for (MatrixZoomDataPP zd : matrix.getZoomData()) {
            this.writeZoomHeader(zd);
        }
        int size = (int)(this.fos.getWrittenCount() - position);
        this.matrixPositions.put(matrix.getKey(), new IndexEntry(position, size));
        for (MatrixZoomDataPP zd : matrix.getZoomData()) {
            IndexEntry[] blockIndex = this.writeZoomData(zd);
            String blockKey = this.getBlockKey(zd);
            this.blockIndexMap.put(blockKey, blockIndex);
        }
        System.out.println("Done writing matrix: " + matrix.getKey());
    }

    private String getBlockKey(MatrixZoomDataPP zd) {
        return zd.getChr1() + "_" + zd.getChr2() + "_" + zd.getZoom();
    }

    private void writeZoomHeader(MatrixZoomDataPP zd) throws IOException {
        int numberOfBlocks = zd.getBlocks().size();
        this.fos.writeInt(zd.getZoom());
        this.fos.writeInt(zd.getSum());
        this.fos.writeInt(zd.getBinSize());
        this.fos.writeInt(zd.getBlockBinCount());
        this.fos.writeInt(zd.getBlockColumnCount());
        this.fos.writeInt(numberOfBlocks);
        this.blockIndexPositions.put(this.getBlockKey(zd), this.fos.getWrittenCount());
        for (int i = 0; i < numberOfBlocks; ++i) {
            this.fos.writeInt(0);
            this.fos.writeLong(0L);
            this.fos.writeInt(0);
        }
    }

    private IndexEntry[] writeZoomData(MatrixZoomDataPP zd) throws IOException {
        Map<Integer, Block> blocks = zd.getBlocks();
        IndexEntry[] indexEntries = new IndexEntry[blocks.size()];
        int i = 0;
        for (Map.Entry<Integer, Block> entry : blocks.entrySet()) {
            int blockNumber = entry.getKey();
            Block block = entry.getValue();
            long position = this.fos.getWrittenCount();
            this.writeContactRecords(block);
            int size = (int)(this.fos.getWrittenCount() - position);
            indexEntries[i] = new IndexEntry(blockNumber, position, size);
            ++i;
        }
        return indexEntries;
    }

    private void writeContactRecords(Block block) throws IOException {
        int nRecords;
        Collection<ContactRecord> records = block.getContractRecordValues();
        if (this.countThreshold > 0) {
            nRecords = 0;
            for (ContactRecord rec : records) {
                if (rec.getCounts() < this.countThreshold) continue;
                ++nRecords;
            }
        } else {
            nRecords = records.size();
        }
        BufferedByteWriter buffer = new BufferedByteWriter(nRecords * 12);
        buffer.putInt(nRecords);
        for (ContactRecord rec : records) {
            if (rec.getCounts() < this.countThreshold) continue;
            buffer.putInt(rec.getX());
            buffer.putInt(rec.getY());
            buffer.putInt(rec.getCounts());
        }
        byte[] bytes = buffer.getBytes();
        byte[] compressedBytes = CompressionUtils.compress(bytes);
        this.fos.write(compressedBytes);
    }

    class MatrixZoomDataPP {
        private int chr1;
        private int chr2;
        private int sum = 0;
        private int zoom;
        private int binSize;
        private int blockBinCount;
        private int blockColumnCount;
        private LinkedHashMap<Integer, Block> blocks;
        private Map<Integer, IndexEntry> blockIndex;

        int getSum() {
            return this.sum;
        }

        int getBinSize() {
            return this.binSize;
        }

        int getChr1() {
            return this.chr1;
        }

        int getChr2() {
            return this.chr2;
        }

        int getZoom() {
            return this.zoom;
        }

        int getBlockBinCount() {
            return this.blockBinCount;
        }

        int getBlockColumnCount() {
            return this.blockColumnCount;
        }

        Map<Integer, Block> getBlocks() {
            return this.blocks;
        }

        MatrixZoomDataPP(int chr1, int chr2, int binSize, int blockColumnCount, int zoom) {
            this.chr1 = chr1;
            this.chr2 = chr2;
            this.binSize = binSize;
            this.blockColumnCount = blockColumnCount;
            this.zoom = zoom;
            int nBinsX = ((Chromosome)Preprocessor.this.chromosomes.get(chr1)).getSize() / binSize + 1;
            this.blockBinCount = nBinsX / blockColumnCount + 1;
            this.blocks = new LinkedHashMap(blockColumnCount * blockColumnCount);
        }

        public void incrementCount(int pos1, int pos2) {
            ++this.sum;
            int xBin = pos1 / this.getBinSize();
            int yBin = pos2 / this.getBinSize();
            if (this.chr1 == this.chr2) {
                int b1 = Math.min(xBin, yBin);
                int b2 = Math.max(xBin, yBin);
                xBin = b1;
                yBin = b2;
                if (b1 != b2) {
                    ++this.sum;
                }
            }
            int blockCol = xBin / this.getBlockBinCount();
            int blockRow = yBin / this.getBlockBinCount();
            int blockNumber = this.getBlockColumnCount() * blockRow + blockCol;
            Block block = this.blocks.get(blockNumber);
            if (block == null) {
                block = new Block(blockNumber);
                this.blocks.put(blockNumber, block);
            }
            block.incrementCount(xBin, yBin);
        }

        void parsingComplete() {
            for (Block b : this.blocks.values()) {
                b.parsingComplete();
            }
        }
    }

    class MatrixPP {
        private int chr1;
        private int chr2;
        private MatrixZoomDataPP[] zoomData;

        MatrixPP(int chr1, int chr2) {
            this.chr1 = chr1;
            this.chr2 = chr2;
            this.zoomData = new MatrixZoomDataPP[HiCGlobals.zoomBinSizes.length];
            for (int zoom = 0; zoom < HiCGlobals.zoomBinSizes.length; ++zoom) {
                int binSize = HiCGlobals.zoomBinSizes[zoom];
                Chromosome chrom1 = (Chromosome)Preprocessor.this.chromosomes.get(chr1);
                Chromosome chrom2 = (Chromosome)Preprocessor.this.chromosomes.get(chr2);
                int len = Math.max(chrom1.getSize(), chrom2.getSize());
                int nBins = len / binSize;
                int nColumns = Math.max(1, nBins / 500);
                this.zoomData[zoom] = new MatrixZoomDataPP(chr1, chr2, binSize, nColumns, zoom);
            }
        }

        MatrixPP(int chr1, int chr2, int binSize) {
            this.chr1 = chr1;
            this.chr2 = chr2;
            this.zoomData = new MatrixZoomDataPP[1];
            int nBlocks = 1;
            this.zoomData[0] = new MatrixZoomDataPP(chr1, chr2, binSize, nBlocks, 0);
        }

        String generateKey(int chr1, int chr2) {
            return "" + chr1 + "_" + chr2;
        }

        String getKey() {
            return this.generateKey(this.chr1, this.chr2);
        }

        void incrementCount(int pos1, int pos2) {
            for (int i = 0; i < this.zoomData.length; ++i) {
                this.zoomData[i].incrementCount(pos1, pos2);
            }
        }

        void parsingComplete() {
            for (MatrixZoomDataPP zd : this.zoomData) {
                zd.parsingComplete();
            }
        }

        int getChr1() {
            return this.chr1;
        }

        int getChr2() {
            return this.chr2;
        }

        MatrixZoomDataPP[] getZoomData() {
            return this.zoomData;
        }
    }

    public static class IndexEntry {
        int id;
        public long position;
        public int size;

        IndexEntry(int id, long position, int size) {
            this.id = id;
            this.position = position;
            this.size = size;
        }

        public IndexEntry(long position, int size) {
            this.position = position;
            this.size = size;
        }
    }

    public static class BufferedByteWriter {
        ByteArrayOutputStream buffer;
        LittleEndianOutputStream dos;

        public BufferedByteWriter() {
            this(8192);
        }

        public BufferedByteWriter(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Buffer size <= 0");
            }
            this.buffer = new ByteArrayOutputStream(size);
            this.dos = new LittleEndianOutputStream(this.buffer);
        }

        public byte[] getBytes() {
            return this.buffer.toByteArray();
        }

        private void put(byte[] b) throws IOException {
            this.dos.write(b);
        }

        private void put(byte b) throws IOException {
            this.dos.write(b);
        }

        private void putShort(short v) throws IOException {
            this.dos.writeShort(v);
        }

        public void putInt(int v) throws IOException {
            this.dos.writeInt(v);
        }

        public void putDouble(double v) throws IOException {
            this.dos.writeDouble(v);
        }

        public void putLong(long v) throws IOException {
            this.dos.writeLong(v);
        }

        public void putString(String string) throws IOException {
            this.dos.writeString(string);
        }
    }
}

