/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JComponent;
import org.broad.igv.hic.ObservedColorScale;

public class ColorScalePanel
extends JComponent
implements Serializable {
    ObservedColorScale colorScale;

    public ColorScalePanel() {
    }

    public ColorScalePanel(ObservedColorScale colorScale) {
        this.colorScale = colorScale;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.colorScale != null) {
            int nSteps = this.getWidth() - 1;
            if (nSteps <= 0) {
                return;
            }
            float delta = this.colorScale.getMaxCount() / nSteps;
            int xLast = 0;
            for (int n = 1; n < nSteps; ++n) {
                int x = n;
                int dx = x - xLast;
                xLast = x;
                float v = delta * (float)n;
                Color c = this.colorScale.getColor(v);
                graphics.setColor(c);
                graphics.fillRect(x, 0, dx, this.getHeight());
            }
        }
    }
}

