/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.FileDialog;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.ui.IGV;

public class FileDialogUtils {
    public static int LOAD = 0;
    public static int SAVE = 1;

    public static File chooseFile(String title, File initialDirectory, int mode) {
        return FileDialogUtils.chooseFile(title, initialDirectory, null, mode);
    }

    public static File chooseFile(String title) {
        return FileDialogUtils.chooseFile(title, DirectoryManager.getUserDirectory(), null, 0);
    }

    public static File chooseFile(String title, File initialDirectory, File initialFile, int mode) {
        return FileDialogUtils.chooseFile(title, initialDirectory, initialFile, null, 0, mode);
    }

    public static File chooseFileOrDirectory(String title, File initialDirectory, File initialFile, int mode) {
        return FileDialogUtils.chooseFile(title, initialDirectory, initialFile, null, 2, mode);
    }

    private static File chooseFile(String title, File initialDirectory, File initialFile, FilenameFilter filter, int directoriesMode, int mode) {
        if (initialDirectory == null && initialFile != null) {
            initialDirectory = initialFile.getParentFile();
        }
        if (initialFile != null) {
            initialFile = new File(initialFile.getName());
        }
        if (Globals.IS_MAC && directoriesMode != 2) {
            return FileDialogUtils.chooseNative(title, initialDirectory, initialFile, filter, directoriesMode, mode);
        }
        return FileDialogUtils.chooseSwing(title, initialDirectory, initialFile, filter, directoriesMode, mode);
    }

    public static File[] chooseMultiple(String title, File initialDirectory, FilenameFilter filter) {
        boolean approve;
        JFileChooser fileChooser = FileDialogUtils.getJFileChooser(title, initialDirectory, null, filter, 0);
        fileChooser.setMultiSelectionEnabled(true);
        boolean bl = approve = fileChooser.showOpenDialog(IGV.getMainFrame()) == 0;
        if (approve) {
            return fileChooser.getSelectedFiles();
        }
        return null;
    }

    public static File chooseDirectory(String title, File initialDirectory) {
        if (Globals.IS_MAC) {
            return FileDialogUtils.chooseNative(title, initialDirectory, null, null, 1, LOAD);
        }
        return FileDialogUtils.chooseSwing(title, initialDirectory, null, null, 1, LOAD);
    }

    private static File chooseNative(String title, File initialDirectory, File initialFile, FilenameFilter filter, int directoryMode, int mode) {
        boolean directories = 1 == directoryMode;
        System.setProperty("apple.awt.fileDialogForDirectories", String.valueOf(directories));
        FileDialog fd = new FileDialog(IGV.getMainFrame(), title);
        if (initialDirectory != null) {
            fd.setDirectory(initialDirectory.getAbsolutePath());
        }
        if (initialFile != null) {
            fd.setFile(initialFile.getName());
        }
        if (filter != null) {
            fd.setFilenameFilter(filter);
        }
        fd.setModal(true);
        fd.setMode(mode);
        fd.setVisible(true);
        String file = fd.getFile();
        String directory = fd.getDirectory();
        if (file != null && directory != null) {
            if (Globals.IS_MAC && initialFile != null) {
                file = FileDialogUtils.fixMacExtension(initialFile, file);
            }
            return new File(directory, file);
        }
        return null;
    }

    private static File chooseSwing(String title, File initialDirectory, File initialFile, FilenameFilter filter, int directoryMode, int mode) {
        boolean approve;
        JFileChooser fileChooser = FileDialogUtils.getJFileChooser(title, initialDirectory, initialFile, filter, directoryMode);
        if (mode == LOAD) {
            approve = fileChooser.showOpenDialog(IGV.getMainFrame()) == 0;
        } else {
            boolean bl = approve = fileChooser.showSaveDialog(IGV.getMainFrame()) == 0;
        }
        if (approve) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    private static JFileChooser getJFileChooser(String title, File initialDirectory, File initialFile, final FilenameFilter filter, int directoryMode) {
        JFileChooser fileChooser = new JFileChooser();
        if (initialDirectory != null) {
            fileChooser.setCurrentDirectory(initialDirectory);
        }
        if (initialFile != null) {
            fileChooser.setSelectedFile(initialFile);
        }
        if (filter != null) {
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return filter.accept(file.getParentFile(), file.getName());
                }

                @Override
                public String getDescription() {
                    return "";
                }
            });
        }
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(directoryMode);
        return fileChooser;
    }

    private static String fixMacExtension(File initialFile, String fname) {
        if (fname.contains(".")) {
            return fname;
        }
        String initialName = initialFile.getName();
        int idx = initialName.lastIndexOf(".");
        if (idx > 0) {
            String ext = initialName.substring(idx);
            return fname + ext;
        }
        return fname;
    }
}

