/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import com.jidesoft.swing.JideButton;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.broad.igv.hic.ColorRangeDialog;
import org.broad.igv.hic.Context;
import org.broad.igv.hic.EigenvectorTrack;
import org.broad.igv.hic.HeatmapPanel;
import org.broad.igv.hic.HiC;
import org.broad.igv.hic.HiCGlobals;
import org.broad.igv.hic.HiCLayout;
import org.broad.igv.hic.HiCRulerPanel;
import org.broad.igv.hic.ThumbnailPanel;
import org.broad.igv.hic.TrackPanel;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.DatasetReader;
import org.broad.igv.hic.data.DensityFunction;
import org.broad.igv.hic.data.MatrixZoomData;
import org.broad.igv.hic.tools.DensityUtil;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;
import org.broad.tribble.util.SeekableStream;
import slider.RangeSlider;

public class MainWindow
extends JFrame {
    private ExecutorService threadExecutor = Executors.newFixedThreadPool(1);
    HiC hic = new HiC(this);
    private EigenvectorTrack eigenvectorTrack;
    public static Cursor fistCursor;
    public static final int MAX_ZOOM;
    public static final int BIN_PIXEL_WIDTH = 1;
    private boolean showEigenvector = false;
    private boolean showDNAseI = false;
    private JComboBox chrBox1;
    private JComboBox chrBox2;
    private JComboBox displayOptionComboBox;
    private RangeSlider colorRangeSlider;
    private JSlider resolutionSlider;
    private JPanel panel3;
    private JPanel trackPanel;
    private TrackPanel eigenvectorPanel;
    private HiCRulerPanel rulerPanel2;
    private HeatmapPanel heatmapPanel;
    private HiCRulerPanel rulerPanel1;
    private JCheckBoxMenuItem viewEigenvector;
    private ThumbnailPanel thumbnailPanel;
    private JPanel xPlotPanel;
    private JPanel yPlotPanel;

    public static void main(String[] args) throws IOException {
        MainWindow mainWindow = new MainWindow();
        mainWindow.setVisible(true);
        mainWindow.setDefaultCloseOperation(3);
    }

    public MainWindow() throws IOException {
        this.initComponents();
        this.createCursors();
        this.pack();
        DropTarget target = new DropTarget(this, new FileDropTargetListener());
        this.setDropTarget(target);
        this.colorRangeSlider.setUpperValue(1200);
    }

    public void createCursors() {
        BufferedImage handImage = new BufferedImage(32, 32, 2);
        Graphics2D g = handImage.createGraphics();
        g.setComposite(AlphaComposite.getInstance(1, 0.0f));
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, 32.0, 32.0);
        g.fill(rect);
        g = handImage.createGraphics();
        g.drawImage(IconFactory.getInstance().getIcon(IconFactory.IconID.FIST).getImage(), 0, 0, null);
        fistCursor = this.getToolkit().createCustomCursor(handImage, new Point(8, 6), "Move");
    }

    public HeatmapPanel getHeatmapPanel() {
        return this.heatmapPanel;
    }

    public void updateZoom(int newZoom) {
        this.resolutionSlider.setValue(newZoom);
        this.updateEigenvectorTrack();
    }

    public void setChromosomes(Chromosome[] chromosomes) {
        this.hic.setChromosomes(chromosomes);
        int[] chromosomeBoundaries = new int[chromosomes.length - 1];
        long bound = 0L;
        for (int i = 1; i < chromosomes.length; ++i) {
            Chromosome c = chromosomes[i];
            chromosomeBoundaries[i - 1] = (int)(bound += (long)(c.getSize() / 1000));
        }
        this.heatmapPanel.setChromosomeBoundaries(chromosomeBoundaries);
    }

    public void setSelectedChromosomes(Chromosome xChrom, Chromosome yChrom) {
        this.chrBox1.setSelectedIndex(yChrom.getIndex());
        this.chrBox2.setSelectedIndex(xChrom.getIndex());
        this.refreshChromosomes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String file) throws IOException {
        if (file.endsWith("hic")) {
            SeekableStream ss = IGVSeekableStreamFactory.getStreamFor(file);
            this.hic.dataset = new DatasetReader(ss).read();
            this.setChromosomes(this.hic.dataset.getChromosomes());
            this.chrBox1.setModel(new DefaultComboBoxModel<Chromosome>(this.hic.getChromosomes()));
            this.chrBox2.setModel(new DefaultComboBoxModel<Chromosome>(this.hic.getChromosomes()));
            Map<Integer, DensityFunction> zoomToDensityMap = null;
            String densityFile = file + ".densities";
            if (FileUtils.resourceExists(densityFile)) {
                InputStream is = null;
                try {
                    is = ParsingUtils.openInputStream(densityFile);
                    zoomToDensityMap = DensityUtil.readDensities(is);
                    this.displayOptionComboBox.setModel(new DefaultComboBoxModel<DisplayOption>(new DisplayOption[]{DisplayOption.OBSERVED, DisplayOption.OE, DisplayOption.PEARSON}));
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            } else {
                this.displayOptionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{DisplayOption.OBSERVED.toString()}));
                zoomToDensityMap = null;
            }
            this.displayOptionComboBox.setSelectedIndex(0);
            this.setTitle(file);
            this.hic.xContext = null;
            this.hic.yContext = null;
            this.hic.setZoomToDensityMap(zoomToDensityMap);
            this.refreshChromosomes();
        }
    }

    private void refreshChromosomes() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int t2;
                Chromosome chr1 = (Chromosome)MainWindow.this.chrBox1.getSelectedItem();
                Chromosome chr2 = (Chromosome)MainWindow.this.chrBox2.getSelectedItem();
                int t1 = chr1.getIndex();
                if (t1 > (t2 = chr2.getIndex())) {
                    Chromosome tmp = chr2;
                    chr2 = chr1;
                    chr1 = tmp;
                }
                if (chr2.getName().equals("All") || chr2 != MainWindow.this.hic.xContext.getChromosome() || chr1 != MainWindow.this.hic.yContext.getChromosome()) {
                    MainWindow.this.hic.xContext = new Context(chr2);
                    MainWindow.this.hic.yContext = new Context(chr1);
                    MainWindow.this.rulerPanel2.setFrame(MainWindow.this.hic.xContext, HiCRulerPanel.Orientation.HORIZONTAL);
                    MainWindow.this.rulerPanel1.setFrame(MainWindow.this.hic.yContext, HiCRulerPanel.Orientation.VERTICAL);
                    MainWindow.this.hic.matrix = MainWindow.this.hic.dataset.getMatrix(chr1, chr2);
                    if (MainWindow.this.hic.matrix != null) {
                        MainWindow.this.setInitialZoom();
                    }
                }
                if (t1 != t2 || chr2.getName().equals("All") || MainWindow.this.hic.getZoomToDensityMap() == null) {
                    MainWindow.this.viewEigenvector.setEnabled(false);
                    MainWindow.this.displayOptionComboBox.setSelectedIndex(0);
                    MainWindow.this.displayOptionComboBox.setEnabled(false);
                } else {
                    MainWindow.this.viewEigenvector.setEnabled(true);
                    MainWindow.this.displayOptionComboBox.setEnabled(true);
                }
                MainWindow.this.refresh();
            }
        };
        this.executeLongRunningTask(runnable);
    }

    void refresh() {
        this.getHeatmapPanel().clearTileCache();
        this.repaint();
        if (this.hic.matrix != null) {
            MatrixZoomData zd0 = this.hic.matrix.getObservedMatrix(0);
            Image thumbnail = this.heatmapPanel.getThumbnailImage(zd0, this.thumbnailPanel.getWidth(), this.thumbnailPanel.getHeight(), this.hic.getDisplayOption());
            this.thumbnailPanel.setImage(thumbnail);
        }
    }

    private void setInitialZoom() {
        if (this.hic.xContext.getChromosome().getName().equals("All")) {
            this.resolutionSlider.setValue(0);
            this.resolutionSlider.setEnabled(false);
            this.hic.setZoom(0, -1, -1, true);
        } else {
            this.resolutionSlider.setEnabled(true);
            int initialZoom = 1;
            this.resolutionSlider.setValue(initialZoom);
            this.hic.setZoom(initialZoom, -1, -1, true);
        }
    }

    private void refreshButtonActionPerformed(ActionEvent e) {
        this.refreshChromosomes();
    }

    private void loadMenuItemActionPerformed(ActionEvent e) {
        FileDialog dlg = new FileDialog(this);
        dlg.setMode(0);
        dlg.setVisible(true);
        String file = dlg.getFile();
        if (file != null) {
            try {
                File f = new File(dlg.getDirectory(), dlg.getFile());
                this.load(f.getAbsolutePath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void loadFromURLActionPerformed(ActionEvent e) {
        String url = JOptionPane.showInputDialog("Enter URL: ");
        if (url != null) {
            try {
                this.load(url);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void exitActionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    private void colorRangeSliderStateChanged(ChangeEvent e) {
        int min = this.colorRangeSlider.getLowerValue();
        int max = this.colorRangeSlider.getUpperValue();
        this.heatmapPanel.setObservedRange(min, max);
    }

    private void chrBox1ActionPerformed(ActionEvent e) {
        if (this.chrBox1.getSelectedIndex() == 0) {
            this.chrBox2.setSelectedIndex(0);
        }
    }

    private void chrBox2ActionPerformed(ActionEvent e) {
        if (this.chrBox2.getSelectedIndex() == 0) {
            this.chrBox1.setSelectedIndex(0);
        }
    }

    private void displayOptionComboBoxActionPerformed(ActionEvent e) {
        this.hic.setDisplayOption((DisplayOption)((Object)this.displayOptionComboBox.getSelectedItem()));
    }

    private void updateEigenvectorTrack() {
        double[] rv;
        boolean show = this.viewEigenvector.isSelected();
        this.trackPanel.setVisible(show);
        if (show && this.hic.zd != null && (rv = this.hic.getEigenvector(0)) != null) {
            this.updateEigenvectorTrack(rv, this.hic.zd.getBinSize());
        }
    }

    public void updateEigenvectorTrack(double[] eigenvector, double binSize) {
        this.eigenvectorTrack.setData(binSize, eigenvector);
        this.trackPanel.repaint();
    }

    private void getEigenvectorActionPerformed(ActionEvent e) {
        try {
            String number = JOptionPane.showInputDialog("Which eigenvector do you want to see?");
            int num = Integer.parseInt(number) - 1;
            double[] rv = this.hic.getEigenvector(num);
            if (rv != null) {
                String str = "";
                for (int i = 0; i < rv.length; ++i) {
                    str = str + rv[i] + "\n";
                }
                JTextArea textArea = new JTextArea(str, 20, 20);
                textArea.setEditable(false);
                textArea.selectAll();
                JScrollPane pane = new JScrollPane(textArea);
                JFrame frame = new JFrame("Principal Eigenvector");
                frame.getContentPane().add(pane);
                frame.pack();
                frame.setVisible(true);
            } else {
                System.err.println("No densities available for this file.");
            }
        }
        catch (InvalidMatrixException error) {
            JOptionPane.showMessageDialog(this, "Unable to calculate eigenvectors after 30 iterations", "Eigenvector error", 0);
        }
        catch (NumberFormatException error) {
            JOptionPane.showMessageDialog(this, "You must enter a valid number.\n" + error.getMessage(), "Eigenvector error", 0);
        }
    }

    public Future executeLongRunningTask(final Runnable runnable) {
        Callable<Object> wrapper = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Component glassPane = MainWindow.this.getGlassPane();
                glassPane.setCursor(Cursor.getPredefinedCursor(3));
                glassPane.setVisible(true);
                try {
                    runnable.run();
                    String string = "done";
                    return string;
                }
                finally {
                    glassPane.setVisible(false);
                }
            }
        };
        return this.threadExecutor.submit(wrapper);
    }

    private void addPredefinedLoadItems(JMenu fileMenu) {
        JMenuItem loadGM = new JMenuItem("GM cell line (human)");
        loadGM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainWindow.this.heatmapPanel.setObservedRange(0, 100);
                    MainWindow.this.colorRangeSlider.setMaximum(100);
                    MainWindow.this.colorRangeSlider.setMinimum(0);
                    MainWindow.this.colorRangeSlider.setMajorTickSpacing(10);
                    MainWindow.this.hic.reset();
                    MainWindow.this.load("http://www.broadinstitute.org/igvdata/hic/hg18/GM.summary.binned.hic");
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(MainWindow.this, "Error loading data: " + e1.getMessage());
                }
            }
        });
        fileMenu.add(loadGM);
        JMenuItem load562 = new JMenuItem("K562 cell line (human)");
        load562.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainWindow.this.heatmapPanel.setObservedRange(0, 100);
                    MainWindow.this.colorRangeSlider.setMaximum(100);
                    MainWindow.this.colorRangeSlider.setMinimum(0);
                    MainWindow.this.colorRangeSlider.setMajorTickSpacing(10);
                    MainWindow.this.hic.reset();
                    MainWindow.this.load("http://www.broadinstitute.org/igvdata/hic/hg18/K562.summary.binned.hic");
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(MainWindow.this, "Error loading data: " + e1.getMessage());
                }
            }
        });
        fileMenu.add(load562);
        fileMenu.addSeparator();
        JMenuItem loadHindIII = new JMenuItem("HindIII August (human)");
        loadHindIII.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainWindow.this.heatmapPanel.setObservedRange(0, 20);
                    MainWindow.this.colorRangeSlider.setMaximum(50);
                    MainWindow.this.colorRangeSlider.setMajorTickSpacing(10);
                    MainWindow.this.colorRangeSlider.setMinimum(0);
                    MainWindow.this.colorRangeSlider.setUpperValue(20);
                    MainWindow.this.hic.reset();
                    MainWindow.this.load("http://iwww.broadinstitute.org/igvdata/hic/Human_August/Hi-C_HindIII_Human_August.hic");
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(MainWindow.this, "Error loading data: " + e1.getMessage());
                }
            }
        });
        fileMenu.add(loadHindIII);
        JMenuItem loadFeb = new JMenuItem("HiSeq February (human)");
        loadFeb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainWindow.this.heatmapPanel.setObservedRange(0, 20);
                    MainWindow.this.colorRangeSlider.setMaximum(2000);
                    MainWindow.this.colorRangeSlider.setMinimum(0);
                    MainWindow.this.colorRangeSlider.setMajorTickSpacing(100);
                    MainWindow.this.colorRangeSlider.setUpperValue(1500);
                    MainWindow.this.hic.reset();
                    MainWindow.this.load("http://iwww.broadinstitute.org/igvdata/hic/Feb2012/inter_all_v1.hic");
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(MainWindow.this, "Error loading data: " + e1.getMessage());
                }
            }
        });
        fileMenu.add(loadFeb);
        fileMenu.addSeparator();
        JMenuItem loadMar1 = new JMenuItem("Hi-C Elena Human (03/13/2012)");
        loadMar1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainWindow.this.heatmapPanel.setObservedRange(0, 1);
                    MainWindow.this.colorRangeSlider.setMaximum(5);
                    MainWindow.this.colorRangeSlider.setMinimum(0);
                    MainWindow.this.colorRangeSlider.setUpperValue(1);
                    MainWindow.this.colorRangeSlider.setMajorTickSpacing(1);
                    MainWindow.this.hic.reset();
                    MainWindow.this.load("https://iwww.broadinstitute.org/igvdata/hic/Elena_Human_120313.hic");
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(MainWindow.this, "Error loading data: " + e1.getMessage());
                }
            }
        });
        fileMenu.add(loadMar1);
        JMenuItem loadMar2 = new JMenuItem("Hi-C Elena Human (03/16/2012)");
        loadMar2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainWindow.this.heatmapPanel.setObservedRange(0, 1);
                    MainWindow.this.colorRangeSlider.setMaximum(5);
                    MainWindow.this.colorRangeSlider.setMinimum(0);
                    MainWindow.this.colorRangeSlider.setUpperValue(1);
                    MainWindow.this.colorRangeSlider.setMajorTickSpacing(1);
                    MainWindow.this.hic.reset();
                    MainWindow.this.load("https://iwww.broadinstitute.org/igvdata/hic/Elena_Human_120316.hic");
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(MainWindow.this, "Error loading data: " + e1.getMessage());
                }
            }
        });
        fileMenu.add(loadMar2);
        JMenuItem loadCoolAid = new JMenuItem("COOL-AID Elena Mouse (12/2011)");
        loadCoolAid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainWindow.this.heatmapPanel.setObservedRange(0, 1);
                    MainWindow.this.colorRangeSlider.setMaximum(5);
                    MainWindow.this.colorRangeSlider.setMinimum(0);
                    MainWindow.this.colorRangeSlider.setUpperValue(1);
                    MainWindow.this.colorRangeSlider.setMajorTickSpacing(1);
                    MainWindow.this.hic.reset();
                    MainWindow.this.load("https://iwww.broadinstitute.org/igvdata/hic/COOL-AID_Elena_Mouse_December11.hic");
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(MainWindow.this, "Error loading data: " + e1.getMessage());
                }
            }
        });
        fileMenu.add(loadCoolAid);
        fileMenu.addSeparator();
        JMenuItem loadDmelDataset = new JMenuItem("Fly");
        loadDmelDataset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainWindow.this.heatmapPanel.setObservedRange(0, 20000);
                    MainWindow.this.colorRangeSlider.setMaximum(20000);
                    MainWindow.this.colorRangeSlider.setMinimum(0);
                    MainWindow.this.hic.reset();
                    MainWindow.this.load("http://iwww.broadinstitute.org/igvdata/hic/dmel/selected_formatted.hic");
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(MainWindow.this, "Error loading data: " + e1.getMessage());
                }
            }
        });
        fileMenu.add(loadDmelDataset);
        fileMenu.addSeparator();
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel();
        JPanel toolbarPanel = new JPanel();
        JPanel chrSelectionPanel = new JPanel();
        JPanel panel10 = new JPanel();
        JLabel label3 = new JLabel();
        JPanel panel9 = new JPanel();
        JPanel panel2_5 = new JPanel();
        this.trackPanel = new JPanel();
        this.chrBox1 = new JComboBox();
        this.chrBox2 = new JComboBox();
        JideButton refreshButton = new JideButton();
        JPanel displayOptionPanel = new JPanel();
        JPanel panel14 = new JPanel();
        JLabel label4 = new JLabel();
        JPanel panel1 = new JPanel();
        this.displayOptionComboBox = new JComboBox();
        JPanel colorRangePanel = new JPanel();
        JPanel panel11 = new JPanel();
        JLabel colorRangeLabel = new JLabel();
        this.colorRangeSlider = new RangeSlider();
        JLabel resolutionLabel = new JLabel();
        JPanel resolutionPanel = new JPanel();
        JPanel panel12 = new JPanel();
        JPanel panel2 = new JPanel();
        this.resolutionSlider = new JSlider();
        this.panel3 = new JPanel();
        this.rulerPanel2 = new HiCRulerPanel(this.hic);
        this.heatmapPanel = new HeatmapPanel(this, this.hic);
        this.rulerPanel1 = new HiCRulerPanel(this.hic);
        JPanel panel8 = new JPanel();
        this.thumbnailPanel = new ThumbnailPanel(this, this.hic);
        this.xPlotPanel = new JPanel();
        this.yPlotPanel = new JPanel();
        JMenuBar menuBar1 = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenu viewMenu = new JMenu();
        JMenuItem loadFromURL = new JMenuItem();
        JMenuItem getEigenvector = new JMenuItem();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        mainPanel.setLayout(new BorderLayout());
        toolbarPanel.setBorder(null);
        toolbarPanel.setLayout(new GridLayout());
        chrSelectionPanel.setBorder(LineBorder.createGrayLineBorder());
        chrSelectionPanel.setMinimumSize(new Dimension(130, 57));
        chrSelectionPanel.setPreferredSize(new Dimension(130, 57));
        chrSelectionPanel.setLayout(new BorderLayout());
        panel10.setBackground(new Color(204, 204, 204));
        panel10.setLayout(new BorderLayout());
        label3.setText("Chromosomes");
        label3.setHorizontalAlignment(0);
        panel10.add((Component)label3, "Center");
        chrSelectionPanel.add((Component)panel10, "First");
        panel9.setBackground(new Color(238, 238, 238));
        panel9.setLayout(new BoxLayout(panel9, 0));
        this.chrBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"All"}));
        this.chrBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.chrBox1ActionPerformed(e);
            }
        });
        panel9.add(this.chrBox1);
        this.chrBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"All"}));
        this.chrBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.chrBox2ActionPerformed(e);
            }
        });
        panel9.add(this.chrBox2);
        refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh24.gif")));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.refreshButtonActionPerformed(e);
            }
        });
        panel9.add(refreshButton);
        chrSelectionPanel.add((Component)panel9, "Center");
        toolbarPanel.add(chrSelectionPanel);
        displayOptionPanel.setBackground(new Color(238, 238, 238));
        displayOptionPanel.setBorder(LineBorder.createGrayLineBorder());
        displayOptionPanel.setLayout(new BorderLayout());
        panel14.setBackground(new Color(204, 204, 204));
        panel14.setLayout(new BorderLayout());
        label4.setText("Show");
        label4.setHorizontalAlignment(0);
        panel14.add((Component)label4, "Center");
        displayOptionPanel.add((Component)panel14, "First");
        panel1.setBorder(new EmptyBorder(0, 10, 0, 10));
        panel1.setLayout(new GridLayout(1, 0, 20, 0));
        this.displayOptionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{DisplayOption.OBSERVED.toString()}));
        this.displayOptionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.displayOptionComboBoxActionPerformed(e);
            }
        });
        panel1.add(this.displayOptionComboBox);
        displayOptionPanel.add((Component)panel1, "Center");
        toolbarPanel.add(displayOptionPanel);
        colorRangePanel.setBorder(LineBorder.createGrayLineBorder());
        colorRangePanel.setMinimumSize(new Dimension(96, 70));
        colorRangePanel.setPreferredSize(new Dimension(202, 70));
        colorRangePanel.setMaximumSize(new Dimension(32769, 70));
        colorRangePanel.setLayout(new BorderLayout());
        panel11.setBackground(new Color(204, 204, 204));
        panel11.setLayout(new BorderLayout());
        colorRangeLabel.setText("Color Range");
        colorRangeLabel.setHorizontalAlignment(0);
        colorRangeLabel.setToolTipText("Range of color scale in counts per mega-base squared.");
        colorRangeLabel.setHorizontalTextPosition(0);
        colorRangeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ColorRangeDialog rangeDialog = new ColorRangeDialog((Frame)MainWindow.this, MainWindow.this.colorRangeSlider);
                    rangeDialog.setVisible(true);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ColorRangeDialog rangeDialog = new ColorRangeDialog((Frame)MainWindow.this, MainWindow.this.colorRangeSlider);
                rangeDialog.setVisible(true);
            }
        });
        panel11.add((Component)colorRangeLabel, "Center");
        colorRangePanel.add((Component)panel11, "First");
        this.colorRangeSlider.setPaintTicks(true);
        this.colorRangeSlider.setPaintLabels(true);
        this.colorRangeSlider.setLowerValue(0);
        this.colorRangeSlider.setMajorTickSpacing(500);
        this.colorRangeSlider.setMaximumSize(new Dimension(Short.MAX_VALUE, 52));
        this.colorRangeSlider.setPreferredSize(new Dimension(200, 52));
        this.colorRangeSlider.setMinimumSize(new Dimension(36, 52));
        this.colorRangeSlider.setMaximum(2000);
        this.colorRangeSlider.setUpperValue(500);
        this.colorRangeSlider.setMinorTickSpacing(100);
        this.colorRangeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainWindow.this.colorRangeSliderStateChanged(e);
            }
        });
        colorRangePanel.add((Component)this.colorRangeSlider, "Last");
        toolbarPanel.add(colorRangePanel);
        resolutionPanel.setBorder(LineBorder.createGrayLineBorder());
        resolutionPanel.setLayout(new BorderLayout());
        panel12.setBackground(new Color(204, 204, 204));
        panel12.setLayout(new BorderLayout());
        resolutionLabel.setText("Resolution");
        resolutionLabel.setHorizontalAlignment(0);
        resolutionLabel.setBackground(new Color(204, 204, 204));
        panel12.add((Component)resolutionLabel, "Center");
        resolutionPanel.add((Component)panel12, "First");
        panel2.setLayout(new BoxLayout(panel2, 0));
        this.resolutionSlider.setMaximum(8);
        this.resolutionSlider.setMajorTickSpacing(1);
        this.resolutionSlider.setPaintTicks(true);
        this.resolutionSlider.setSnapToTicks(true);
        this.resolutionSlider.setPaintLabels(true);
        this.resolutionSlider.setMinorTickSpacing(1);
        Hashtable<Integer, JLabel> resolutionLabels = new Hashtable<Integer, JLabel>();
        Font f = FontManager.getFont(8);
        for (int i = 0; i < HiCGlobals.zoomLabels.length; ++i) {
            if ((i + 1) % 2 != 0) continue;
            JLabel tickLabel = new JLabel(HiCGlobals.zoomLabels[i]);
            tickLabel.setFont(f);
            ((Dictionary)resolutionLabels).put(i, tickLabel);
        }
        this.resolutionSlider.setLabelTable(resolutionLabels);
        this.resolutionSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!MainWindow.this.resolutionSlider.getValueIsAdjusting()) {
                    int idx = MainWindow.this.resolutionSlider.getValue();
                    idx = Math.max(0, Math.min(idx, MAX_ZOOM));
                    if (MainWindow.this.hic.zd != null && idx == MainWindow.this.hic.zd.getZoom()) {
                        return;
                    }
                    if (MainWindow.this.hic.xContext != null) {
                        int centerLocationX = (int)MainWindow.this.hic.xContext.getChromosomePosition(MainWindow.this.getHeatmapPanel().getWidth() / 2);
                        int centerLocationY = (int)MainWindow.this.hic.yContext.getChromosomePosition(MainWindow.this.getHeatmapPanel().getHeight() / 2);
                        MainWindow.this.hic.setZoom(idx, centerLocationX, centerLocationY, false);
                    }
                }
            }
        });
        panel2.add(this.resolutionSlider);
        resolutionPanel.add((Component)panel2, "Center");
        toolbarPanel.add(resolutionPanel);
        mainPanel.add((Component)toolbarPanel, "North");
        panel2_5.setLayout(new BorderLayout());
        this.trackPanel.setMaximumSize(new Dimension(4000, 50));
        this.trackPanel.setPreferredSize(new Dimension(1, 50));
        this.trackPanel.setMinimumSize(new Dimension(1, 50));
        this.trackPanel.setBorder(null);
        this.trackPanel.setVisible(false);
        this.trackPanel.setLayout(new BoxLayout(this.trackPanel, 1));
        this.eigenvectorPanel = new TrackPanel(this.hic);
        this.eigenvectorPanel.setMaximumSize(new Dimension(4000, 50));
        this.eigenvectorPanel.setPreferredSize(new Dimension(1, 50));
        this.eigenvectorPanel.setMinimumSize(new Dimension(1, 50));
        this.eigenvectorPanel.setBorder(null);
        this.trackPanel.add(this.eigenvectorPanel);
        this.eigenvectorTrack = new EigenvectorTrack("eigen", "Eigenvectors");
        this.eigenvectorPanel.setTrack(this.eigenvectorTrack);
        this.trackPanel.setVisible(true);
        panel2_5.add((Component)this.trackPanel, "North");
        this.panel3.setLayout(new HiCLayout());
        this.rulerPanel2.setMaximumSize(new Dimension(4000, 50));
        this.rulerPanel2.setMinimumSize(new Dimension(1, 50));
        this.rulerPanel2.setPreferredSize(new Dimension(1, 50));
        this.rulerPanel2.setBorder(null);
        panel2_5.add((Component)this.rulerPanel2, "South");
        this.panel3.add((Component)panel2_5, "North");
        this.heatmapPanel.setBorder(LineBorder.createBlackLineBorder());
        this.heatmapPanel.setMaximumSize(new Dimension(500, 500));
        this.heatmapPanel.setMinimumSize(new Dimension(500, 500));
        this.heatmapPanel.setPreferredSize(new Dimension(500, 500));
        this.heatmapPanel.setBackground(new Color(238, 238, 238));
        this.panel3.add((Component)this.heatmapPanel, "Center");
        this.rulerPanel1.setMaximumSize(new Dimension(50, 4000));
        this.rulerPanel1.setPreferredSize(new Dimension(50, 500));
        this.rulerPanel1.setBorder(null);
        this.rulerPanel1.setMinimumSize(new Dimension(50, 1));
        this.panel3.add((Component)this.rulerPanel1, "West");
        panel8.setMaximumSize(new Dimension(120, 100));
        panel8.setBorder(new EmptyBorder(0, 10, 0, 0));
        panel8.setLayout(null);
        this.thumbnailPanel.setMaximumSize(new Dimension(100, 100));
        this.thumbnailPanel.setMinimumSize(new Dimension(100, 100));
        this.thumbnailPanel.setPreferredSize(new Dimension(100, 100));
        this.thumbnailPanel.setBorder(LineBorder.createBlackLineBorder());
        this.thumbnailPanel.setPreferredSize(new Dimension(100, 100));
        panel8.add(this.thumbnailPanel);
        this.thumbnailPanel.setBounds(new Rectangle(new Point(20, 0), this.thumbnailPanel.getPreferredSize()));
        this.xPlotPanel.setPreferredSize(new Dimension(250, 100));
        this.xPlotPanel.setLayout(null);
        panel8.add(this.xPlotPanel);
        this.xPlotPanel.setBounds(10, 100, this.xPlotPanel.getPreferredSize().width, 228);
        this.yPlotPanel.setPreferredSize(new Dimension(250, 100));
        this.yPlotPanel.setLayout(null);
        panel8.add(this.yPlotPanel);
        this.yPlotPanel.setBounds(10, 328, this.yPlotPanel.getPreferredSize().width, 228);
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < panel8.getComponentCount(); ++i) {
            Rectangle bounds = panel8.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = panel8.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        panel8.setMinimumSize(preferredSize);
        panel8.setPreferredSize(preferredSize);
        this.panel3.add((Component)panel8, "East");
        mainPanel.add((Component)this.panel3, "Center");
        contentPane.add((Component)mainPanel, "Center");
        fileMenu.setText("File");
        JMenuItem loadMenuItem = new JMenuItem();
        loadMenuItem.setText("Load...");
        loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.loadMenuItemActionPerformed(e);
            }
        });
        fileMenu.add(loadMenuItem);
        loadFromURL.setText("Load from URL ...");
        loadFromURL.setName("loadFromURL");
        loadFromURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.loadFromURLActionPerformed(e);
            }
        });
        fileMenu.add(loadFromURL);
        fileMenu.addSeparator();
        this.addPredefinedLoadItems(fileMenu);
        JMenuItem saveToImage = new JMenuItem();
        saveToImage.setText("Save to image");
        saveToImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BufferedImage image = (BufferedImage)MainWindow.this.createImage(1000, 1000);
                Graphics2D g = image.createGraphics();
                MainWindow.this.panel3.paint(g);
                JFileChooser fc = new JFileChooser();
                fc.showSaveDialog(null);
                File file = fc.getSelectedFile();
                try {
                    String fmt = "jpg";
                    int ind = file.getName().indexOf(".");
                    if (ind != -1) {
                        String[] strs;
                        String ext = file.getName().substring(ind + 1);
                        for (String aStr : strs = ImageIO.getWriterFormatNames()) {
                            if (!ext.equals(aStr)) continue;
                            fmt = ext;
                        }
                    }
                    ImageIO.write((RenderedImage)image.getSubimage(0, 0, 600, 600), fmt, file);
                }
                catch (IOException ie) {
                    System.err.println("Unable to write " + file + ": " + ie);
                }
            }
        });
        fileMenu.add(saveToImage);
        getEigenvector = new JMenuItem("Get principal eigenvector");
        getEigenvector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.getEigenvectorActionPerformed(e);
            }
        });
        fileMenu.add(getEigenvector);
        JMenuItem exit = new JMenuItem();
        exit.setText("Exit");
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.exitActionPerformed(e);
            }
        });
        fileMenu.add(exit);
        menuBar1.add(fileMenu);
        viewMenu.setText("View");
        this.viewEigenvector = new JCheckBoxMenuItem("Eigenvector track");
        this.viewEigenvector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MainWindow.this.updateEigenvectorTrack();
            }
        });
        this.viewEigenvector.setEnabled(false);
        viewMenu.add(this.viewEigenvector);
        final JCheckBoxMenuItem viewDNAseI = new JCheckBoxMenuItem("DNAseI track");
        viewDNAseI.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MainWindow.this.showDNAseI = viewDNAseI.isSelected();
                if (MainWindow.this.showEigenvector || MainWindow.this.showDNAseI) {
                    MainWindow.this.trackPanel.setVisible(true);
                } else {
                    MainWindow.this.trackPanel.setVisible(false);
                }
            }
        });
        viewDNAseI.setEnabled(false);
        viewMenu.add(viewDNAseI);
        menuBar1.add(viewMenu);
        contentPane.add((Component)menuBar1, "North");
        this.rootPane.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        this.rootPane.getGlassPane().addMouseListener(new MouseAdapter(){});
    }

    static {
        MAX_ZOOM = HiCGlobals.zoomBinSizes.length;
    }

    static enum DisplayOption {
        OBSERVED("Observed"),
        OE("OE"),
        PEARSON("Pearson");

        private String value;

        private DisplayOption(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    class FileDropTargetListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if (!this.isDropAcceptable(event)) {
                event.rejectDrop();
                return;
            }
            event.acceptDrop(1);
            Transferable transferable = event.getTransferable();
            try {
                List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                MainWindow.this.load(((File)files.get(0)).getAbsolutePath());
            }
            catch (Exception e) {
                String obj = null;
                try {
                    obj = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                    HttpUtils.getInstance();
                    if (HttpUtils.isURL(obj)) {
                        MainWindow.this.load(obj);
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            MainWindow.this.repaint();
            event.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent event) {
            return (event.getDropAction() & 3) != 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent event) {
            return (event.getDropAction() & 3) != 0;
        }
    }
}

