/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.broad.igv.hic.Context;
import org.broad.igv.hic.HiC;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.ui.FontManager;

public class HiCRulerPanel
extends JPanel
implements Serializable {
    private static Logger log = Logger.getLogger(HiCRulerPanel.class);
    private HiC hic;
    private Orientation orientation;
    private Font tickFont = FontManager.getFont(1, 9);
    private Font spanFont = FontManager.getFont(1, 12);
    Context frame;

    public HiCRulerPanel() {
    }

    public HiCRulerPanel(HiC hic) {
        this.hic = hic;
    }

    public void setFrame(Context frame, Orientation orientation) {
        this.frame = frame;
        this.orientation = orientation;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        if (this.frame == null) {
            return;
        }
        g.setColor(Color.black);
        AffineTransform t = g2D.getTransform();
        if (this.orientation == Orientation.VERTICAL) {
            AffineTransform rotateTransform = new AffineTransform();
            rotateTransform.quadrantRotate(-1);
            g2D.transform(rotateTransform);
        }
        this.drawTicks(g2D);
        this.drawChr(g2D);
        g2D.setTransform(t);
    }

    private void drawChr(Graphics g) {
        int w = this.isHorizontal() ? this.getWidth() : this.getHeight();
        int h = this.isHorizontal() ? this.getHeight() : this.getWidth();
        g.setFont(this.spanFont);
        Chromosome chromosome = this.frame.getChromosome();
        if (chromosome != null && !chromosome.getName().equals("All")) {
            String rangeString = chromosome.getName();
            int strWidth = g.getFontMetrics().stringWidth(rangeString);
            int strPosition = (w - strWidth) / 2;
            if (!this.isHorizontal()) {
                strPosition = -strPosition;
            }
            int vPos = h - 35;
            g.drawString(rangeString, strPosition, vPos);
        }
    }

    private boolean isHorizontal() {
        return this.orientation == Orientation.HORIZONTAL;
    }

    private void drawTicks(Graphics g) {
        int h;
        int w = this.isHorizontal() ? this.getWidth() : this.getHeight();
        int n = h = this.isHorizontal() ? this.getHeight() : this.getWidth();
        if (w < 50 || this.frame.getScale() == 0.0) {
            return;
        }
        g.setFont(this.tickFont);
        Chromosome chromosome = this.frame.getChromosome();
        if (chromosome == null) {
            return;
        }
        if (chromosome.getName().equals("All")) {
            int x1 = 0;
            Chromosome[] chromosomes = this.hic.getChromosomes();
            int genomeCoord = 0;
            for (int i = 1; i < chromosomes.length; ++i) {
                Chromosome c = chromosomes[i];
                int x2 = this.frame.getScreenPosition(genomeCoord += c.getSize() / 1000);
                int x = (x1 + x2) / 2;
                int strWidth = g.getFontMetrics().stringWidth(c.getName());
                int strPosition = this.isHorizontal() ? x - strWidth / 2 : -x - strWidth / 2;
                g.drawString(c.getName(), strPosition, h - 15);
                int xpos = this.orientation == Orientation.HORIZONTAL ? x2 : -x2;
                g.drawLine(xpos, h - 10, xpos, h - 2);
                x1 = x2;
            }
        } else {
            int range = (int)((double)w * this.frame.getScale());
            TickSpacing ts = HiCRulerPanel.findSpacing(range, false);
            double spacing = ts.getMajorTick();
            int maxX = this.frame.getChromosome().getSize();
            int nTick = (int)((double)this.frame.getOrigin() / spacing) - 1;
            int l = (int)((double)nTick * spacing);
            int x = this.frame.getScreenPosition(l);
            while (l < maxX && x < w) {
                int strPosition;
                l = (int)((double)nTick * spacing);
                x = this.frame.getScreenPosition(l);
                String chrPosition = HiCRulerPanel.formatNumber((double)l / (double)ts.getUnitMultiplier()) + " " + ts.getMajorUnit();
                int strWidth = g.getFontMetrics().stringWidth(chrPosition);
                int n2 = strPosition = this.isHorizontal() ? x - strWidth / 2 : -x - strWidth / 2;
                if (nTick % 2 == 0) {
                    g.drawString(chrPosition, strPosition, h - 15);
                }
                int xpos = this.orientation == Orientation.HORIZONTAL ? x : -x;
                g.drawLine(xpos, h - 10, xpos, h - 2);
                ++nTick;
            }
        }
    }

    public static String formatNumber(double position) {
        DecimalFormat formatter = new DecimalFormat();
        return formatter.format((int)position);
    }

    public static TickSpacing findSpacing(long maxValue, boolean scaleInKB) {
        if (maxValue < 10L) {
            System.out.println("max value = " + maxValue);
            return new TickSpacing(1.0, "bp", 1);
        }
        int nZeroes = (int)Math.log10(maxValue);
        String majorUnit = scaleInKB ? "kb" : "bp";
        int unitMultiplier = 1;
        if (nZeroes > 9) {
            majorUnit = scaleInKB ? "tb" : "gb";
            unitMultiplier = 1000000000;
        }
        if (nZeroes > 6) {
            majorUnit = scaleInKB ? "gb" : "mb";
            unitMultiplier = 1000000;
        } else if (nZeroes > 3) {
            majorUnit = scaleInKB ? "mb" : "kb";
            unitMultiplier = 1000;
        }
        double nMajorTicks = (double)maxValue / Math.pow(10.0, nZeroes - 1);
        if (nMajorTicks < 25.0) {
            return new TickSpacing(Math.pow(10.0, nZeroes - 1), majorUnit, unitMultiplier);
        }
        return new TickSpacing(Math.pow(10.0, nZeroes) / 2.0, majorUnit, unitMultiplier);
    }

    class ClickLink {
        Rectangle region;
        String value;
        String tooltipText;

        ClickLink(Rectangle region, String value, String tooltipText) {
            this.region = region;
            this.value = value;
            this.tooltipText = tooltipText;
        }
    }

    public static class TickSpacing {
        private double majorTick;
        private double minorTick;
        private String majorUnit = "";
        private int unitMultiplier = 1;

        TickSpacing(double majorTick, String majorUnit, int unitMultiplier) {
            this.majorTick = majorTick;
            this.minorTick = majorTick / 10.0;
            this.majorUnit = majorUnit;
            this.unitMultiplier = unitMultiplier;
        }

        public double getMajorTick() {
            return this.majorTick;
        }

        public double getMinorTick() {
            return this.minorTick;
        }

        public String getMajorUnit() {
            return this.majorUnit;
        }

        public void setMajorUnit(String majorUnit) {
            this.majorUnit = majorUnit;
        }

        public int getUnitMultiplier() {
            return this.unitMultiplier;
        }

        public void setUnitMultiplier(int unitMultiplier) {
            this.unitMultiplier = unitMultiplier;
        }
    }

    static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

