/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class HiCLayout
implements LayoutManager2,
Serializable {
    int hgap;
    int vgap;
    Component north;
    Component west;
    Component east;
    Component south;
    Component center;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";

    public HiCLayout() {
        this(0, 0);
    }

    public HiCLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints != null && !(constraints instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (name == null) {
                name = CENTER;
            }
            if (CENTER.equals(name)) {
                this.center = comp;
            } else if (NORTH.equals(name)) {
                this.north = comp;
            } else if (SOUTH.equals(name)) {
                this.south = comp;
            } else if (EAST.equals(name)) {
                this.east = comp;
            } else if (WEST.equals(name)) {
                this.west = comp;
            } else {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (comp == this.center) {
                this.center = null;
            } else if (comp == this.north) {
                this.north = null;
            } else if (comp == this.south) {
                this.south = null;
            } else if (comp == this.east) {
                this.east = null;
            } else if (comp == this.west) {
                this.west = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            Component c = null;
            c = this.getChild(EAST, ltr);
            if (c != null) {
                d = c.getMinimumSize();
                dim.width += d.width + this.hgap;
                dim.height = Math.max(d.height, dim.height);
            }
            if ((c = this.getChild(WEST, ltr)) != null) {
                d = c.getMinimumSize();
                dim.width += d.width + this.hgap;
                dim.height = Math.max(d.height, dim.height);
            }
            if ((c = this.getChild(CENTER, ltr)) != null) {
                d = c.getMinimumSize();
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            }
            if ((c = this.getChild(NORTH, ltr)) != null) {
                d = c.getMinimumSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height + this.vgap;
            }
            if ((c = this.getChild(SOUTH, ltr)) != null) {
                d = c.getMinimumSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height + this.vgap;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            Dimension dim = new Dimension(0, 0);
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            Component c = null;
            c = this.getChild(EAST, ltr);
            if (c != null) {
                d = c.getPreferredSize();
                dim.width += d.width + this.hgap;
                dim.height = Math.max(d.height, dim.height);
            }
            if ((c = this.getChild(WEST, ltr)) != null) {
                d = c.getPreferredSize();
                dim.width += d.width + this.hgap;
                dim.height = Math.max(d.height, dim.height);
            }
            if ((c = this.getChild(CENTER, ltr)) != null) {
                d = c.getPreferredSize();
                dim.width += d.width;
                dim.height = Math.max(d.height, dim.height);
            }
            if ((c = this.getChild(NORTH, ltr)) != null) {
                d = c.getPreferredSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height + this.vgap;
            }
            if ((c = this.getChild(SOUTH, ltr)) != null) {
                d = c.getPreferredSize();
                dim.width = Math.max(d.width, dim.width);
                dim.height += d.height + this.vgap;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d;
            int dy;
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = target.getHeight() - insets.bottom;
            int left = insets.left;
            int right = target.getWidth() - insets.right;
            int dh = bottom - top;
            int dw = right - left;
            int dx = this.west == null ? 0 : this.west.getPreferredSize().width + this.hgap;
            int n = dy = this.north == null ? 0 : this.north.getPreferredSize().height + this.vgap;
            if (this.south != null) {
                dy += this.south.getPreferredSize().height + this.vgap;
            }
            int centerDim = Math.min(dw - dx, dh - dy);
            if (this.north != null) {
                d = this.north.getPreferredSize();
                this.north.setBounds(dx, top, centerDim, d.height);
                top += d.height + this.vgap;
            }
            if (this.west != null) {
                d = this.west.getPreferredSize();
                this.west.setBounds(left, top, d.width, centerDim);
            }
            if (this.center != null) {
                this.center.setBounds(left + this.west.getWidth() + this.hgap, top, centerDim, centerDim);
            }
            if (this.east != null) {
                int xEast = left + this.west.getWidth() + this.hgap + centerDim + this.hgap;
                int wEast = Math.max(0, dw - xEast);
                this.east.setBounds(xEast, top, wEast, centerDim);
            }
            if (this.south != null) {
                int hSouth = Math.max(0, dh - (top += centerDim + this.vgap));
                this.south.setBounds(left, top, dw, hSouth);
            }
        }
    }

    private Component getChild(String key, boolean ltr) {
        Component result = null;
        if (key == NORTH) {
            result = this.north;
        } else if (key == SOUTH) {
            result = this.south;
        } else if (key == WEST) {
            result = this.west;
        } else if (key == EAST) {
            result = this.east;
        } else if (key == CENTER) {
            result = this.center;
        }
        if (result != null && !result.isVisible()) {
            result = null;
        }
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }
}

