/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.modes;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import edu.cornell.med.icb.goby.modes.AbstractCommandLineMode;
import edu.cornell.med.icb.io.ResourceFinder;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericToolsDriver
extends AbstractCommandLineMode {
    private static final Log LOG = LogFactory.getLog(GenericToolsDriver.class);
    private String mode;
    private JSAP jsap;
    private String[] args;
    private final Map<String, Class> MODES_MAP = new HashMap<String, Class>();
    private final Map<String, Class> SHORT_MODES_MAP = new HashMap<String, Class>();
    private final Map<Class, String> SHORT_MODES_REVERSE_MAP = new HashMap<Class, String>();
    protected final Map<String, String> HELP_VALUES;

    @Override
    public String getModeName() {
        return null;
    }

    @Override
    public String getModeDescription() {
        return null;
    }

    public GenericToolsDriver(String jarFilename) {
        super(jarFilename);
        this.loadModeMap();
        this.HELP_VALUES = new HashMap<String, String>();
        StringBuilder modesList = new StringBuilder();
        ArrayList<String> modes = new ArrayList<String>(this.MODES_MAP.keySet());
        Collections.sort(modes);
        for (String mode : modes) {
            modesList.append("* ").append(mode);
            Class modeClass = this.MODES_MAP.get(mode);
            String shortMode = this.SHORT_MODES_REVERSE_MAP.get(modeClass);
            if (shortMode != null) {
                modesList.append(" (").append(shortMode).append(")");
            }
            modesList.append('\n');
        }
        this.HELP_VALUES.put("[MODES_LIST]", modesList.toString());
    }

    @Override
    public void printUsage(JSAP jsapVal) {
        try {
            System.err.println("java -jar " + this.getJarFilename() + " " + jsapVal.getUsage());
            System.err.println();
            System.err.println(jsapVal.getHelp());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public GenericToolsDriver configure(String[] argsVal) throws IOException, JSAPException {
        this.jsap = this.loadJsapFromResource(this.HELP_VALUES);
        this.args = argsVal;
        JSAPResult jsapResult = this.parseJsap(this.jsap, this.args);
        this.mode = jsapResult.getString("mode");
        if (this.mode == null) {
            this.unregisterFormattedHelp(this.jsap);
            this.printUsage(this.jsap);
            System.exit(1);
        }
        return this;
    }

    private void unregisterFormattedHelp(JSAP jsapVal) {
        Parameter wikiHelpId;
        Parameter htmlHelpId = jsapVal.getByID("htmlhelp");
        if (htmlHelpId != null) {
            jsapVal.unregisterParameter(htmlHelpId);
        }
        if ((wikiHelpId = jsapVal.getByID("wikihelp")) != null) {
            jsapVal.unregisterParameter(wikiHelpId);
        }
    }

    @Override
    public void execute() throws IOException {
        Class modeClass = this.MODES_MAP.get(this.mode);
        if (modeClass == null) {
            modeClass = this.SHORT_MODES_MAP.get(this.mode);
        }
        Exception caught = null;
        try {
            if (modeClass != null) {
                AbstractCommandLineMode modeObject = (AbstractCommandLineMode)modeClass.newInstance();
                modeObject.configure(this.args);
                modeObject.execute();
            }
        }
        catch (JSAPException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (InstantiationException e) {
            caught = e;
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            System.err.println("\n!!\n!! An out of memory exception was thrown.!! Try running with more memory such as -Xmx1200m -XX:PermSize=384m\n!!\n");
            throw e;
        }
        if (modeClass == null || caught != null) {
            if (modeClass == null) {
                System.err.println("Unrecognized mode: '" + this.mode + "'");
                this.unregisterFormattedHelp(this.jsap);
            }
            this.printUsage(this.jsap);
            if (caught != null) {
                System.err.println();
                System.err.println("Exception caught type=" + caught.getClass().toString());
                System.err.println("   Message=" + caught.getMessage());
                caught.printStackTrace(System.err);
            }
            System.exit(1);
        }
        System.exit(0);
    }

    private void loadModeMap() {
        Map<String, Class> modeMap = this.MODES_MAP;
        Map<String, Class> shortModeMap = this.SHORT_MODES_MAP;
        Map<Class, String> shortModeReverseMap = this.SHORT_MODES_REVERSE_MAP;
        HashSet<String> allShortModes = new HashSet<String>();
        for (String modeClassName : this.modesClassNamesList()) {
            try {
                Object modeInstance;
                LOG.debug("About to process modeClassName: " + modeClassName);
                Class<?> modeClass = Class.forName(modeClassName);
                if (Modifier.isAbstract(modeClass.getModifiers()) || !((modeInstance = modeClass.newInstance()) instanceof AbstractCommandLineMode)) continue;
                String modeName = ((AbstractCommandLineMode)modeInstance).getModeName();
                String shortModeName = ((AbstractCommandLineMode)modeInstance).getShortModeName();
                if (modeName == null) continue;
                modeMap.put(modeName, modeClass);
                if (shortModeName == null) continue;
                if (!allShortModes.contains(shortModeName)) {
                    shortModeMap.put(shortModeName, modeClass);
                    shortModeReverseMap.put(modeClass, shortModeName);
                    allShortModes.add(shortModeName);
                    continue;
                }
                shortModeReverseMap.remove(shortModeMap.get(shortModeName));
                shortModeMap.remove(shortModeName);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Could find a class for " + modeClassName + " ClassNotFoundException: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                System.err.println("Could not find MODE_NAME for class " + modeClassName + " IllegalAccessException: " + e.getMessage());
            }
            catch (InstantiationException e) {
                System.err.println("Could not find MODE_NAME for class " + modeClassName + " InstantiationException: " + e.getMessage());
            }
        }
    }

    private List<String> modesClassNamesList() {
        LinkedList<String> modesList = new LinkedList<String>();
        try {
            String[] files;
            String modesPackage = ClassUtils.getPackageName(this.getClass());
            for (String file : files = new ResourceFinder().getResourceListing(this.getClass())) {
                if (!file.endsWith("Mode.class")) continue;
                String modeClassName = modesPackage + "." + file.substring(0, file.length() - 6);
                modesList.add(modeClassName);
            }
        }
        catch (URISyntaxException e) {
            System.err.println("Could not list mode class names URISyntaxException: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Could not list mode class names IOException: " + e.getMessage());
            e.printStackTrace();
        }
        return modesList;
    }
}

